/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios;

import java.util.Vector;
import org.alfresco.jlan.netbios.NetBIOSName;

public class NetBIOSNameList {
    private Vector<NetBIOSName> m_nameList = new Vector();
    private byte[] m_mac = null;

    public final boolean hasMACAddress() {
        return this.m_mac != null;
    }

    public final byte[] getMACAddress() {
        return this.m_mac;
    }

    public final String getMACAddressString() {
        String macAddrStr = null;
        if (this.hasMACAddress()) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < this.m_mac.length; ++i) {
                int val = this.m_mac[i] & 0xFF;
                if (val < 16) {
                    str.append("0");
                }
                str.append(Integer.toHexString(val));
                str.append(":");
            }
            if (str.length() > 0) {
                str.setLength(str.length() - 1);
            }
            macAddrStr = str.toString();
        }
        return macAddrStr;
    }

    public final void setMACAddress(byte[] mac) {
        this.m_mac = mac;
    }

    public final void addName(NetBIOSName name) {
        this.m_nameList.add(name);
    }

    public final NetBIOSName getName(int idx) {
        if (idx < this.m_nameList.size()) {
            return this.m_nameList.get(idx);
        }
        return null;
    }

    public final int numberOfNames() {
        return this.m_nameList.size();
    }

    public final NetBIOSNameList findNames(String name) {
        NetBIOSNameList subList = new NetBIOSNameList();
        for (int i = 0; i < this.m_nameList.size(); ++i) {
            NetBIOSName nbName = this.getName(i);
            if (nbName.getName().compareTo(name) != 0) continue;
            subList.addName(nbName);
        }
        return subList;
    }

    public final NetBIOSName findName(char typ, boolean group) {
        for (int i = 0; i < this.m_nameList.size(); ++i) {
            NetBIOSName name = this.getName(i);
            if (name.getType() != typ || name.isGroupName() != group) continue;
            return name;
        }
        return null;
    }

    public final NetBIOSName findName(String name, char typ, boolean group) {
        for (int i = 0; i < this.m_nameList.size(); ++i) {
            NetBIOSName nbName = this.getName(i);
            if (!nbName.getName().equals(name) || nbName.getType() != typ || nbName.isGroupName() != group) continue;
            return nbName;
        }
        return null;
    }

    public final NetBIOSNameList findNames(char typ, boolean group) {
        NetBIOSNameList subList = new NetBIOSNameList();
        for (int i = 0; i < this.m_nameList.size(); ++i) {
            NetBIOSName name = this.getName(i);
            if (name.getType() != typ || name.isGroupName() != group) continue;
            subList.addName(name);
        }
        return subList;
    }

    public final NetBIOSName removeName(NetBIOSName name) {
        for (int i = 0; i < this.m_nameList.size(); ++i) {
            NetBIOSName curName = this.getName(i);
            if (!curName.equals(name)) continue;
            this.m_nameList.removeElementAt(i);
            return curName;
        }
        return null;
    }

    public final void removeAllNames() {
        this.m_nameList.removeAllElements();
    }
}

