/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkSettings {
    private static String m_broadcastMask;
    private static String m_domain;
    private static InetAddress m_subnetAddr;

    public static String GenerateBroadcastMask(String addr) throws UnknownHostException {
        int dotPos;
        if (m_broadcastMask != null) {
            return m_broadcastMask;
        }
        String localIP = addr;
        if (localIP == null) {
            localIP = InetAddress.getLocalHost().getHostAddress();
        }
        if ((dotPos = localIP.indexOf(46)) != -1) {
            String ipStr = localIP.substring(0, dotPos);
            int ipVal = Integer.valueOf(ipStr);
            if (ipVal <= 127) {
                m_broadcastMask = "" + ipVal + ".255.255.255";
            } else if (ipVal <= 191) {
                ++dotPos;
                while (localIP.charAt(dotPos) != '.' && dotPos < localIP.length()) {
                    ++dotPos;
                }
                if (dotPos < localIP.length()) {
                    m_broadcastMask = localIP.substring(0, dotPos) + ".255.255";
                }
            } else if (ipVal <= 223) {
                ++dotPos;
                int dotCnt = 1;
                while (dotCnt < 3 && dotPos < localIP.length()) {
                    if (localIP.charAt(dotPos++) != '.') continue;
                    ++dotCnt;
                }
                if (dotPos < localIP.length()) {
                    m_broadcastMask = localIP.substring(0, dotPos - 1) + ".255";
                }
            }
        }
        if (m_broadcastMask == null) {
            m_broadcastMask = "255.255.255.255";
        }
        return m_broadcastMask;
    }

    public static final InetAddress getBroadcastAddress() throws UnknownHostException {
        if (m_subnetAddr == null) {
            String subnet = NetworkSettings.GenerateBroadcastMask(null);
            m_subnetAddr = InetAddress.getByName(subnet);
        }
        return m_subnetAddr;
    }

    public static String getBroadcastMask() {
        return m_broadcastMask;
    }

    public static String getDomain() {
        return m_domain;
    }

    public static boolean hasBroadcastMask() {
        return m_broadcastMask != null;
    }

    public static void setBroadcastMask(String mask) {
        m_broadcastMask = mask;
    }

    public static void setDomain(String domain) {
        m_domain = domain;
    }
}

