/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.netbios.win32;

public class WinsockError {
    public static final int WsaEIntr = 10004;
    public static final int WsaEAcces = 10013;
    public static final int WsaEFault = 10014;
    public static final int WsaEInval = 10022;
    public static final int WsaEMfile = 10024;
    public static final int WsaEWouldBlock = 10035;
    public static final int WsaEInProgress = 10036;
    public static final int WsaEAlready = 10037;
    public static final int WsaENotSock = 10038;
    public static final int WsaEDestAddrReq = 10039;
    public static final int WsaEMsgSize = 10040;
    public static final int WsaEPrototype = 10041;
    public static final int WsaENoProtoOpt = 10042;
    public static final int WsaEProtoNoSupp = 10043;
    public static final int WsaESocktNoSupp = 10044;
    public static final int WsaEOpNotSupp = 10045;
    public static final int WsaEPFNoSupport = 10046;
    public static final int WsaEAFNoSupport = 10047;
    public static final int WsaEAddrInUse = 10048;
    public static final int WsaEAddrNotAvail = 10049;
    public static final int WsaENetDown = 10050;
    public static final int WsaENetUnReach = 10051;
    public static final int WsaENetReset = 10052;
    public static final int WsaEConnAborted = 10053;
    public static final int WsaEConnReset = 10054;
    public static final int WsaENoBufs = 10055;
    public static final int WsaEIsConn = 10056;
    public static final int WsaENotConn = 10057;
    public static final int WsaEShutdown = 10058;
    public static final int WsaETimedout = 10060;
    public static final int WsaEConnRefused = 10061;
    public static final int WsaEHostDown = 10064;
    public static final int WsaEHostUnreach = 10065;
    public static final int WsaEProcLim = 10067;
    public static final int WsaSysNotReady = 10091;
    public static final int WsaVerNotSupp = 10092;
    public static final int WsaNotInit = 10093;
    public static final int WsaEDiscon = 10101;
    public static final int WsaTypeNotFound = 10109;
    public static final int WsaHostNotFound = 11001;
    public static final int WsaTryAgain = 11002;
    public static final int WsaNoRecovery = 11003;
    public static final int WsaNoData = 11004;

    public static final String asString(int sts) {
        String errText = null;
        switch (sts) {
            case 10004: {
                errText = "Interrupted function call";
                break;
            }
            case 10013: {
                errText = "Permission denied";
                break;
            }
            case 10014: {
                errText = "Bad address";
                break;
            }
            case 10022: {
                errText = "Invalid argument";
                break;
            }
            case 10024: {
                errText = "Too many open files";
                break;
            }
            case 10035: {
                errText = "Resource temporarily unavailable";
                break;
            }
            case 10036: {
                errText = "Operation now in progress";
                break;
            }
            case 10037: {
                errText = "Operation already in progress";
                break;
            }
            case 10038: {
                errText = "Socket operation on nonsocket";
                break;
            }
            case 10039: {
                errText = "Destination address required";
                break;
            }
            case 10040: {
                errText = "Message too long";
                break;
            }
            case 10041: {
                errText = "Protocol wrong type for socket";
                break;
            }
            case 10042: {
                errText = "Bad protocol option";
                break;
            }
            case 10043: {
                errText = "Protocol not supported";
                break;
            }
            case 10044: {
                errText = "Socket type not supported";
                break;
            }
            case 10045: {
                errText = "Operation not supported";
                break;
            }
            case 10046: {
                errText = "Protocol family not supported";
                break;
            }
            case 10047: {
                errText = "Address family not supported by protocol family";
                break;
            }
            case 10048: {
                errText = "Address already in use";
                break;
            }
            case 10049: {
                errText = "Cannot assign requested address";
                break;
            }
            case 10050: {
                errText = "Network is down";
                break;
            }
            case 10051: {
                errText = "Network is unreachable";
                break;
            }
            case 10052: {
                errText = "Network dropped connection on reset";
                break;
            }
            case 10053: {
                errText = "Software caused connection abort";
                break;
            }
            case 10054: {
                errText = "Connection reset by peer";
                break;
            }
            case 10055: {
                errText = "No buffer space available";
                break;
            }
            case 10056: {
                errText = "Socket is already connected";
                break;
            }
            case 10057: {
                errText = "Socket is not connected";
                break;
            }
            case 10058: {
                errText = "Cannot send after socket shutdown";
                break;
            }
            case 10060: {
                errText = "Connection timed out";
                break;
            }
            case 10061: {
                errText = "Connection refused";
                break;
            }
            case 10064: {
                errText = "Host is down";
                break;
            }
            case 10065: {
                errText = "No route to host";
                break;
            }
            case 10067: {
                errText = "Too many processes";
                break;
            }
            case 10091: {
                errText = "Network subsystem is unavailable";
                break;
            }
            case 10092: {
                errText = "Winsock.dll version out of range";
                break;
            }
            case 10093: {
                errText = "Successful WSAStartup not yet performed";
                break;
            }
            case 10101: {
                errText = "Graceful shutdown in progress";
                break;
            }
            case 10109: {
                errText = "Class type not found";
                break;
            }
            case 11001: {
                errText = "Host not found";
                break;
            }
            case 11002: {
                errText = "Nonauthoritative host not found";
                break;
            }
            case 11003: {
                errText = "This is a nonrecoverable error";
                break;
            }
            case 11004: {
                errText = "Valid name, no data record of requested type";
                break;
            }
            default: {
                errText = "Unknown Winsock error 0x" + Integer.toHexString(sts);
            }
        }
        return errText;
    }
}

