/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import java.net.InetAddress;
import java.util.Date;

public class PassthruServerDetails {
    private String m_name;
    private String m_domain;
    private InetAddress m_address;
    private boolean m_online;
    private int m_authCount;
    private long m_lastAuthTime;

    PassthruServerDetails(String name, String domain, InetAddress addr, boolean online) {
        this.m_name = name;
        this.m_domain = domain;
        this.m_address = addr;
        this.m_online = online;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final InetAddress getAddress() {
        return this.m_address;
    }

    public final boolean isOnline() {
        return this.m_online;
    }

    public final int getAuthenticationCount() {
        return this.m_authCount;
    }

    public final long getAuthenticationDateTime() {
        return this.m_lastAuthTime;
    }

    public final void setDomain(String domain) {
        this.m_domain = domain;
    }

    public final void setOnline(boolean online) {
        this.m_online = online;
    }

    public final synchronized void incrementAuthenticationCount() {
        ++this.m_authCount;
        this.m_lastAuthTime = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.m_address.hashCode();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        if (this.getDomain() != null) {
            str.append(this.getDomain());
            str.append("\\");
        }
        str.append(this.getName());
        str.append(":");
        str.append(this.getAddress().getHostAddress());
        str.append(this.isOnline() ? ":Online" : ":Offline");
        str.append(":");
        str.append(this.getAuthenticationCount());
        str.append(",");
        str.append(this.getAuthenticationDateTime() != 0L ? new Date(this.getAuthenticationDateTime()).toString() : "0");
        str.append("]");
        return str.toString();
    }
}

