/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys;

import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.InvalidDeviceInterfaceException;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.FileAccess;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.NetworkFileServer;
import org.alfresco.jlan.server.filesys.TooManyFilesException;

public class TreeConnection {
    public static final int MAXFILES = 8192;
    public static final int INITIALFILES = 32;
    private SharedDevice m_shareDev;
    private NetworkFile[] m_files;
    private int m_fileCount;
    private int m_permission;

    public TreeConnection(SharedDevice shrDev) {
        this.m_shareDev = shrDev;
        this.m_shareDev.incrementConnectionCount();
    }

    public final synchronized int addFile(NetworkFile file, SrvSession sess) throws TooManyFilesException {
        NetworkFileServer fileSrv;
        int idx;
        if (this.m_files == null) {
            this.m_files = new NetworkFile[32];
        }
        for (idx = 0; idx < this.m_files.length && this.m_files[idx] != null; ++idx) {
        }
        if (idx == this.m_files.length) {
            if (this.m_files.length >= 8192) {
                throw new TooManyFilesException();
            }
            NetworkFile[] newFiles = new NetworkFile[this.m_files.length * 2];
            System.arraycopy(this.m_files, 0, newFiles, 0, this.m_files.length);
            this.m_files = newFiles;
        }
        if ((fileSrv = (NetworkFileServer)sess.getServer()) != null) {
            fileSrv.fireOpenFileEvent(sess, file);
        }
        this.m_files[idx] = file;
        ++this.m_fileCount;
        file.setProtocolId(idx);
        return idx;
    }

    public final void closeConnection(SrvSession sess) {
        if (this.openFileCount() > 0) {
            for (int idx = 0; idx < this.m_files.length; ++idx) {
                if (this.m_files[idx] == null) continue;
                this.removeFile(idx, sess);
            }
        }
        this.m_shareDev.decrementConnectionCount();
    }

    public final NetworkFile findFile(int fid) {
        if (this.m_files == null || fid >= this.m_files.length) {
            return null;
        }
        return this.m_files[fid];
    }

    public final int getFileTableLength() {
        if (this.m_files == null) {
            return 0;
        }
        return this.m_files.length;
    }

    public final boolean hasContext() {
        if (this.m_shareDev != null) {
            return this.m_shareDev.getContext() != null;
        }
        return false;
    }

    public final DeviceContext getContext() {
        if (this.m_shareDev == null) {
            return null;
        }
        return this.m_shareDev.getContext();
    }

    public final int getPermission() {
        return this.m_permission;
    }

    public final boolean hasReadAccess() {
        return this.m_permission == 1 || this.m_permission == 2;
    }

    public final boolean hasWriteAccess() {
        return this.m_permission == 2;
    }

    public final SharedDevice getSharedDevice() {
        return this.m_shareDev;
    }

    public final DeviceInterface getInterface() {
        if (this.m_shareDev == null) {
            return null;
        }
        try {
            return this.m_shareDev.getInterface();
        }
        catch (InvalidDeviceInterfaceException invalidDeviceInterfaceException) {
            return null;
        }
    }

    public final boolean hasPermission(int perm) {
        return this.m_permission >= perm;
    }

    public final int openFileCount() {
        return this.m_fileCount;
    }

    public final void removeAllFiles() {
        if (this.m_files == null) {
            return;
        }
        int idx = 0;
        while (idx < this.m_files.length) {
            this.m_files[idx++] = null;
        }
        this.m_fileCount = 0;
    }

    public final void removeFile(int idx, SrvSession sess) {
        NetworkFileServer fileSrv;
        if (this.m_files == null || idx >= this.m_files.length) {
            return;
        }
        if (this.m_files[idx] != null && !this.m_files[idx].isClosed()) {
            try {
                DiskInterface disk = (DiskInterface)this.m_shareDev.getInterface();
                disk.closeFile(sess, this, this.m_files[idx]);
                this.m_files[idx].setClosed(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((fileSrv = (NetworkFileServer)sess.getServer()) != null) {
            fileSrv.fireCloseFileEvent(sess, this.m_files[idx]);
        }
        if (this.m_files[idx] != null) {
            this.m_files[idx].setProtocolId(-1);
        }
        this.m_files[idx] = null;
        --this.m_fileCount;
    }

    public final void setPermission(int perm) {
        this.m_permission = perm;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_shareDev.toString());
        str.append(",");
        str.append(this.m_fileCount);
        str.append(":");
        str.append(FileAccess.asString(this.m_permission));
        str.append("]");
        return str.toString();
    }
}

