/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.cache;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.cache.DefaultFileStateFactory;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateFactoryInterface;
import org.alfresco.jlan.server.filesys.cache.FileStateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStateCache {
    private static final int INITIAL_SIZE = 500;
    private static final long DEFAULT_EXPIRECHECK = 3000L;
    private FileStateFactoryInterface m_stateFactory = new DefaultFileStateFactory();
    private Hashtable<String, FileState> m_stateCache = new Hashtable(500);
    private long m_expireInterval = 3000L;
    private long m_cacheTimer = 300000L;
    private FileStateListener m_stateListener;
    private boolean m_caseSensitive = true;
    private boolean m_debug = false;

    public final long getCheckInterval() {
        return this.m_expireInterval;
    }

    public final long getCacheTimer() {
        return this.m_cacheTimer;
    }

    public final boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public final int numberOfStates() {
        return this.m_stateCache.size();
    }

    public final void setCacheTimer(long tmo) {
        this.m_cacheTimer = tmo;
    }

    public final void setCheckInterval(long chkIntval) {
        this.m_expireInterval = chkIntval;
    }

    public final void setCaseSensitive(boolean caseSensitive) {
        this.m_caseSensitive = caseSensitive;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    public final synchronized void addFileState(FileState fstate) {
        if (this.hasDebug() && this.m_stateCache.get(fstate.getPath()) != null) {
            Debug.println("***** addFileState() state=" + fstate.toString() + " - ALREADY IN CACHE *****");
        }
        if (fstate == null) {
            Debug.println("addFileState() NULL FileState");
            return;
        }
        fstate.setExpiryTime(System.currentTimeMillis() + this.getCacheTimer());
        this.m_stateCache.put(fstate.getPath(), fstate);
    }

    public final synchronized FileState findFileState(String path) {
        return this.m_stateCache.get(FileState.normalizePath(path, this.isCaseSensitive()));
    }

    public final synchronized FileState findFileState(String path, boolean create) {
        FileState state = this.m_stateCache.get(FileState.normalizePath(path, this.isCaseSensitive()));
        if (state == null && create) {
            state = this.m_stateFactory.createFileState(path, this.isCaseSensitive());
            state.setExpiryTime(System.currentTimeMillis() + this.getCacheTimer());
            this.m_stateCache.put(state.getPath(), state);
        }
        return state;
    }

    public final synchronized FileState findFileState(String path, boolean create, int status) {
        FileState state = this.m_stateCache.get(FileState.normalizePath(path, this.isCaseSensitive()));
        if (state == null && create) {
            state = this.m_stateFactory.createFileState(path, this.isCaseSensitive());
            state.setExpiryTime(System.currentTimeMillis() + this.getCacheTimer());
            state.setFileStatus(status);
            this.m_stateCache.put(state.getPath(), state);
        }
        return state;
    }

    public final synchronized FileState updateFileState(String oldName, String newName) {
        FileState state = this.m_stateCache.remove(FileState.normalizePath(oldName, this.isCaseSensitive()));
        if (state != null) {
            state.setPath(newName, this.isCaseSensitive());
            this.addFileState(state);
        }
        return state;
    }

    public final Enumeration<String> enumerate() {
        return this.m_stateCache.keys();
    }

    public final synchronized FileState removeFileState(String path) {
        FileState state = this.m_stateCache.remove(FileState.normalizePath(path, this.isCaseSensitive()));
        if (this.m_stateListener != null && state != null) {
            this.m_stateListener.fileStateClosed(state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void renameFileState(String newPath, FileState state, boolean isDir) {
        String oldPath = state.getPath();
        Hashtable<String, FileState> hashtable = this.m_stateCache;
        synchronized (hashtable) {
            this.m_stateCache.remove(state.getPath());
            state.setPath(newPath, this.isCaseSensitive());
            state.setFileStatus(isDir ? 2 : 1);
            this.m_stateCache.put(state.getPath(), state);
        }
        if (isDir) {
            if (!oldPath.endsWith("\\")) {
                oldPath = oldPath + "\\";
            }
            oldPath = oldPath.toUpperCase();
            Enumeration<String> enm = this.enumerate();
            while (enm.hasMoreElements()) {
                String statePath = enm.nextElement();
                if (statePath.length() <= oldPath.length() || !statePath.startsWith(oldPath)) continue;
                FileState renState = this.m_stateCache.remove(statePath);
                renState.setFileStatus(0);
                renState.setFileId(-1);
                this.m_stateCache.put(renState.getPath(), renState);
                if (!this.hasDebug()) continue;
                Debug.println("++ Rename update " + statePath);
            }
        }
    }

    public final synchronized void removeAllFileStates() {
        if (this.m_stateCache == null || this.m_stateCache.size() == 0) {
            return;
        }
        Enumeration<String> enm = this.m_stateCache.keys();
        while (enm.hasMoreElements()) {
            FileState state = this.m_stateCache.get(enm.nextElement());
            if (this.m_stateListener != null) {
                this.m_stateListener.fileStateClosed(state);
            }
            if (!this.hasDebug()) continue;
            Debug.println("++ Closed: " + state.getPath());
        }
        this.m_stateCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int removeExpiredFileStates() {
        if (this.m_stateCache == null || this.m_stateCache.size() == 0) {
            return 0;
        }
        Enumeration<String> enm = this.m_stateCache.keys();
        long curTime = System.currentTimeMillis();
        int expiredCnt = 0;
        int openCnt = 0;
        while (enm.hasMoreElements()) {
            FileState state = this.m_stateCache.get(enm.nextElement());
            if (state == null || state.hasNoTimeout()) continue;
            FileState fileState = state;
            synchronized (fileState) {
                if (state.hasExpired(curTime) && state.getOpenCount() == 0) {
                    if (this.m_stateListener == null || this.m_stateListener.fileStateExpired(state)) {
                        this.m_stateCache.remove(state.getPath());
                        ++expiredCnt;
                    }
                } else if (state.getOpenCount() > 0) {
                    ++openCnt;
                }
            }
        }
        if (this.m_debug && openCnt > 0) {
            Debug.println("++ Open files " + openCnt);
            this.Dump(System.out, false);
        }
        return expiredCnt;
    }

    public final void addStateListener(FileStateListener l) {
        this.m_stateListener = l;
    }

    public final void removeStateListener(FileStateListener l) {
        if (this.m_stateListener == l) {
            this.m_stateListener = null;
        }
    }

    public final void setFileStateFactory(FileStateFactoryInterface factory) {
        this.m_stateFactory = factory;
    }

    public final void Dump(PrintStream out, boolean dumpAttribs) {
        if (this.m_stateCache.size() > 0) {
            out.println("++ FileStateCache Entries:");
        }
        Enumeration<String> enm = this.m_stateCache.keys();
        long curTime = System.currentTimeMillis();
        while (enm.hasMoreElements()) {
            String fname = enm.nextElement();
            FileState state = this.m_stateCache.get(fname);
            out.println("++  " + fname + "(" + state.getSecondsToExpire(curTime) + ") : " + state.toString());
            if (!dumpAttribs) continue;
            state.DumpAttributes(out);
        }
    }
}

