/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.File;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.CoreServerConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateLockManager;
import org.alfresco.jlan.server.filesys.db.DBException;
import org.alfresco.jlan.server.filesys.db.DBFileInfo;
import org.alfresco.jlan.server.filesys.db.DBInterface;
import org.alfresco.jlan.server.filesys.db.DBQuotaManager;
import org.alfresco.jlan.server.filesys.loader.DeleteFileRequest;
import org.alfresco.jlan.server.filesys.loader.FileLoader;
import org.alfresco.jlan.server.filesys.loader.FileRequestQueue;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class DBDeviceContext
extends DiskDeviceContext {
    public static final long DEFAULT_CACHETIMEOUT = 300000L;
    public static final long MIN_CACHETIMEOUT = 5000L;
    public static final long MAX_CACHETIMEOUT = 3600000L;
    public static final long DEFAULT_CACHECHECK = 60000L;
    public static final long MIN_CACHECHECK = 2000L;
    public static final long MAX_CACHECHECK = 1200000L;
    private static final long MillisecondsPerDay = 86400000L;
    private static final long MinimumMaxfileSize = 524288L;
    private long m_cacheTimer = 300000L;
    private long m_cacheCheckInterval = 60000L;
    private boolean m_ntfsStreams = true;
    private String m_dbifClass;
    private DBInterface m_dbInterface;
    private ConfigElement m_dbifConfig;
    private String m_loaderClass;
    private FileLoader m_loader;
    private ConfigElement m_loaderConfig;
    private boolean m_trashCan;
    private long m_retentionPeriod = -1L;
    private int m_dbFeatures;
    private DBFileInfo m_rootInfo;
    private long m_maxFileSize;
    private boolean m_offlineFiles;
    private long m_offlineFileSize;
    private FileRequestQueue m_offlineDeleteList;
    private FileStateLockManager m_lockManager;
    private boolean m_oplocksEnabled = true;
    private boolean m_debug;

    public DBDeviceContext(ConfigElement args) throws DeviceContextException {
        this.initialize(args);
    }

    public DBDeviceContext(String name, ConfigElement args) throws DeviceContextException {
        this.setShareName(name);
        this.initialize(args);
    }

    protected final void initialize(ConfigElement args) throws DeviceContextException {
        String cacheCheck;
        String cacheTmo;
        this.setFilesystemAttributes(3);
        ConfigElement dbParams = args.getChild("DatabaseInterface");
        if (dbParams != null) {
            ConfigElement dbClass = dbParams.getChild("class");
            if (dbClass == null) {
                throw new DeviceContextException("Database interface class not specified");
            }
            try {
                Object dbObj = Class.forName(dbClass.getValue()).newInstance();
                if (!(dbObj instanceof DBInterface)) {
                    throw new DeviceContextException("Database interface class is not an instance of DBInterface");
                }
                this.m_dbifClass = dbClass.getValue();
                this.m_dbInterface = (DBInterface)dbObj;
                this.m_dbifConfig = dbParams;
            }
            catch (Exception ex) {
                throw new DeviceContextException("Database interface error, " + ex.toString());
            }
        } else {
            throw new DeviceContextException("Invalid Database Interface configuration");
        }
        ConfigElement ldrParams = args.getChild("FileLoader");
        if (ldrParams != null) {
            this.m_loaderConfig = ldrParams;
            ConfigElement ldrClass = this.m_loaderConfig.getChild("class");
            if (ldrClass == null || ldrClass.getValue().length() == 0) {
                throw new DeviceContextException("Invalid File Loader configuration");
            }
            this.m_loaderClass = ldrClass.getValue();
        } else if (this.m_dbInterface instanceof FileLoader) {
            this.m_loader = (FileLoader)((Object)this.m_dbInterface);
        }
        ConfigElement nameVal = args.getChild("CacheTime");
        if (nameVal != null && (cacheTmo = nameVal.getValue()) != null) {
            try {
                this.m_cacheTimer = Long.valueOf(cacheTmo) * 1000L;
                if (this.m_cacheTimer < 5000L) {
                    this.m_cacheTimer = 5000L;
                } else if (this.m_cacheTimer > 3600000L) {
                    this.m_cacheTimer = 3600000L;
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if ((nameVal = args.getChild("CacheCheckInterval")) != null && (cacheCheck = nameVal.getValue()) != null) {
            try {
                this.m_cacheCheckInterval = Long.valueOf(cacheCheck) * 1000L;
                if (this.m_cacheCheckInterval < 2000L) {
                    this.m_cacheCheckInterval = 2000L;
                } else if (this.m_cacheCheckInterval > 1200000L) {
                    this.m_cacheCheckInterval = 1200000L;
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (args.getChild("Debug") != null) {
            this.m_debug = true;
        }
        if (args.getChild("disableNTFSStreams") != null) {
            this.m_ntfsStreams = false;
        }
        if (args.getChild("enableTrashCan") != null) {
            this.m_trashCan = true;
        }
        if (args.getChild("offlineFiles") != null) {
            this.m_offlineFiles = true;
        }
        if (args.getChild("disableOplocks") != null) {
            this.m_oplocksEnabled = false;
        }
        if ((nameVal = args.getChild("offlineFileSize")) != null) {
            try {
                this.m_offlineFileSize = MemorySize.getByteValue(nameVal.getValue());
                if (this.m_offlineFileSize < 0L) {
                    throw new DeviceContextException("Invalid offline files size, " + nameVal.getValue());
                }
                this.m_offlineFiles = true;
            }
            catch (NumberFormatException ex) {
                throw new DeviceContextException("Invalid offline files size, " + nameVal.getValue());
            }
        }
        if ((nameVal = args.getChild("MaxFileSize")) != null) {
            try {
                this.m_maxFileSize = MemorySize.getByteValue(nameVal.getValue());
                if (this.m_maxFileSize < 524288L) {
                    throw new DeviceContextException("Maximum file size is below minimum allowed setting (512K)");
                }
            }
            catch (NumberFormatException ex) {
                throw new DeviceContextException("Invalid maximum file size value, " + nameVal.getValue());
            }
        }
        if (args.getChild("QuotaManagement") != null) {
            boolean quotaDebug = args.getChild("QuotaDebug") != null;
            this.setQuotaManager(new DBQuotaManager(this, quotaDebug));
        }
        if ((nameVal = args.getChild("RetentionPeriod")) != null) {
            try {
                long retainDays = Long.parseLong(nameVal.getValue());
                if (retainDays < 0L || retainDays > 3650L) {
                    throw new DeviceContextException("RetentionPeriod out of valid range (0 - 3650)");
                }
                this.m_retentionPeriod = retainDays * 86400000L;
            }
            catch (NumberFormatException ex) {
                throw new DeviceContextException("RetentionPeriod is invalid, " + nameVal.getValue());
            }
        }
        if (this.hasRetentionPeriod() && !this.getDBInterface().supportsFeature(2)) {
            throw new DeviceContextException("Database interface does not support retention");
        }
        int dbFeatures = 0;
        if (this.m_loaderClass != null) {
            try {
                this.m_loader = (FileLoader)Class.forName(this.m_loaderClass).newInstance();
                dbFeatures = this.m_loader.getRequiredDBFeatures();
                this.m_loader.setContext(this);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println(ex);
                }
                throw new DeviceContextException(ex.getMessage());
            }
        } else if (this.m_loader == null) {
            throw new DeviceContextException("File loader not specified");
        }
        this.m_rootInfo = new DBFileInfo("\\", "\\", 0, 0);
        this.m_rootInfo.setFileAttributes(16);
        this.m_rootInfo.setMode(493);
        this.m_rootInfo.setGid(0);
        this.m_rootInfo.setUid(0);
        long timeNow = System.currentTimeMillis();
        this.m_rootInfo.setCreationDateTime(timeNow);
        this.m_rootInfo.setAccessDateTime(timeNow);
        this.m_rootInfo.setModifyDateTime(timeNow);
        this.m_rootInfo.setChangeDateTime(timeNow);
        this.enableStateCache(true);
        this.m_lockManager = new FileStateLockManager(this.getStateCache());
        if (this.hasNTFSStreamsEnabled() && this.m_loader.supportsStreams()) {
            dbFeatures |= 1;
        }
        if (this.hasRetentionPeriod()) {
            dbFeatures |= 2;
        }
        if (this.getDBInterface().supportsFeature(64)) {
            dbFeatures |= 0x40;
        }
        try {
            this.getDBInterface().requestFeatures(dbFeatures);
        }
        catch (DBException ex) {
            throw new DeviceContextException("Failed to enable database features, " + ex.getMessage());
        }
        try {
            this.getDBInterface().initializeDatabase(this, this.m_dbifConfig);
        }
        catch (InvalidConfigurationException ex) {
            throw new DeviceContextException("Database interface initialization failure, " + ex.toString());
        }
        this.getStateCache().setCacheTimer(this.m_cacheTimer);
        this.getStateCache().setCheckInterval(Math.max(5000L, this.m_cacheTimer / 4L));
        if (this.m_loaderClass != null) {
            try {
                this.m_loader.initializeLoader(this.m_loaderConfig, this);
            }
            catch (Exception ex) {
                if (this.hasDebug()) {
                    Debug.println(ex);
                }
                throw new DeviceContextException(ex.getMessage());
            }
        }
        if (this.hasNTFSStreamsEnabled()) {
            this.setFilesystemAttributes(this.getFilesystemAttributes() + 262144);
        }
    }

    public final String getDBInterfaceClass() {
        return this.m_dbifClass;
    }

    public final DBInterface getDBInterface() {
        return this.m_dbInterface;
    }

    public final ConfigElement getDBInterfaceConfiguration() {
        return this.m_dbifConfig;
    }

    public final String getFileLoaderClass() {
        return this.m_loaderClass;
    }

    public final FileLoader getFileLoader() {
        return this.m_loader;
    }

    public final ConfigElement getLoaderConfiguration() {
        return this.m_loaderConfig;
    }

    public final long getCacheTimeout() {
        return this.m_cacheTimer;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasOfflineFiles() {
        return this.m_offlineFiles;
    }

    public final boolean hasOfflineFileSize() {
        return this.m_offlineFileSize > 0L;
    }

    public final long getOfflineFileSize() {
        return this.m_offlineFileSize;
    }

    public FileStateLockManager getLockManager() {
        return this.m_lockManager;
    }

    public final boolean isOpLocksEnabled() {
        return this.m_oplocksEnabled;
    }

    public final boolean hasRetentionPeriod() {
        return this.m_retentionPeriod != -1L;
    }

    public final long getRetentionPeriod() {
        return this.m_retentionPeriod;
    }

    public final DBFileInfo getRootDirectoryInfo() {
        return this.m_rootInfo;
    }

    public final boolean hasNTFSStreamsEnabled() {
        return this.m_ntfsStreams;
    }

    public final boolean isTrashCanEnabled() {
        return this.m_trashCan;
    }

    public final boolean hasMaximumFileSize() {
        return this.m_maxFileSize != 0L;
    }

    public final long getMaximumFileSize() {
        return this.m_maxFileSize;
    }

    public final boolean hasOfflineFileDeletes() {
        return this.m_offlineDeleteList != null;
    }

    public final synchronized FileRequestQueue getOfflineFileDeletes(boolean clearList) {
        FileRequestQueue deleteList = this.m_offlineDeleteList;
        if (clearList) {
            this.m_offlineDeleteList = null;
        }
        return deleteList;
    }

    public final synchronized void addOfflineFileDelete(DeleteFileRequest deleteReq) {
        if (this.m_offlineDeleteList == null) {
            this.m_offlineDeleteList = new FileRequestQueue();
        }
        this.m_offlineDeleteList.addRequest(deleteReq);
    }

    public boolean fileStateExpired(FileState state) {
        String tempName = (String)state.findAttribute("DBCacheFile");
        if (tempName != null) {
            if (state.getOpenCount() > 0) {
                return false;
            }
            File tempFile = new File(tempName);
            tempFile.delete();
            if (this.m_debug) {
                Debug.println("$$ Deleted temporary file " + tempName + " (Expired) $$");
            }
        }
        return true;
    }

    public void fileStateClosed(FileState state) {
        String tempName = (String)state.findAttribute("DBCacheFile");
        if (tempName != null) {
            File tempFile = new File(tempName);
            tempFile.delete();
            if (this.m_debug) {
                Debug.println("$$ Deleted temporary file " + tempName + " (Closed) $$");
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getDBInterface().getDBInterfaceName());
        str.append(",");
        str.append(this.getFileLoaderClass());
        str.append("]");
        return str.toString();
    }

    public void CloseContext() {
        if (this.getFileLoader() != null) {
            this.getFileLoader().shutdownLoader(false);
        }
        if (this.getDBInterface() != null) {
            this.getDBInterface().shutdownDatabase(this);
        }
        if (this.hasStateCache()) {
            this.getStateCache().removeAllFileStates();
        }
        super.CloseContext();
    }

    public void startFilesystem(DiskSharedDevice disk) throws DeviceContextException {
        if (this.hasQuotaManager()) {
            try {
                this.getQuotaManager().startManager(disk.getDiskInterface(), this);
            }
            catch (QuotaManagerException ex) {
                throw new DeviceContextException(ex.toString());
            }
        }
        if (this.getLockManager() != null) {
            CoreServerConfigSection coreConfig;
            ThreadRequestPool threadPool = null;
            ServerConfiguration config = disk.getConfiguration();
            if (config != null && (coreConfig = (CoreServerConfigSection)config.getConfigSection("CoreServer")) != null) {
                threadPool = coreConfig.getThreadPool();
            }
            this.m_lockManager.startLockManager("OplockExpire_" + disk.getName(), threadPool);
        }
    }
}

