/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.NetworkFileStateInterface;
import org.alfresco.jlan.server.filesys.db.DBFileInfo;
import org.alfresco.jlan.server.filesys.loader.FileLoader;

public abstract class DBNetworkFile
extends NetworkFile
implements NetworkFileStateInterface {
    public static final String DBCacheFile = "DBCacheFile";
    private FileState m_state;
    private FileLoader m_loader;
    private String m_ownerSess;

    public DBNetworkFile(String name, int fid, int stid, int did) {
        super(fid, stid, did);
        this.setName(name);
        this.setUniqueId(fid, did);
    }

    public DBNetworkFile(String name, String fullName, int fid, int stid, int did) {
        super(fid, stid, did);
        this.setName(name);
        this.setFullName(fullName);
        this.setUniqueId(fid, did);
    }

    public final int getStatus() {
        if (this.m_state != null) {
            return this.m_state.getStatus();
        }
        return -1;
    }

    public final boolean hasFileState() {
        return this.m_state != null;
    }

    public final FileState getFileState() {
        return this.m_state;
    }

    public final boolean hasLoader() {
        return this.m_loader != null;
    }

    public final FileLoader getLoader() {
        return this.m_loader;
    }

    public final boolean hasOwnerSessionId() {
        return this.m_ownerSess != null;
    }

    public final String getOwnerSessionId() {
        return this.m_ownerSess;
    }

    public final void setFileDetails(DBFileInfo info) {
        this.setFileId(info.getFileId());
        this.setName(info.getFileName());
        this.setFullName(info.getFullName());
        this.setDirectoryId(info.getDirectoryId());
        this.setFileSize(info.getSize());
        this.setAttributes(info.getFileAttributes());
        if (info.getCreationDateTime() != 0L) {
            this.setCreationDate(info.getCreationDateTime());
        }
        if (info.getModifyDateTime() != 0L) {
            this.setModifyDate(info.getModifyDateTime());
        }
    }

    public final void setStatus(int state) {
        if (this.m_state != null) {
            this.m_state.setStatus(state);
        }
    }

    public final void setOwnerSessionId(String id) {
        this.m_ownerSess = id;
    }

    public final void setFileState(FileState state) {
        this.m_state = state;
    }

    public final void setLoader(FileLoader loader) {
        this.m_loader = loader;
    }
}

