/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskFullException;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.db.DBDeviceContext;
import org.alfresco.jlan.server.filesys.quota.QuotaManager;
import org.alfresco.jlan.server.filesys.quota.QuotaManagerException;
import org.alfresco.jlan.util.MemorySize;

public class DBQuotaManager
implements QuotaManager {
    private SrvDiskInfo m_diskInfo;
    private long m_totalSpace;
    private long m_freeSpace;
    private boolean m_debug;

    public DBQuotaManager(DBDeviceContext ctx, boolean dbg) {
        this.setDebug(dbg);
    }

    public synchronized long allocateSpace(SrvSession sess, TreeConnection tree, NetworkFile file, long alloc) throws IOException {
        if (this.m_freeSpace > alloc && alloc > 0L) {
            this.m_freeSpace -= alloc;
            if (this.hasDebug()) {
                Debug.println("JDBCQuotaManager: Allocate=" + alloc + ", free=" + MemorySize.asScaledString(this.m_freeSpace));
            }
        } else {
            throw new DiskFullException();
        }
        return alloc;
    }

    public synchronized void releaseSpace(SrvSession sess, TreeConnection tree, int fid, String path, long alloc) throws IOException {
        if (alloc > 0L) {
            this.m_freeSpace += alloc;
            if (this.m_freeSpace > this.m_totalSpace) {
                this.m_freeSpace = this.m_totalSpace;
            }
            if (this.hasDebug()) {
                Debug.println("JDBCQuotaManager: Release=" + alloc + ", free=" + MemorySize.asScaledString(this.m_freeSpace));
            }
        }
    }

    public void startManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
        DBDeviceContext dbCtx = (DBDeviceContext)ctx;
        if (disk instanceof DiskSizeInterface) {
            DiskSizeInterface sizeInterface = (DiskSizeInterface)((Object)disk);
            this.m_diskInfo = new SrvDiskInfo();
            try {
                sizeInterface.getDiskInformation(ctx, this.m_diskInfo);
            }
            catch (IOException ex) {
                this.m_diskInfo = null;
            }
        } else if (dbCtx.hasDiskInformation()) {
            this.m_diskInfo = dbCtx.getDiskInformation();
        }
        if (this.m_diskInfo == null) {
            throw new QuotaManagerException("Disk size information not available");
        }
        this.m_totalSpace = this.m_diskInfo.getDiskSizeKb() * 1024L;
        if (this.m_totalSpace == 0L) {
            throw new QuotaManagerException("Disk size not set");
        }
        long usedSpace = dbCtx.getDBInterface().getUsedFileSpace();
        if (usedSpace == -1L) {
            throw new QuotaManagerException("Failed to calculate used space");
        }
        this.m_freeSpace = this.m_totalSpace - usedSpace;
        if (this.hasDebug()) {
            Debug.println("JDBCQuotaManager: Startup totalSpace=" + MemorySize.asScaledString(this.m_totalSpace) + ", freeSpace=" + MemorySize.asScaledString(this.m_freeSpace));
        }
    }

    public void stopManager(DiskInterface disk, DiskDeviceContext ctx) throws QuotaManagerException {
    }

    public synchronized long getAvailableFreeSpace() {
        return this.m_freeSpace;
    }

    public long getUserFreeSpace(SrvSession sess, TreeConnection tree) {
        return this.m_freeSpace;
    }

    public boolean hasDebug() {
        return this.m_debug;
    }

    public void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }
}

