/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.pseudo;

import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.NetworkFile;

public abstract class PseudoFile {
    protected static long _creationDateTime = System.currentTimeMillis();
    private String m_fileName;
    private int m_fileFlags = 1;
    private FileInfo m_fileInfo;

    protected PseudoFile(String name) {
        this.m_fileName = name;
    }

    protected PseudoFile(String name, int flags) {
        this.m_fileName = name;
        this.m_fileFlags = flags;
    }

    public final String getFileName() {
        return this.m_fileName;
    }

    public final int getAttributes() {
        return this.m_fileFlags;
    }

    public final boolean isFile() {
        return (this.m_fileFlags & 0x10) == 0;
    }

    public final boolean isDirectory() {
        return (this.m_fileFlags & 0x10) != 0;
    }

    public final boolean isReadOnly() {
        return (this.m_fileFlags & 1) != 0;
    }

    public final boolean isHidden() {
        return (this.m_fileFlags & 2) != 0;
    }

    public abstract FileInfo getFileInfo();

    public abstract NetworkFile getFile(String var1);

    protected final void setFileInfo(FileInfo finfo) {
        this.m_fileInfo = finfo;
    }

    protected final FileInfo getInfo() {
        return this.m_fileInfo;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getFileName());
        str.append(",");
        str.append(this.getFileInfo());
        str.append("]");
        return str.toString();
    }
}

