/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.core.NoPooledMemoryException;
import org.alfresco.jlan.server.memory.ByteBufferPool;
import org.alfresco.jlan.smb.server.SMBSrvPacket;

public class CIFSPacketPool {
    public static final long CIFSAllocateWaitTime = 250L;
    private ByteBufferPool m_bufferPool;
    private boolean m_debug;
    private boolean m_allowOverSize = true;
    private int m_maxOverSize = 131072;
    private int m_maxPoolBufSize;

    public CIFSPacketPool(ByteBufferPool bufPool) {
        this.m_bufferPool = bufPool;
        this.m_maxPoolBufSize = this.m_bufferPool.getLargestSize();
    }

    public final SMBSrvPacket allocatePacket(int reqSiz) throws NoPooledMemoryException {
        byte[] buf = null;
        if (reqSiz <= this.m_maxPoolBufSize) {
            buf = this.m_bufferPool.allocateBuffer(reqSiz, 250L);
        } else if (this.allowsOverSizedAllocations() && reqSiz <= this.getMaximumOverSizedAllocation()) {
            if (this.hasDebug()) {
                Debug.println("[SMB] Allocating an over-sized packet, reqSiz=" + reqSiz);
            }
            buf = new byte[reqSiz];
        }
        if (buf == null) {
            if (this.hasDebug()) {
                Debug.println("[SMB] CIFS Packet allocate failed, reqSiz=" + reqSiz);
            }
            throw new NoPooledMemoryException("Request size " + reqSiz);
        }
        return new SMBSrvPacket(buf);
    }

    public final SMBSrvPacket allocatePacket(int reqSiz, SMBSrvPacket reqPkt) throws NoPooledMemoryException {
        return this.allocatePacket(reqSiz, reqPkt, -1);
    }

    public final SMBSrvPacket allocatePacket(int reqSiz, SMBSrvPacket reqPkt, int copyLen) throws NoPooledMemoryException {
        SMBSrvPacket respPkt = this.allocatePacket(reqSiz);
        System.arraycopy(reqPkt.getBuffer(), 4, respPkt.getBuffer(), 4, copyLen == -1 ? 33 : copyLen);
        reqPkt.setAssociatedPacket(respPkt);
        if (this.hasDebug()) {
            Debug.println("[SMB]  Associated packet reqSiz=" + reqSiz + " with pktSiz=" + reqPkt.getBuffer().length);
        }
        return respPkt;
    }

    public final void releasePacket(SMBSrvPacket smbPkt) {
        if (smbPkt.isQueuedForAsyncIO()) {
            Debug.println("*** Packet queued for async I/O, pkt=" + smbPkt);
        }
        if (smbPkt.getBuffer().length <= this.m_maxPoolBufSize) {
            this.m_bufferPool.releaseBuffer(smbPkt.getBuffer());
            if (this.hasDebug() && !smbPkt.hasAssociatedPacket()) {
                Debug.println("[SMB] CIFS Packet released bufSiz=" + smbPkt.getBuffer().length);
            }
        } else if (this.hasDebug()) {
            Debug.println("[SMB] Over sized packet left for garbage collector");
        }
        if (smbPkt.hasAssociatedPacket()) {
            byte[] assocBuf = smbPkt.getAssociatedPacket().getBuffer();
            if (assocBuf.length <= this.m_maxPoolBufSize) {
                this.m_bufferPool.releaseBuffer(smbPkt.getAssociatedPacket().getBuffer());
                if (this.hasDebug()) {
                    Debug.println("[SMB] CIFS Packet released bufSiz=" + smbPkt.getBuffer().length + " and assoc packet, bufSiz=" + smbPkt.getAssociatedPacket().getBuffer().length);
                }
            } else if (this.hasDebug()) {
                Debug.println("[SMB] Over sized associated packet left for garbage collector");
            }
            smbPkt.clearAssociatedPacket();
        }
    }

    public final int getSmallestSize() {
        return this.m_bufferPool.getSmallestSize();
    }

    public final int getLargestSize() {
        return this.m_bufferPool.getLargestSize();
    }

    public final boolean allowsOverSizedAllocations() {
        return this.m_allowOverSize;
    }

    public final int getMaximumOverSizedAllocation() {
        return this.m_maxOverSize;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setAllowOverSizedAllocations(boolean ena) {
        this.m_allowOverSize = ena;
    }

    public String toString() {
        return this.m_bufferPool.toString();
    }
}

