/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.smb.TransactBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.DCEDataPacker;
import org.alfresco.jlan.smb.dcerpc.DCEPipeType;
import org.alfresco.jlan.smb.dcerpc.UUID;
import org.alfresco.jlan.smb.dcerpc.server.DCEPipeFile;
import org.alfresco.jlan.smb.dcerpc.server.DCESrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvException;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.SMBSrvTransPacket;
import org.alfresco.jlan.smb.server.VirtualCircuit;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.jlan.util.DataPacker;

public class DCERPCHandler {
    public static final void processDCERPCRequest(SMBSrvSession sess, SMBSrvTransPacket srvTrans, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(srvTrans);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        int fid = srvTrans.getSetupParameter(1);
        int maxData = srvTrans.getParameter(3) - 24;
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        DCEBuffer dceBuf = new DCEBuffer(srvTrans.getBuffer(), srvTrans.getParameter(10) + 4);
        if (sess.hasDebug(131072)) {
            sess.debugPrintln("TransactNmPipe pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", dceCmd=0x" + Integer.toHexString(dceBuf.getHeaderValue(2)));
        }
        DCERPCHandler.processDCEBuffer(sess, dceBuf, pipeFile, smbPkt);
        if (!pipeFile.hasBufferedData()) {
            return;
        }
        DCEBuffer txBuf = pipeFile.getBufferedData();
        DCESrvPacket dcePkt = new DCESrvPacket(smbPkt.getBuffer());
        int flags = 3;
        dcePkt.initializeDCEReply();
        txBuf.setHeaderValue(3, flags);
        byte[] buf = dcePkt.getBuffer();
        int pos = DCEDataPacker.longwordAlign(dcePkt.getByteOffset());
        int dataLen = txBuf.getLength();
        txBuf.setHeaderValue(5, dataLen);
        int len = txBuf.getLength();
        int sts = 0;
        if (len > maxData) {
            len = maxData + 24;
            dataLen = maxData + 24;
            sts = -2147483643;
        } else {
            pipeFile.setBufferedData(null);
        }
        if (sess.hasDebug(131072)) {
            sess.debugPrintln("Reply DCEbuf flags=0x" + Integer.toHexString(flags) + ", len=" + len + ", status=0x" + Integer.toHexString(sts));
        }
        try {
            pos += txBuf.copyData(buf, pos, len);
        }
        catch (DCEBufferException ex) {
            sess.sendErrorResponseSMB(smbPkt, 65535, 2);
            return;
        }
        int byteLen = pos - dcePkt.getByteOffset();
        dcePkt.setParameter(1, dataLen);
        dcePkt.setParameter(6, dataLen);
        dcePkt.setByteCount(byteLen);
        dcePkt.setFlags2(16384);
        dcePkt.setLongErrorCode(sts);
        sess.sendResponseSMB(dcePkt);
    }

    public static final void processDCERPCRequest(SMBSrvSession sess, VirtualCircuit vc, TransactBuffer tbuf, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (!tbuf.hasSetupBuffer() || !tbuf.hasDataBuffer()) {
            sess.sendErrorResponseSMB(smbPkt, 64, 2);
            return;
        }
        int treeId = tbuf.getTreeId();
        TreeConnection conn = vc.findConnection(treeId);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        DataBuffer setupBuf = tbuf.getSetupBuffer();
        setupBuf.skipBytes(2);
        int fid = setupBuf.getShort();
        int maxData = tbuf.getReturnDataLimit() - 24;
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        DCEBuffer dceBuf = new DCEBuffer(tbuf);
        if (sess.hasDebug(131072)) {
            sess.debugPrintln("TransactNmPipe pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", dceCmd=0x" + Integer.toHexString(dceBuf.getHeaderValue(2)));
        }
        DCERPCHandler.processDCEBuffer(sess, dceBuf, pipeFile, smbPkt);
        if (!pipeFile.hasBufferedData()) {
            return;
        }
        DCEBuffer txBuf = pipeFile.getBufferedData();
        DCESrvPacket dcePkt = new DCESrvPacket(smbPkt.getBuffer());
        int flags = 3;
        dcePkt.initializeDCEReply();
        txBuf.setHeaderValue(3, flags);
        byte[] buf = dcePkt.getBuffer();
        int pos = DCEDataPacker.longwordAlign(dcePkt.getByteOffset());
        int dataLen = txBuf.getLength();
        txBuf.setHeaderValue(5, dataLen);
        int len = txBuf.getLength();
        int sts = 0;
        if (len > maxData) {
            len = maxData + 24;
            dataLen = maxData + 24;
            sts = -2147483643;
        } else {
            pipeFile.setBufferedData(null);
        }
        int pktLen = dcePkt.getByteOffset() + len + 4;
        if (smbPkt.getBufferLength() < pktLen) {
            SMBSrvPacket respPkt = sess.getPacketPool().allocatePacket(pktLen, smbPkt, dcePkt.getByteOffset());
            buf = respPkt.getBuffer();
            dcePkt.setBuffer(buf);
        }
        if (sess.hasDebug(131072)) {
            sess.debugPrintln("Reply DCEbuf flags=0x" + Integer.toHexString(flags) + ", len=" + len + ", status=0x" + Integer.toHexString(sts));
        }
        try {
            pos += txBuf.copyData(buf, pos, len);
        }
        catch (DCEBufferException ex) {
            sess.sendErrorResponseSMB(smbPkt, 65535, 2);
            return;
        }
        int byteLen = pos - dcePkt.getByteOffset();
        dcePkt.setParameter(1, dataLen);
        dcePkt.setParameter(6, dataLen);
        dcePkt.setByteCount(byteLen);
        dcePkt.setFlags2(16384);
        dcePkt.setLongErrorCode(sts);
        sess.sendResponseSMB(dcePkt);
    }

    public static final void processDCERPCRequest(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        int cmd = smbPkt.getCommand();
        int fid = -1;
        fid = cmd == 11 ? smbPkt.getParameter(0) : smbPkt.getParameter(2);
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        DCEBuffer dceBuf = null;
        byte[] buf = smbPkt.getBuffer();
        int pos = 0;
        int len = 0;
        if (cmd == 11) {
            pos = smbPkt.getByteOffset();
            if (buf[pos++] != 1) {
                sess.sendErrorResponseSMB(smbPkt, 13, 1);
                return;
            }
            len = DataPacker.getIntelShort(buf, pos);
            pos += 2;
        } else {
            len = smbPkt.getParameter(10);
            pos = smbPkt.getParameter(11) + 4;
        }
        dceBuf = new DCEBuffer(buf, pos);
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("Write pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", dceCmd=0x" + Integer.toHexString(dceBuf.getHeaderValue(2)));
        }
        DCERPCHandler.processDCEBuffer(sess, dceBuf, pipeFile, smbPkt);
        int bufLen = 0;
        if (pipeFile.hasBufferedData()) {
            bufLen = pipeFile.getBufferedData().getLength();
        }
        if (cmd == 11) {
            smbPkt.setParameterCount(1);
            smbPkt.setParameter(0, len);
            smbPkt.setByteCount(0);
        } else {
            smbPkt.setParameterCount(6);
            smbPkt.setAndXCommand(255);
            smbPkt.setParameter(1, 0);
            smbPkt.setParameter(2, len);
            smbPkt.setParameter(3, bufLen);
            smbPkt.setParameter(4, 0);
            smbPkt.setParameter(5, 0);
            smbPkt.setByteCount(0);
        }
        smbPkt.setFlags2(16384);
        sess.sendResponseSMB(smbPkt);
    }

    public static final void processDCERPCRead(SMBSrvSession sess, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        TreeConnection conn = sess.findTreeConnection(smbPkt);
        if (conn == null) {
            sess.sendErrorResponseSMB(smbPkt, 15, 1);
            return;
        }
        int cmd = smbPkt.getCommand();
        int fid = -1;
        int rdLen = -1;
        if (cmd == 10) {
            fid = smbPkt.getParameter(0);
            rdLen = smbPkt.getParameter(1);
        } else {
            fid = smbPkt.getParameter(2);
            rdLen = smbPkt.getParameter(5);
        }
        DCEPipeFile pipeFile = (DCEPipeFile)conn.findFile(fid);
        if (pipeFile == null) {
            sess.sendErrorResponseSMB(smbPkt, 6, 1);
            return;
        }
        if (sess.hasDebug(16384)) {
            sess.debugPrintln("Read pipeFile=" + pipeFile.getName() + ", fid=" + fid + ", rdLen=" + rdLen);
        }
        SMBSrvPacket respPkt = smbPkt;
        if (pipeFile.hasBufferedData()) {
            DCEBuffer bufData = pipeFile.getBufferedData();
            int bufLen = bufData.getAvailableLength();
            if (sess.hasDebug(16384)) {
                sess.debugPrintln("  Buffered data available=" + bufLen);
            }
            if (rdLen > bufLen) {
                rdLen = bufLen;
            }
            byte[] buf = respPkt.getBuffer();
            int pos = respPkt.getByteOffset();
            if (cmd == 10) {
                pos += 2;
            }
            if (rdLen > buf.length - pos) {
                respPkt = sess.getPacketPool().allocatePacket(rdLen + pos, smbPkt, pos);
                buf = respPkt.getBuffer();
            }
            if (cmd == 10) {
                respPkt.setParameterCount(5);
                respPkt.setParameter(0, rdLen);
                for (int i = 1; i < 5; ++i) {
                    respPkt.setParameter(i, 0);
                }
                respPkt.setByteCount(rdLen + 3);
                pos = respPkt.getByteOffset();
                buf[pos++] = 1;
                DataPacker.putIntelShort(rdLen, buf, pos);
                pos += 2;
                try {
                    bufData.copyData(buf, pos, rdLen);
                }
                catch (DCEBufferException ex) {
                    sess.debugPrintln(ex);
                }
            } else {
                respPkt.setParameterCount(12);
                respPkt.setAndXCommand(255);
                for (int i = 1; i < 12; ++i) {
                    respPkt.setParameter(i, 0);
                }
                pos = DCEDataPacker.longwordAlign(respPkt.getByteOffset());
                respPkt.setParameter(5, rdLen);
                respPkt.setParameter(6, pos - 4);
                respPkt.setByteCount(pos + rdLen - respPkt.getByteOffset());
                try {
                    bufData.copyData(buf, pos, rdLen);
                }
                catch (DCEBufferException ex) {
                    Debug.println(ex);
                }
            }
        } else {
            if (sess.hasDebug(16384)) {
                sess.debugPrintln("  No buffered data available");
            }
            if (cmd == 10) {
                respPkt.setParameterCount(5);
                for (int i = 0; i < 5; ++i) {
                    respPkt.setParameter(i, 0);
                }
                respPkt.setByteCount(0);
            } else {
                respPkt.setParameterCount(12);
                respPkt.setAndXCommand(255);
                for (int i = 1; i < 12; ++i) {
                    respPkt.setParameter(i, 0);
                }
                respPkt.setByteCount(0);
            }
        }
        respPkt.setLongErrorCode(0);
        respPkt.setFlags2(16384);
        sess.sendResponseSMB(respPkt);
    }

    public static final void processDCEBuffer(SMBSrvSession sess, DCEBuffer dceBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        switch (dceBuf.getHeaderValue(2)) {
            case 11: {
                DCERPCHandler.procDCEBind(sess, dceBuf, pipeFile, smbPkt);
                break;
            }
            case 0: {
                DCERPCHandler.procDCERequest(sess, dceBuf, pipeFile, smbPkt);
                break;
            }
            default: {
                sess.sendErrorResponseSMB(smbPkt, 4, 2);
            }
        }
    }

    public static final void procDCEBind(SMBSrvSession sess, DCEBuffer dceBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        try {
            if (sess.hasDebug(131072)) {
                sess.debugPrintln("DCE Bind");
            }
            int callId = dceBuf.getHeaderValue(7);
            dceBuf.skipBytes(16);
            int maxTxSize = dceBuf.getShort();
            int maxRxSize = dceBuf.getShort();
            int groupId = dceBuf.getInt();
            int ctxElems = dceBuf.getByte(1);
            int presCtxId = dceBuf.getByte(0);
            int trfSyntax = dceBuf.getByte(0);
            UUID uuid1 = dceBuf.getUUID(true);
            UUID uuid2 = dceBuf.getUUID(true);
            if (sess.hasDebug(131072)) {
                sess.debugPrintln("Bind: maxTx=" + maxTxSize + ", maxRx=" + maxRxSize + ", groupId=" + groupId + ", ctxElems=" + ctxElems + ", presCtxId=" + presCtxId + ", trfSyntax=" + trfSyntax);
                sess.debugPrintln("      uuid1=" + uuid1.toString());
                sess.debugPrintln("      uuid2=" + uuid2.toString());
            }
            pipeFile.setMaxTransmitFragmentSize(maxTxSize);
            pipeFile.setMaxReceiveFragmentSize(maxRxSize);
            DCEBuffer txBuf = new DCEBuffer();
            txBuf.putBindAckHeader(dceBuf.getHeaderValue(7));
            txBuf.setHeaderValue(3, 3);
            txBuf.putShort(maxTxSize);
            txBuf.putShort(maxRxSize);
            txBuf.putInt(21488);
            String srvPipeName = DCEPipeType.getServerPipeName(pipeFile.getPipeId());
            txBuf.putShort(srvPipeName.length() + 1);
            txBuf.putASCIIString(srvPipeName, true, 1);
            txBuf.putInt(1);
            txBuf.putShort(0);
            txBuf.putShort(0);
            txBuf.putUUID(uuid2, true);
            txBuf.setHeaderValue(5, txBuf.getLength());
            pipeFile.setBufferedData(txBuf);
        }
        catch (DCEBufferException ex) {
            sess.sendErrorResponseSMB(smbPkt, 65535, 2);
            return;
        }
    }

    public static final void procDCERequest(SMBSrvSession sess, DCEBuffer inBuf, DCEPipeFile pipeFile, SMBSrvPacket smbPkt) throws IOException, SMBSrvException {
        if (sess.hasDebug(131072)) {
            sess.debugPrintln("DCE Request opNum=0x" + Integer.toHexString(inBuf.getHeaderValue(9)));
        }
        if (pipeFile.hasRequestHandler()) {
            pipeFile.getRequestHandler().processRequest(sess, inBuf, pipeFile, smbPkt);
        } else {
            sess.sendErrorResponseSMB(smbPkt, 4, 2);
        }
    }
}

