/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.IOException;
import java.net.InetAddress;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.SMBSrvPacket;

public abstract class PacketHandler {
    private int m_protoType;
    private String m_protoName;
    private String m_shortName;
    private String m_clientName;
    private InetAddress m_remoteAddr;
    private CIFSPacketPool m_packetPool;
    private boolean m_debug;

    public PacketHandler(int typ, String name, String shortName, CIFSPacketPool packetPool) throws IOException {
        this.m_protoType = typ;
        this.m_protoName = name;
        this.m_shortName = shortName;
        this.m_packetPool = packetPool;
    }

    public PacketHandler(int typ, String name, String shortName, String clientName, CIFSPacketPool packetPool) {
        this.m_protoType = typ;
        this.m_protoName = name;
        this.m_shortName = shortName;
        this.m_clientName = clientName;
        this.m_packetPool = packetPool;
    }

    public final int isProtocol() {
        return this.m_protoType;
    }

    public final String isProtocolName() {
        return this.m_protoName;
    }

    public final String getShortName() {
        return this.m_shortName;
    }

    public final boolean hasRemoteAddress() {
        return this.m_remoteAddr != null;
    }

    public final InetAddress getRemoteAddress() {
        return this.m_remoteAddr;
    }

    public final boolean hasClientName() {
        return this.m_clientName != null;
    }

    public final String getClientName() {
        return this.m_clientName;
    }

    public final CIFSPacketPool getPacketPool() {
        return this.m_packetPool;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public abstract int availableBytes() throws IOException;

    public abstract SMBSrvPacket readPacket() throws IOException;

    public abstract void writePacket(SMBSrvPacket var1, int var2, boolean var3) throws IOException;

    public final void writePacket(SMBSrvPacket pkt, int len) throws IOException {
        this.writePacket(pkt, len, false);
    }

    public final void writePacket(SMBSrvPacket pkt) throws IOException {
        this.writePacket(pkt, pkt.getLength());
    }

    public abstract void flushPacket() throws IOException;

    public void closeHandler() {
    }

    protected final void setClientName(String name) {
        this.m_clientName = name;
    }

    protected final void setRemoteAddress(InetAddress addr) {
        this.m_remoteAddr = addr;
    }
}

