/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.SrvSessionList;
import org.alfresco.jlan.server.Version;
import org.alfresco.jlan.server.auth.ICifsAuthenticator;
import org.alfresco.jlan.server.config.ConfigurationListener;
import org.alfresco.jlan.server.config.CoreServerConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.InvalidDeviceInterfaceException;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.NetworkFileServer;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.smb.DialectSelector;
import org.alfresco.jlan.smb.dcerpc.UUID;
import org.alfresco.jlan.smb.server.AdminSharedDevice;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.CifsConnectionsHandler;
import org.alfresco.jlan.smb.server.SMBSrvSession;
import org.alfresco.jlan.smb.server.ThreadedCifsConnectionsHandler;
import org.alfresco.jlan.smb.server.nio.NIOCifsConnectionsHandler;
import org.alfresco.jlan.smb.server.nio.win32.AsyncWinsockCifsConnectionsHandler;
import org.alfresco.jlan.smb.server.win32.Win32NetBIOSLanaMonitor;

public class SMBServer
extends NetworkFileServer
implements Runnable,
ConfigurationListener {
    private static final String ServerVersion = Version.SMBServerVersion;
    public static final int CIFSNetBIOSNamesAdded = 100;
    private CIFSConfigSection m_cifsConfig;
    private CoreServerConfigSection m_coreConfig;
    private Thread m_srvThread;
    private CifsConnectionsHandler m_connectionsHandler;
    private SrvSessionList m_sessions;
    private int m_srvType = 3;
    private UUID m_serverGUID;
    private CIFSPacketPool m_packetPool;

    public SMBServer(ServerConfiguration cfg) throws IOException {
        super("CIFS", cfg);
        this.CommonConstructor();
    }

    public final void addSession(SMBSrvSession sess) {
        this.m_sessions.addSession(sess);
        if (this.hasDebug()) {
            sess.setDebug(this.getCIFSConfiguration().getSessionDebugFlags());
        }
    }

    protected final void checkReadOnly(SharedDevice shr) {
        block10: {
            if (shr.getType() == 0) {
                try {
                    DiskInterface disk = (DiskInterface)shr.getInterface();
                    if (disk.isReadOnly(null, shr.getContext())) {
                        int attr = shr.getAttributes();
                        if ((attr & 4) == 0) {
                            attr += 4;
                        }
                        shr.setAttributes(attr);
                        if (this.hasDebug()) {
                            Debug.println("[SMB] Add Share " + shr.toString() + " : isReadOnly");
                        }
                    }
                }
                catch (InvalidDeviceInterfaceException ex) {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Add Share " + shr.toString() + " : " + ex.toString());
                    }
                }
                catch (FileNotFoundException ex) {
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Add Share " + shr.toString() + " : " + ex.toString());
                    }
                }
                catch (IOException ex) {
                    if (!this.hasDebug()) break block10;
                    Debug.println("[SMB] Add Share " + shr.toString() + " : " + ex.toString());
                }
            }
        }
    }

    private void CommonConstructor() throws IOException {
        this.m_cifsConfig = (CIFSConfigSection)this.getConfiguration().getConfigSection("CIFS");
        if (this.m_cifsConfig != null) {
            this.getConfiguration().addListener(this);
            if (this.getCIFSConfiguration().getSessionDebugFlags() != 0) {
                this.setDebug(true);
            }
            this.setVersion(ServerVersion);
            this.m_sessions = new SrvSessionList();
            this.m_coreConfig = (CoreServerConfigSection)this.getConfiguration().getConfigSection("CoreServer");
            if (this.m_coreConfig != null) {
                this.m_packetPool = new CIFSPacketPool(this.m_coreConfig.getMemoryPool());
                if ((this.m_cifsConfig.getSessionDebugFlags() & 0x800000) != 0) {
                    this.m_packetPool.setDebug(true);
                }
            }
        } else {
            this.setEnabled(false);
        }
    }

    public final void deleteTemporaryShares(SMBSrvSession sess) {
        this.getShareMapper().deleteShares(sess);
    }

    public final CIFSConfigSection getCIFSConfiguration() {
        return this.m_cifsConfig;
    }

    public final String getComment() {
        return this.getCIFSConfiguration().getComment();
    }

    public final String getServerName() {
        return this.getCIFSConfiguration().getServerName();
    }

    public final int getServerType() {
        return this.m_srvType;
    }

    public final int getSessionDebug() {
        return this.getCIFSConfiguration().getSessionDebugFlags();
    }

    public final DialectSelector getSMBDialects() {
        return this.getCIFSConfiguration().getEnabledDialects();
    }

    public final ICifsAuthenticator getCifsAuthenticator() {
        return this.getCIFSConfiguration().getAuthenticator();
    }

    public final SrvSessionList getSessions() {
        return this.m_sessions;
    }

    public final CIFSPacketPool getPacketPool() {
        return this.m_packetPool;
    }

    public final ThreadRequestPool getThreadPool() {
        return this.m_coreConfig.getThreadPool();
    }

    public void run() {
        boolean isWindows;
        block19: {
            this.fireServerEvent(0);
            this.setActive(true);
            isWindows = this.isWindowsNTOnwards();
            Random r = new Random();
            this.m_serverGUID = new UUID(r.nextLong(), r.nextLong());
            if (this.hasDebug()) {
                Debug.println("[SMB] CIFS Server " + this.getServerName() + " starting");
                Debug.print("[SMB] Version " + this.isVersion());
                Debug.print(", Java VM " + System.getProperty("java.vm.version"));
                Debug.println(", OS " + System.getProperty("os.name") + ", version " + System.getProperty("os.version"));
                if (this.getCIFSConfiguration().hasAliasNames()) {
                    Debug.println("[SMB] Server alias(es) : " + this.getCIFSConfiguration().getAliasNames());
                }
                if (this.getCifsAuthenticator() != null) {
                    Debug.println("[SMB] Using authenticator " + this.getCifsAuthenticator().toString());
                }
                if (this.getGlobalConfiguration().getTimeZone() != null) {
                    Debug.println("[SMB] Server timezone " + this.getGlobalConfiguration().getTimeZone() + ", offset from UTC = " + this.getGlobalConfiguration().getTimeZoneOffset() / 60 + "hrs");
                } else {
                    Debug.println("[SMB] Server timezone offset = " + this.getGlobalConfiguration().getTimeZoneOffset() / 60 + "hrs");
                }
                Debug.println("[SMB] Dialects enabled = " + this.getSMBDialects());
                Debug.println("[SMB] Shares:");
                Enumeration<SharedDevice> enm = this.getFullShareList(this.getCIFSConfiguration().getServerName(), null).enumerateShares();
                while (enm.hasMoreElements()) {
                    SharedDevice share = enm.nextElement();
                    Debug.println("[SMB]  " + share.toString() + " " + (share.getContext() != null ? share.getContext().toString() : ""));
                }
            }
            try {
                AdminSharedDevice admShare = new AdminSharedDevice();
                this.getFilesystemConfiguration().addShare(admShare);
                this.setShutdown(false);
                this.getServerIPAddresses();
                if (this.getCIFSConfiguration().getEnabledDialects().hasDialect(7)) {
                    this.getCIFSConfiguration().setServerType(this.getServerType() + 4096);
                    if (this.hasDebug()) {
                        Debug.println("[SMB] Added NTServer flag to host announcement");
                    }
                }
                this.m_connectionsHandler = this.getCIFSConfiguration().hasDisableNIOCode() || this.getCIFSConfiguration().hasWin32NetBIOS() ? new ThreadedCifsConnectionsHandler() : (this.getCIFSConfiguration().hasTcpipSMB() || this.getCIFSConfiguration().hasNetBIOSSMB() ? new NIOCifsConnectionsHandler() : new AsyncWinsockCifsConnectionsHandler());
                this.m_connectionsHandler.initializeHandler(this, this.getCIFSConfiguration());
                this.m_connectionsHandler.startHandler();
                if (this.m_connectionsHandler.numberOfSessionHandlers() > 0 || this.getCIFSConfiguration().hasWin32NetBIOS()) {
                    this.fireServerEvent(1);
                    while (!this.hasShutdown()) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException ex) {}
                    }
                } else if (this.hasDebug()) {
                    Debug.println("[SMB] No valid session handlers, server closing");
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block19;
                Debug.println("[SMB] Server error : " + ex.toString(), 1);
                Debug.println(ex);
                this.setException(ex);
                this.fireServerEvent(3);
            }
        }
        if (this.hasDebug()) {
            Debug.println("[SMB] SMB Server shutting down ...");
        }
        this.m_connectionsHandler.stopHandler();
        if (isWindows && Win32NetBIOSLanaMonitor.getLanaMonitor() != null) {
            Win32NetBIOSLanaMonitor.getLanaMonitor().shutdownRequest();
        }
        this.setActive(false);
        this.fireServerEvent(2);
        if (this.hasDebug()) {
            Debug.println("[SMB] Packet pool at shutdown: " + this.getPacketPool());
        }
    }

    protected final void sessionClosed(SMBSrvSession sess) {
        this.m_sessions.removeSession(sess);
        if (this.hasDebug()) {
            Debug.println("[SMB] Closed session " + sess.getSessionId() + ", sessions=" + this.m_sessions.numberOfSessions());
            if (this.m_sessions.numberOfSessions() > 0 && this.m_sessions.numberOfSessions() <= 10) {
                Enumeration<Integer> sessIds = this.m_sessions.enumerate();
                Debug.print("      Active sessions [");
                while (sessIds.hasMoreElements()) {
                    SMBSrvSession curSess = (SMBSrvSession)this.m_sessions.findSession(sessIds.nextElement());
                    Debug.print("" + curSess.getSessionId() + "=" + curSess.getRemoteAddress().getHostAddress() + ",");
                }
                Debug.println("]");
            }
        }
        this.fireSessionClosedEvent(sess);
    }

    protected final void sessionLoggedOn(SMBSrvSession sess) {
        this.fireSessionLoggedOnEvent(sess);
    }

    protected final void sessionOpened(SMBSrvSession sess) {
        this.fireSessionOpenEvent(sess);
    }

    public final void shutdownServer(boolean immediate) {
        this.setShutdown(true);
        try {
            this.m_srvThread.interrupt();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Enumeration<Integer> enm = this.m_sessions.enumerate();
        while (enm.hasMoreElements()) {
            Integer sessId = enm.nextElement();
            SMBSrvSession sess = (SMBSrvSession)this.m_sessions.findSession(sessId);
            this.fireSessionClosedEvent(sess);
            sess.closeSession();
        }
        if (this.m_srvThread != null) {
            try {
                this.m_srvThread.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireServerEvent(2);
    }

    public void startServer() {
        this.m_srvThread = new Thread(this);
        this.m_srvThread.setName("CIFS Server");
        this.m_srvThread.start();
    }

    public int configurationChanged(int id, ServerConfiguration config, Object newVal) throws InvalidConfigurationException {
        int sts = 0;
        try {
            switch (id) {
                case 65537: {
                    Boolean enaSMB = (Boolean)newVal;
                    if (this.isActive() && !enaSMB.booleanValue()) {
                        this.shutdownServer(false);
                    } else if (!this.isActive() && enaSMB.booleanValue()) {
                        this.startServer();
                    }
                    sts = 1;
                    break;
                }
                case 65540: 
                case 65541: 
                case 131076: 
                case 131081: 
                case 131082: 
                case 131086: 
                case 131088: 
                case 393217: 
                case 393218: 
                case 458753: 
                case 524289: 
                case 589825: {
                    sts = 1;
                    break;
                }
                case 131087: {
                    sts = 2;
                    if (!(newVal instanceof Integer)) break;
                    Integer dbgVal = (Integer)newVal;
                    this.setDebug(dbgVal != 0);
                    break;
                }
                case 131073: 
                case 131074: 
                case 131077: 
                case 131078: 
                case 131079: 
                case 131080: 
                case 131084: 
                case 131085: 
                case 131089: {
                    sts = 3;
                }
            }
        }
        catch (Exception ex) {
            throw new InvalidConfigurationException("SMB Server configuration error", ex);
        }
        return sts;
    }

    private final boolean isWindowsNTOnwards() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return !osName.endsWith("95") && !osName.endsWith("98") && !osName.endsWith("ME");
        }
        return false;
    }

    private final void getServerIPAddresses() {
        block6: {
            try {
                Enumeration<NetworkInterface> enm = NetworkInterface.getNetworkInterfaces();
                Vector<InetAddress> addrList = new Vector<InetAddress>();
                while (enm.hasMoreElements()) {
                    NetworkInterface ni = enm.nextElement();
                    Enumeration<InetAddress> addrs = ni.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        addrList.add(addrs.nextElement());
                    }
                }
                if (addrList.size() > 0) {
                    InetAddress[] inetAddrs = new InetAddress[addrList.size()];
                    for (int i = 0; i < addrList.size(); ++i) {
                        inetAddrs[i] = (InetAddress)addrList.elementAt(i);
                    }
                    this.setServerAddresses(inetAddrs);
                }
            }
            catch (Exception ex) {
                if (!this.hasDebug()) break block6;
                Debug.println("[SMB] Error getting local IP addresses, " + ex.toString());
            }
        }
    }

    public final UUID getServerGUID() {
        return this.m_serverGUID;
    }

    public final void fireNetBIOSNamesAddedEvent(int lana) {
        this.fireServerEvent(100 + (lana << 16));
    }
}

