/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.win32;

import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.win32.NetBIOSSocket;
import org.alfresco.jlan.netbios.win32.WinsockNetBIOSException;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.PacketHandler;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvPacketQueue;
import org.alfresco.jlan.smb.server.nio.AsynchronousWritesHandler;

public class WinsockNetBIOSPacketHandler
extends PacketHandler
implements AsynchronousWritesHandler {
    private static final int ReceiveBufferSizeError = Integer.MIN_VALUE;
    private int m_lana;
    private NetBIOSSocket m_sessSock;
    private SMBSrvPacketQueue m_asyncQueue;
    private boolean m_asyncMode;

    public WinsockNetBIOSPacketHandler(int lana, NetBIOSSocket sock, CIFSPacketPool packetPool, boolean asyncMode) {
        super(2, "WinsockNB", "WSNB", sock.getName().getName(), packetPool);
        this.m_lana = lana;
        this.m_sessSock = sock;
        this.m_asyncMode = asyncMode;
        if (this.hasAsynchronousMode()) {
            this.m_asyncQueue = new SMBSrvPacketQueue();
        }
    }

    public final int getLANA() {
        return this.m_lana;
    }

    public final NetBIOSSocket getSocket() {
        return this.m_sessSock;
    }

    public int availableBytes() throws IOException {
        return -1;
    }

    public final boolean hasAsynchronousMode() {
        return this.m_asyncMode;
    }

    public SMBSrvPacket readPacket() throws IOException {
        int rxlen = this.m_sessSock.available();
        if (rxlen == 0) {
            int loop = 0;
            while (loop++ < 50 && rxlen == 0) {
                rxlen = this.m_sessSock.available();
                if (rxlen != 0) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Exception e) {}
            }
            if (rxlen == 0 && this.hasDebug()) {
                Debug.println("***** Still no data after 100ms *****");
            }
        }
        SMBSrvPacket pkt = this.getPacketPool().allocatePacket(rxlen + 8);
        try {
            rxlen = this.m_sessSock.read(pkt.getBuffer(), 4, pkt.getBufferLength() - 4);
            if (rxlen == Integer.MIN_VALUE) {
                if (pkt.getBufferLength() >= this.getPacketPool().getLargestSize()) {
                    this.getPacketPool().releasePacket(pkt);
                    throw new RuntimeException("Winsock NetBIOS receive over max available buffer size");
                }
                int rxlen2 = this.m_sessSock.available();
                if (rxlen2 > 0) {
                    SMBSrvPacket pkt2 = this.getPacketPool().allocatePacket(this.getPacketPool().getLargestSize());
                    rxlen = pkt.getBufferLength();
                    System.arraycopy(pkt.getBuffer(), 4, pkt2.getBuffer(), 4, rxlen - 4);
                    this.getPacketPool().releasePacket(pkt);
                    pkt = pkt2;
                    rxlen2 = this.m_sessSock.read(pkt.getBuffer(), rxlen, pkt.getBufferLength() - rxlen);
                    if (rxlen2 == Integer.MIN_VALUE) {
                        this.getPacketPool().releasePacket(pkt);
                        throw new RuntimeException("Winsock NetBIOS receive error on second stage receive");
                    }
                    rxlen += rxlen2 - 4;
                }
            }
        }
        catch (WinsockNetBIOSException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            if (ex.getErrorCode() != 0) {
                this.getPacketPool().releasePacket(pkt);
                pkt = null;
                throw ex;
            }
            if (this.hasDebug()) {
                Debug.println("Winsock error code zero, ignored, rxlen=" + rxlen + ", pktlen=" + pkt.getBuffer().length);
            }
            rxlen = 0;
        }
        catch (IOException ex) {
            if (this.hasDebug()) {
                Debug.println(ex);
            }
            this.getPacketPool().releasePacket(pkt);
            pkt = null;
            throw ex;
        }
        if (pkt != null) {
            pkt.setReceivedLength(rxlen);
        }
        return pkt;
    }

    public void writePacket(SMBSrvPacket pkt, int len, boolean writeRaw) throws IOException {
        if (this.hasAsynchronousMode() && this.m_asyncQueue.numberOfPackets() > 0) {
            if (this.hasDebug()) {
                Debug.println("*** Queued packet for async I/O pkt=" + pkt.getPacketTypeString() + ", len=" + len + ", raw=" + writeRaw + "  (QueueLen) ***");
            }
            this.m_asyncQueue.addToQueue(pkt, 4, len, writeRaw);
            return;
        }
        int pos = 4;
        int wrlen = len;
        int txlen = 0;
        while (wrlen > 0) {
            txlen = this.m_sessSock.write(pkt.getBuffer(), pos, wrlen);
            if (this.hasAsynchronousMode() && txlen == -2) {
                if (this.hasDebug()) {
                    Debug.println("*** Queued packet for async I/O pkt=" + pkt.getPacketTypeString() + ", len=" + len + ", raw=" + writeRaw + "  (WouldBlock) ***");
                }
                this.m_asyncQueue.addToQueue(pkt, pos, wrlen, writeRaw);
                return;
            }
            if (txlen == 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            wrlen -= txlen;
            pos += txlen;
        }
    }

    public void flushPacket() throws IOException {
    }

    public void closeHandler() {
        super.closeHandler();
        if (this.hasAsynchronousMode()) {
            while (this.m_asyncQueue.numberOfPackets() > 0) {
                SMBSrvPacketQueue.QueuedSMBPacket queuedPkt = this.m_asyncQueue.removeFromQueue();
                this.getPacketPool().releasePacket(queuedPkt.getPacket());
            }
        }
        if (this.m_sessSock != null) {
            this.m_sessSock.closeSocket();
        }
    }

    public int getQueuedWriteCount() {
        if (!this.hasAsynchronousMode() || this.m_asyncQueue == null) {
            return 0;
        }
        return this.m_asyncQueue.numberOfPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processQueuedWrites() {
        int procCnt = 0;
        if (this.m_asyncQueue != null) {
            boolean wouldBlock = false;
            while (this.m_asyncQueue.numberOfPackets() > 0 && !wouldBlock) {
                SMBSrvPacketQueue.QueuedSMBPacket queuedPkt = this.m_asyncQueue.getHeadOfQueue();
                int pos = queuedPkt.getWriteOffset();
                int wrlen = queuedPkt.getWriteLength();
                int txlen = 0;
                while (wrlen > 0 && txlen != -2) {
                    NetBIOSSocket netBIOSSocket = this.m_sessSock;
                    synchronized (netBIOSSocket) {
                        try {
                            txlen = this.m_sessSock.write(queuedPkt.getPacket().getBuffer(), pos, wrlen);
                        }
                        catch (WinsockNetBIOSException ex) {
                            txlen = -2;
                        }
                    }
                    if (txlen == -2) {
                        if (this.hasDebug()) {
                            Debug.println("*** Process queued writes sts=WouldBlock ***");
                        }
                        if (pos == queuedPkt.getWriteOffset()) continue;
                        queuedPkt.updateSettings(pos, wrlen);
                        continue;
                    }
                    wrlen -= txlen;
                    pos += txlen;
                }
                if (txlen == -2) {
                    wouldBlock = true;
                    continue;
                }
                if (wrlen != 0) continue;
                this.m_asyncQueue.removeFromQueue();
                if (this.hasDebug()) {
                    Debug.println("*** Sent queued pkt=" + queuedPkt.getPacket() + ", len=" + queuedPkt.getWriteLength() + ", offset=" + queuedPkt.getWriteOffset());
                }
                queuedPkt.getPacket().setQueuedForAsyncIO(false);
                this.getPacketPool().releasePacket(queuedPkt.getPacket());
                ++procCnt;
            }
        }
        return procCnt;
    }
}

