/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UTF8Normalizer {
    private NormalizerType m_type = NormalizerType.Unknown;
    private Method m_method;
    private Field m_field;

    public UTF8Normalizer() {
        this.initNormalizer();
        if (this.isType() == NormalizerType.Unknown) {
            throw new RuntimeException("UTf8Normalizer failed to initialize");
        }
    }

    public final String normalize(String utf8str) {
        String normStr = null;
        try {
            switch (this.isType()) {
                case IBMICU: {
                    normStr = (String)this.m_method.invoke(null, utf8str, false);
                    break;
                }
                case Java5: {
                    normStr = (String)this.m_method.invoke(null, utf8str, false, 0);
                    break;
                }
                case Java6: {
                    normStr = (String)this.m_method.invoke(null, utf8str, this.m_field.get(null));
                    break;
                }
                case Unknown: {
                    throw new RuntimeException("Normalizer is not initialized");
                }
            }
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return normStr;
    }

    public final NormalizerType isType() {
        return this.m_type;
    }

    private final void initNormalizer() {
        try {
            Class<?> icuClass = Class.forName("com.ibm.icu.text.Normalizer");
            Class[] paramTypes = new Class[]{String.class, Boolean.TYPE};
            this.m_method = icuClass.getMethod("compose", paramTypes);
            if (this.m_method != null) {
                this.m_type = NormalizerType.IBMICU;
                return;
            }
        }
        catch (ClassNotFoundException ex) {
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        String javaVer = System.getProperty("java.specification.version");
        if (javaVer.equals("1.5")) {
            try {
                Class<?> sunClass = Class.forName("sun.text.Normalizer");
                Class[] paramTypes = new Class[]{String.class, Boolean.TYPE, Integer.TYPE};
                this.m_method = sunClass.getMethod("compose", paramTypes);
                if (this.m_method != null) {
                    this.m_type = NormalizerType.Java5;
                    return;
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoSuchMethodException ex) {}
        } else if (javaVer.equals("1.6")) {
            try {
                Class<?> java6Class = Class.forName("java.text.Normalizer");
                Class<?> normFormClass = Class.forName("java.text.Normalizer$Form");
                this.m_field = normFormClass.getField("NFD");
                Class[] paramTypes = new Class[]{CharSequence.class, normFormClass};
                this.m_method = java6Class.getMethod("normalize", paramTypes);
                if (this.m_method != null) {
                    this.m_type = NormalizerType.Java6;
                    return;
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NormalizerType {
        Unknown,
        Java5,
        Java6,
        IBMICU;

    }
}

