/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.TemplatesContainer;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.site.CacheUtil;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleUpdate
extends DeclarativeWebScript {
    private WebFrameworkServiceRegistry serviceRegistry;

    public void setServiceRegistry(WebFrameworkServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        ArrayList<String> tasks = new ArrayList<String>();
        boolean resetWebscripts = false;
        boolean resetTemplates = false;
        boolean resetObjects = false;
        String reset = req.getParameter("reset");
        if ("webscripts".equalsIgnoreCase(reset)) {
            resetWebscripts = true;
        }
        if ("templates".equalsIgnoreCase(reset)) {
            resetTemplates = true;
        }
        if ("objects".equalsIgnoreCase(reset)) {
            resetObjects = true;
        }
        if ("all".equalsIgnoreCase(reset)) {
            resetWebscripts = true;
            resetTemplates = true;
            resetObjects = true;
        }
        if (resetWebscripts) {
            int previousCount = this.getContainer().getRegistry().getWebScripts().size();
            int previousFailures = this.getContainer().getRegistry().getFailures().size();
            this.getContainer().reset();
            tasks.add("Reset Web Scripts Registry; registered " + this.getContainer().getRegistry().getWebScripts().size() + " Web Scripts.  Previously, there were " + previousCount + ".");
            int newFailures = this.getContainer().getRegistry().getFailures().size();
            if (newFailures != 0 || previousFailures != 0) {
                tasks.add("Warning: found " + newFailures + " broken Web Scripts.  Previously, there were " + previousFailures + ".");
            }
        }
        if (resetTemplates) {
            TemplatesContainer container = this.serviceRegistry.getTemplatesContainer();
            container.reset();
            tasks.add("Reset Templates Registry.");
        }
        if (resetObjects) {
            RequestContext context = FrameworkUtil.getCurrentRequestContext();
            CacheUtil.invalidateModelObjectServiceCache((RequestContext)context);
            tasks.add("Reset Surf Objects Registry.");
        }
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        model.put("tasks", tasks);
        model.put("webscripts", this.getContainer().getRegistry().getWebScripts());
        model.put("failures", this.getContainer().getRegistry().getFailures());
        return model;
    }
}

