/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.filename;

import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.filename.AbstractFilenameComposite;
import org.farng.mp3.filename.FilenameDelimiter;
import org.farng.mp3.filename.FilenameParenthesisIterator;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.ID3v2_4;

public class FilenameParenthesis
extends FilenameDelimiter {
    private AbstractFilenameComposite middleComposite = null;
    private String openDelimiter = null;

    public FilenameParenthesis() {
    }

    public FilenameParenthesis(FilenameParenthesis copyObject) {
        super(copyObject);
        this.openDelimiter = copyObject.openDelimiter;
        this.middleComposite = (AbstractFilenameComposite)TagUtility.copyObject(copyObject.middleComposite);
    }

    public void setFrame(AbstractID3v2Frame frame) {
        if (frame != null) {
            if (this.getBeforeComposite() != null) {
                this.getBeforeComposite().setFrame(frame);
            }
            if (this.middleComposite != null) {
                this.middleComposite.setFrame(frame);
            }
            if (this.getAfterComposite() != null) {
                this.getAfterComposite().setFrame(frame);
            }
        }
    }

    public void setMiddleComposite(AbstractFilenameComposite middleComposite) {
        this.middleComposite = middleComposite;
    }

    public AbstractFilenameComposite getMiddleComposite() {
        return this.middleComposite;
    }

    public void setOpenDelimiter(String openDelimiter) {
        this.openDelimiter = openDelimiter;
    }

    public String getOpenDelimiter() {
        return this.openDelimiter;
    }

    public String composeFilename() {
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this.getBeforeComposite() != null) {
            stringBuffer.append(this.getBeforeComposite().composeFilename());
        }
        stringBuffer.append(' ');
        stringBuffer.append(this.openDelimiter);
        if (this.middleComposite != null) {
            stringBuffer.append(this.middleComposite.composeFilename());
        }
        stringBuffer.append(TagOptionSingleton.getInstance().getCloseParenthesis(this.openDelimiter));
        stringBuffer.append(' ');
        if (this.getAfterComposite() != null) {
            stringBuffer.append(this.getAfterComposite().composeFilename());
        }
        return stringBuffer.toString().trim();
    }

    public ID3v2_4 createId3Tag() {
        ID3v2_4 newTag = null;
        if (this.getBeforeComposite() != null) {
            newTag = this.getBeforeComposite().createId3Tag();
        }
        if (this.middleComposite != null) {
            if (newTag != null) {
                newTag.append(this.middleComposite.createId3Tag());
            } else {
                newTag = this.middleComposite.createId3Tag();
            }
        }
        if (this.getAfterComposite() != null) {
            if (newTag != null) {
                newTag.append(this.getAfterComposite().createId3Tag());
            } else {
                newTag = this.getAfterComposite().createId3Tag();
            }
        }
        return newTag;
    }

    public Iterator iterator() {
        return new FilenameParenthesisIterator(this);
    }

    public void matchAgainstKeyword(Class id3v2FrameBodyClass) {
        if (AbstractID3v2FrameBody.class.isAssignableFrom(id3v2FrameBodyClass)) {
            if (this.getBeforeComposite() != null) {
                this.getBeforeComposite().matchAgainstKeyword(id3v2FrameBodyClass);
            }
            if (this.middleComposite != null) {
                this.middleComposite.matchAgainstKeyword(id3v2FrameBodyClass);
            }
            if (this.getAfterComposite() != null) {
                this.getAfterComposite().matchAgainstKeyword(id3v2FrameBodyClass);
            }
        }
    }

    public void matchAgainstTag(AbstractMP3Tag matchTag) {
        if (matchTag != null) {
            if (this.getBeforeComposite() != null) {
                this.getBeforeComposite().matchAgainstTag(matchTag);
            }
            if (this.middleComposite != null) {
                this.middleComposite.matchAgainstTag(matchTag);
            }
            if (this.getAfterComposite() != null) {
                this.getAfterComposite().matchAgainstTag(matchTag);
            }
        }
    }
}

