/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.object.ObjectByteArraySizeTerminated;
import org.farng.mp3.object.ObjectNumberHashMap;
import org.farng.mp3.object.ObjectStringDate;
import org.farng.mp3.object.ObjectStringNullTerminated;

public class FrameBodyCOMR
extends AbstractID3v2FrameBody {
    public FrameBodyCOMR() {
    }

    public FrameBodyCOMR(FrameBodyCOMR body) {
        super(body);
    }

    public FrameBodyCOMR(byte textEncoding, String priceString, String validUntil, String contactUrl, byte recievedAs, String nameOfSeller, String description, String mimeType, byte[] sellerLogo) {
        this.setObject("Text Encoding", new Byte(textEncoding));
        this.setObject("Price String", priceString);
        this.setObject("Valid Until", validUntil);
        this.setObject("Contact URL", contactUrl);
        this.setObject("Recieved As", new Byte(recievedAs));
        this.setObject("Name Of Seller", nameOfSeller);
        this.setObject("Description", description);
        this.setObject("Picture MIME Type", mimeType);
        this.setObject("Seller Logo", sellerLogo);
    }

    public FrameBodyCOMR(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public String getIdentifier() {
        String str = "COMR";
        Iterator iterator = this.getObjectListIterator();
        while (iterator.hasNext()) {
            str = str + '\u0000' + this.getOwner();
        }
        return str;
    }

    public String getOwner() {
        return (String)this.getObject("Owner");
    }

    public void getOwner(String description) {
        this.setObject("Owner", description);
    }

    protected void setupObjectList() {
        this.appendToObjectList(new ObjectNumberHashMap("Text Encoding", 1));
        this.appendToObjectList(new ObjectStringNullTerminated("Price String"));
        this.appendToObjectList(new ObjectStringDate("Valid Until"));
        this.appendToObjectList(new ObjectStringNullTerminated("Contact URL"));
        this.appendToObjectList(new ObjectNumberHashMap("Recieved As", 1));
        this.appendToObjectList(new ObjectStringNullTerminated("Name Of Seller"));
        this.appendToObjectList(new ObjectStringNullTerminated("Description"));
        this.appendToObjectList(new ObjectStringNullTerminated("Picture MIME Type"));
        this.appendToObjectList(new ObjectByteArraySizeTerminated("Seller Logo"));
    }
}

