/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTDRC;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v2_4;
import org.farng.mp3.id3.ID3v2_4Frame;
import org.farng.mp3.lyrics3.AbstractLyrics3;

public class ID3v1_1
extends ID3v1 {
    protected byte track = (byte)-1;

    public ID3v1_1() {
    }

    public ID3v1_1(ID3v1_1 copyObject) {
        super(copyObject);
        this.track = copyObject.track;
    }

    public ID3v1_1(AbstractMP3Tag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof ID3v1) {
                if (mp3tag instanceof ID3v1_1) {
                    throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
                }
                ID3v1 id3old = (ID3v1)mp3tag;
                this.title = new String(id3old.title.trim());
                this.artist = new String(id3old.artist.trim());
                this.album = new String(id3old.album.trim());
                this.comment = new String(id3old.comment.trim());
                this.year = new String(id3old.year.trim());
                this.genre = id3old.genre;
            } else {
                String text;
                ID3v2_4Frame frame;
                ID3v2_4 id3tag = new ID3v2_4(mp3tag);
                if (id3tag.hasFrame("TIT2")) {
                    frame = (ID3v2_4Frame)id3tag.getFrame("TIT2");
                    text = ((FrameBodyTIT2)frame.getBody()).getText();
                    this.title = TagUtility.truncate(text, 30);
                }
                if (id3tag.hasFrame("TPE1")) {
                    frame = (ID3v2_4Frame)id3tag.getFrame("TPE1");
                    text = ((FrameBodyTPE1)frame.getBody()).getText();
                    this.artist = TagUtility.truncate(text, 30);
                }
                if (id3tag.hasFrame("TALB")) {
                    frame = (ID3v2_4Frame)id3tag.getFrame("TALB");
                    text = ((FrameBodyTALB)frame.getBody()).getText();
                    this.album = TagUtility.truncate(text, 30);
                }
                if (id3tag.hasFrame("TDRC")) {
                    frame = (ID3v2_4Frame)id3tag.getFrame("TDRC");
                    text = ((FrameBodyTDRC)frame.getBody()).getText();
                    this.year = TagUtility.truncate(text, 4);
                }
                if (id3tag.hasFrameOfType("COMM")) {
                    Iterator iterator = id3tag.getFrameOfType("COMM");
                    text = "";
                    while (iterator.hasNext()) {
                        frame = (ID3v2_4Frame)iterator.next();
                        text = text + ((FrameBodyCOMM)frame.getBody()).getText() + " ";
                    }
                    this.comment = TagUtility.truncate(text, 28);
                }
                if (id3tag.hasFrame("TCON")) {
                    frame = (ID3v2_4Frame)id3tag.getFrame("TCON");
                    text = ((FrameBodyTCON)frame.getBody()).getText();
                    try {
                        this.genre = (byte)TagUtility.findNumber(text);
                    }
                    catch (TagException ex) {
                        this.genre = 0;
                    }
                }
                if (id3tag.hasFrame("TRCK")) {
                    frame = (ID3v2_4Frame)id3tag.getFrame("TRCK");
                    text = ((FrameBodyTRCK)frame.getBody()).getText();
                    try {
                        this.track = (byte)TagUtility.findNumber(text);
                    }
                    catch (TagException ex) {
                        this.track = 0;
                    }
                }
            }
        }
    }

    public ID3v1_1(RandomAccessFile file) throws TagNotFoundException, IOException {
        this.read(file);
    }

    public void setComment(String comment) {
        this.comment = TagUtility.truncate(comment, 28);
    }

    public String getComment() {
        return this.comment;
    }

    public String getIdentifier() {
        return "ID3v1_1.10";
    }

    public void setTrack(byte track) {
        this.track = track;
    }

    public byte getTrack() {
        return this.track;
    }

    public void append(AbstractMP3Tag tag) {
        ID3v1_1 oldTag = this;
        if (tag != null) {
            ID3v1_1 newTag = tag instanceof ID3v1_1 ? (ID3v1_1)tag : new ID3v1_1(tag);
            if (tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveTrack(false);
            }
            oldTag.track = TagOptionSingleton.getInstance().isId3v1SaveTrack() && oldTag.track <= 0 ? newTag.track : oldTag.track;
        }
        super.append(tag);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v1_1)) {
            return false;
        }
        ID3v1_1 id3v1_1 = (ID3v1_1)obj;
        if (this.track != id3v1_1.track) {
            return false;
        }
        return super.equals(obj);
    }

    public void overwrite(AbstractMP3Tag tag) {
        ID3v1_1 oldTag = this;
        ID3v1_1 newTag = null;
        if (tag != null) {
            newTag = tag instanceof ID3v1_1 ? (ID3v1_1)tag : new ID3v1_1(tag);
            if (tag instanceof AbstractLyrics3) {
                TagOptionSingleton.getInstance().setId3v1SaveTrack(false);
            }
            oldTag.track = TagOptionSingleton.getInstance().isId3v1SaveTrack() ? newTag.track : oldTag.track;
        }
        super.overwrite(newTag);
    }

    public void read(RandomAccessFile file) throws TagNotFoundException, IOException {
        byte[] buffer = new byte[30];
        if (!this.seek(file)) {
            throw new TagNotFoundException("ID3v1.1 tag not found");
        }
        file.read(buffer, 0, 30);
        this.title = new String(buffer, 0, 30, "ISO-8859-1").trim();
        file.read(buffer, 0, 30);
        this.artist = new String(buffer, 0, 30, "ISO-8859-1").trim();
        file.read(buffer, 0, 30);
        this.album = new String(buffer, 0, 30, "ISO-8859-1").trim();
        file.read(buffer, 0, 4);
        this.year = new String(buffer, 0, 4, "ISO-8859-1").trim();
        file.read(buffer, 0, 28);
        this.comment = new String(buffer, 0, 28, "ISO-8859-1").trim();
        file.read(buffer, 0, 2);
        if (buffer[0] != 0) {
            throw new TagNotFoundException("ID3v1.1 Tag Not found");
        }
        this.track = buffer[1];
        file.read(buffer, 0, 1);
        this.genre = buffer[0];
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        if (file.length() < 128L) {
            return false;
        }
        file.seek(file.length() - 3L);
        buffer[0] = file.readByte();
        if (buffer[0] != 0) {
            return false;
        }
        file.seek(file.length() - 128L);
        file.read(buffer, 0, 3);
        String tag = new String(buffer, 0, 3);
        return tag.equals("TAG");
    }

    public String toString() {
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        str = str + "Title = " + this.title + "\n";
        str = str + "Artist = " + this.artist + "\n";
        str = str + "Album = " + this.album + "\n";
        str = str + "Comment = " + this.comment + "\n";
        str = str + "Year = " + this.year + "\n";
        str = str + "Genre = " + this.genre + "\n";
        str = str + "Track = " + this.track + "\n";
        return str;
    }

    public void write(AbstractMP3Tag tag) {
        ID3v1_1 oldTag = this;
        ID3v1_1 newTag = null;
        if (tag != null) {
            newTag = tag instanceof ID3v1_1 ? (ID3v1_1)tag : new ID3v1_1(tag);
            oldTag.track = newTag.track;
        }
        super.write(newTag);
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        byte[] buffer = new byte[128];
        int offset = 3;
        this.delete(file);
        file.seek(file.length());
        buffer[0] = 84;
        buffer[1] = 65;
        buffer[2] = 71;
        String str = TagUtility.truncate(this.title, 30);
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += 30;
        str = TagUtility.truncate(this.artist, 30);
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += 30;
        str = TagUtility.truncate(this.album, 30);
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += 30;
        str = TagUtility.truncate(this.year, 4);
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += 4;
        str = TagUtility.truncate(this.comment, 28);
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += 28;
        buffer[++offset] = this.track;
        buffer[++offset] = this.genre;
        file.write(buffer);
    }

    public String getTrackNumberOnAlbum() {
        return Integer.toString(this.getTrack());
    }

    public void setTrackNumberOnAlbum(String trackNumberOnAlbum) {
        this.setTrack(Byte.parseByte(trackNumberOnAlbum.trim()));
    }
}

