/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodySYLT;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCOM;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyUSLT;
import org.farng.mp3.id3.ID3v2_2Frame;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.lyrics3.FieldBodyAUT;
import org.farng.mp3.lyrics3.FieldBodyEAL;
import org.farng.mp3.lyrics3.FieldBodyEAR;
import org.farng.mp3.lyrics3.FieldBodyETT;
import org.farng.mp3.lyrics3.FieldBodyINF;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.Lyrics3v2Field;
import org.farng.mp3.object.ObjectLyrics3Line;

public class ID3v2_4Frame
extends ID3v2_3Frame {
    protected boolean dataLengthIndicator = false;
    protected boolean unsynchronization = false;

    public ID3v2_4Frame() {
    }

    public ID3v2_4Frame(ID3v2_4Frame copyObject) {
        super(copyObject);
        this.dataLengthIndicator = copyObject.dataLengthIndicator;
        this.unsynchronization = copyObject.unsynchronization;
    }

    public ID3v2_4Frame(AbstractID3v2FrameBody body) {
        super(body);
    }

    public ID3v2_4Frame(AbstractID3v2Frame frame) {
        ID3v2_3Frame f;
        if (frame instanceof ID3v2_4Frame) {
            f = (ID3v2_4Frame)frame;
            this.unsynchronization = f.unsynchronization;
            this.dataLengthIndicator = f.dataLengthIndicator;
        }
        if (frame instanceof ID3v2_3Frame) {
            f = (ID3v2_3Frame)frame;
            this.tagAlterPreservation = f.tagAlterPreservation;
            this.fileAlterPreservation = f.fileAlterPreservation;
            this.readOnly = f.readOnly;
            this.groupingIdentity = f.groupingIdentity;
            this.compression = f.compression;
            this.encryption = f.encryption;
        }
        if (frame instanceof ID3v2_2Frame) {
            // empty if block
        }
        if (frame.getBody() != null && TagUtility.isID3v2_4FrameIdentifier(frame.getIdentifier())) {
            this.setBody((AbstractID3v2FrameBody)TagUtility.copyObject(frame.getBody()));
        }
    }

    public ID3v2_4Frame(boolean readOnly, boolean groupingIdentity, boolean compression, boolean encryption, boolean unsynchronization, boolean dataLengthIndicator, AbstractID3v2FrameBody body) {
        super(body);
        this.readOnly = readOnly;
        this.groupingIdentity = groupingIdentity;
        this.compression = compression;
        this.encryption = encryption;
        this.unsynchronization = unsynchronization;
        this.dataLengthIndicator = dataLengthIndicator;
    }

    public ID3v2_4Frame(Lyrics3v2Field field) throws InvalidTagException {
        String id = field.getIdentifier();
        if (id.equals("IND")) {
            throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 indications field.");
        }
        if (id.equals("LYR")) {
            FieldBodyLYR lyric = (FieldBodyLYR)field.getBody();
            Iterator iterator = lyric.iterator();
            boolean hasTimeStamp = lyric.hasTimeStamp();
            FrameBodySYLT sync = new FrameBodySYLT(0, "ENG", 2, 1, "");
            FrameBodyUSLT unsync = new FrameBodyUSLT(0, "ENG", "", "");
            while (iterator.hasNext()) {
                ObjectLyrics3Line line = (ObjectLyrics3Line)iterator.next();
                if (hasTimeStamp) {
                    sync.addLyric(line);
                    continue;
                }
                unsync.addLyric(line);
            }
            if (hasTimeStamp) {
                this.setBody(sync);
            } else {
                this.setBody(unsync);
            }
        } else if (id.equals("INF")) {
            String value = ((FieldBodyINF)field.getBody()).getAdditionalInformation();
            this.setBody(new FrameBodyCOMM(0, "ENG", "", value));
        } else if (id.equals("AUT")) {
            String value = ((FieldBodyAUT)field.getBody()).getAuthor();
            this.setBody(new FrameBodyTCOM(0, value));
        } else if (id.equals("EAL")) {
            String value = ((FieldBodyEAL)field.getBody()).getAlbum();
            this.setBody(new FrameBodyTALB(0, value));
        } else if (id.equals("EAR")) {
            String value = ((FieldBodyEAR)field.getBody()).getArtist();
            this.setBody(new FrameBodyTPE1(0, value));
        } else if (id.equals("ETT")) {
            String value = ((FieldBodyETT)field.getBody()).getTitle();
            this.setBody(new FrameBodyTIT2(0, value));
        } else {
            if (id.equals("IMG")) {
                throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 image field.");
            }
            throw new InvalidTagException("Cannot caret ID3v2.40 frame from " + id + " Lyrics3 field");
        }
    }

    public ID3v2_4Frame(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public int getSize() {
        return this.getBody().getSize() + 4 + 2 + 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2_4Frame)) {
            return false;
        }
        ID3v2_4Frame id3v2_4Frame = (ID3v2_4Frame)obj;
        if (this.unsynchronization != id3v2_4Frame.unsynchronization) {
            return false;
        }
        if (this.dataLengthIndicator != id3v2_4Frame.dataLengthIndicator) {
            return false;
        }
        return super.equals(obj);
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        long filePointer;
        byte b;
        byte[] buffer = new byte[4];
        do {
            filePointer = file.getFilePointer();
            b = file.readByte();
            AbstractID3v2.incrementPaddingCounter();
        } while (b == 0);
        file.seek(filePointer);
        AbstractID3v2.decrementPaddingCounter();
        file.read(buffer, 0, 4);
        String identifier = new String(buffer, 0, 4);
        if (!ID3v2_4Frame.isValidID3v2FrameIdentifier(identifier)) {
            file.seek(file.getFilePointer() - 3L);
            throw new InvalidTagException(identifier + " is not a valid ID3v2.40 frame");
        }
        filePointer = file.getFilePointer();
        file.skipBytes(4);
        file.read(buffer, 0, 2);
        this.tagAlterPreservation = (buffer[0] & 0x40) != 0;
        this.fileAlterPreservation = (buffer[0] & 0x20) != 0;
        this.readOnly = (buffer[0] & 0x10) != 0;
        this.groupingIdentity = (buffer[1] & 0x40) != 0;
        this.compression = (buffer[1] & 0x10) != 0;
        this.encryption = (buffer[1] & 8) != 0;
        this.unsynchronization = (buffer[1] & 4) != 0;
        this.dataLengthIndicator = (buffer[1] & 2) != 0;
        file.seek(filePointer);
        this.setBody(ID3v2_4Frame.readBody(identifier, file));
    }

    public void write(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[4];
        String str = TagUtility.truncate(this.getIdentifier(), 4);
        for (int i = 0; i < str.length(); ++i) {
            buffer[i] = (byte)str.charAt(i);
        }
        file.write(buffer, 0, str.length());
        long filePointer = file.getFilePointer();
        file.skipBytes(4);
        this.setAlterPreservation();
        buffer[0] = 0;
        buffer[1] = 0;
        if (this.tagAlterPreservation) {
            buffer[0] = (byte)(buffer[0] | 0x40);
        }
        if (this.fileAlterPreservation) {
            buffer[0] = (byte)(buffer[0] | 0x20);
        }
        if (this.readOnly) {
            buffer[0] = (byte)(buffer[0] | 0x10);
        }
        if (this.groupingIdentity) {
            buffer[1] = (byte)(buffer[1] | 0x40);
        }
        if (this.compression) {
            buffer[1] = (byte)(buffer[1] | 0x10);
        }
        if (this.encryption) {
            buffer[1] = (byte)(buffer[1] | 8);
        }
        if (this.unsynchronization) {
            buffer[1] = (byte)(buffer[1] | 4);
        }
        if (this.dataLengthIndicator) {
            buffer[1] = (byte)(buffer[1] | 2);
        }
        file.write(buffer, 0, 2);
        file.seek(filePointer);
        this.getBody().write(file);
    }
}

