/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.TagOptionSingleton;
import org.farng.mp3.TagUtility;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.FieldBodyLYR;
import org.farng.mp3.lyrics3.Lyrics3v2;

public class Lyrics3v1
extends AbstractLyrics3 {
    private String lyric = "";

    public Lyrics3v1() {
    }

    public Lyrics3v1(Lyrics3v1 copyObject) {
        super(copyObject);
        this.lyric = new String(copyObject.lyric);
    }

    public Lyrics3v1(AbstractMP3Tag mp3Tag) {
        if (mp3Tag != null) {
            if (mp3Tag instanceof Lyrics3v1) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            Lyrics3v2 lyricTag = mp3Tag instanceof Lyrics3v2 ? (Lyrics3v2)mp3Tag : new Lyrics3v2(mp3Tag);
            FieldBodyLYR lyricField = (FieldBodyLYR)lyricTag.getField("LYR").getBody();
            this.lyric = new String(lyricField.getLyric().trim());
        }
    }

    public Lyrics3v1(RandomAccessFile file) throws TagNotFoundException, IOException {
        this.read(file);
    }

    public String getIdentifier() {
        return "Lyrics3v1.00";
    }

    public void setLyric(String lyric) {
        this.lyric = TagUtility.truncate(lyric, 5100);
    }

    public String getLyric() {
        return this.lyric;
    }

    public int getSize() {
        return "LYRICSBEGIN".length() + this.lyric.length() + "LYRICSEND".length();
    }

    public boolean isSubsetOf(Object object) {
        if (!(object instanceof Lyrics3v1)) {
            return false;
        }
        return ((Lyrics3v1)object).lyric.indexOf(this.lyric) >= 0;
    }

    public void append(AbstractMP3Tag tag) {
        Lyrics3v1 oldTag = this;
        if (tag != null) {
            Lyrics3v1 newTag = tag instanceof Lyrics3v1 ? (Lyrics3v1)tag : new Lyrics3v1();
            this.lyric = oldTag.lyric + "\n" + newTag.lyric;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3v1)) {
            return false;
        }
        Lyrics3v1 lyrics3v1 = (Lyrics3v1)obj;
        if (!this.lyric.equals(lyrics3v1.lyric)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException("Method iterator() not yet implemented.");
    }

    public void overwrite(AbstractMP3Tag tag) {
        Lyrics3v1 oldTag = this;
        if (tag != null) {
            Lyrics3v1 newTag = tag instanceof Lyrics3v1 ? (Lyrics3v1)tag : new Lyrics3v1();
            this.lyric = TagOptionSingleton.getInstance().isLyrics3Save() ? newTag.lyric : oldTag.lyric;
        }
    }

    public void read(RandomAccessFile file) throws TagNotFoundException, IOException {
        byte[] buffer = new byte[5120];
        if (!this.seek(file)) {
            throw new TagNotFoundException("ID3v1 tag not found");
        }
        file.read(buffer);
        String lyricBuffer = new String(buffer);
        this.lyric = lyricBuffer.substring(0, lyricBuffer.indexOf("LYRICSEND"));
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        long offset;
        byte[] buffer = new byte[5120];
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        String lyricsEnd = new String(buffer, 0, 9);
        if (lyricsEnd.equals("LYRICSEND")) {
            offset = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricsEnd = new String(buffer, 0, 9);
            if (lyricsEnd.equals("LYRICSEND")) {
                offset = file.getFilePointer();
            } else {
                return false;
            }
        }
        file.seek(offset -= 5120L);
        file.read(buffer);
        String lyricsStart = new String(buffer);
        int i = lyricsStart.indexOf("LYRICSBEGIN");
        if (i == -1) {
            return false;
        }
        file.seek(offset + (long)i + 11L);
        return true;
    }

    public String toString() {
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        return str + this.lyric;
    }

    public void write(AbstractMP3Tag tag) {
        if (tag != null) {
            Lyrics3v1 newTag = tag instanceof Lyrics3v1 ? (Lyrics3v1)tag : new Lyrics3v1();
            this.lyric = newTag.lyric;
        }
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        ID3v1 id3v1tag = new ID3v1().getID3tag(file);
        this.delete(file);
        file.seek(file.length());
        byte[] buffer = new byte[this.lyric.length() + 11 + 9];
        String str = "LYRICSBEGIN";
        for (i = 0; i < str.length(); ++i) {
            buffer[i] = (byte)str.charAt(i);
        }
        int offset = str.length();
        str = TagUtility.truncate(this.lyric, 5100);
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += str.length();
        str = "LYRICSEND";
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        file.write(buffer, 0, offset += str.length());
        if (id3v1tag != null) {
            id3v1tag.write(file);
        }
    }

    public String getSongTitle() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getLeadArtist() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getAlbumTitle() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getYearReleased() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongComment() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongGenre() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getTrackNumberOnAlbum() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public String getSongLyric() {
        return this.getLyric().trim();
    }

    public String getAuthorComposer() {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongTitle(String songTitle) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setLeadArtist(String leadArtist) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setAlbumTitle(String albumTitle) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setYearReleased(String yearReleased) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongComment(String songComment) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongGenre(String songGenre) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setTrackNumberOnAlbum(String trackNumberOnAlbum) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }

    public void setSongLyric(String songLyrics) {
        this.setLyric(songLyrics.trim());
    }

    public void setAuthorComposer(String authorComposer) {
        throw new UnsupportedOperationException("This tag does not contain that information");
    }
}

