/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.api.AbstractXMLParser;
import info.bliki.api.Category;
import info.bliki.api.Link;
import info.bliki.api.Page;
import info.bliki.api.Revision;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPagesParser
extends AbstractXMLParser {
    private static final String PAGE_TAG = "page";
    private static final String REV_ID = "rev";
    private static final String CATEGORY_ID = "cl";
    private static final String PAGE_ID = "pageid";
    private static final String NS_ID = "ns";
    private static final String TITLE_ID = "title";
    private static final String ANON_ID = "anon";
    private static final String PL_ID = "pl";
    private static final String TIMESTAMP_ID = "timestamp";
    private Page fPage;
    private Revision fRevision;
    private List<Page> pagesList = new ArrayList<Page>();

    public XMLPagesParser(String xmlText) throws SAXException {
        super(xmlText);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this.fAttributes = atts;
        if (PAGE_TAG.equals(qName)) {
            this.fPage = new Page();
            this.fPage.setPageid(this.fAttributes.getValue(PAGE_ID));
            this.fPage.setNs(this.fAttributes.getValue(NS_ID));
            this.fPage.setTitle(this.fAttributes.getValue(TITLE_ID));
        } else if (REV_ID.equals(qName)) {
            this.fRevision = new Revision();
            this.fRevision.setAnon(this.fAttributes.getValue(ANON_ID));
            this.fRevision.setTimestamp(this.fAttributes.getValue(TIMESTAMP_ID));
            this.fPage.setCurrentRevision(this.fRevision);
        } else if (CATEGORY_ID.equals(qName)) {
            if (this.fPage != null) {
                Category cat = new Category();
                cat.setNs(this.fAttributes.getValue(NS_ID));
                cat.setTitle(this.fAttributes.getValue(TITLE_ID));
                this.fPage.addCategory(cat);
            }
        } else if (PL_ID.equals(qName) && this.fPage != null) {
            Link link = new Link();
            link.setNs(this.fAttributes.getValue(NS_ID));
            link.setTitle(this.fAttributes.getValue(TITLE_ID));
            this.fPage.addLink(link);
        }
        this.fData = null;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        try {
            if (REV_ID.equals(qName)) {
                if (this.fRevision != null) {
                    this.fRevision.setContent(this.getString());
                }
            } else if (PAGE_TAG.equals(qName) && this.fPage != null) {
                this.pagesList.add(this.fPage);
            }
            this.fData = null;
            this.fAttributes = null;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public List<Page> getPagesList() {
        return this.pagesList;
    }
}

