/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.AbstractParser;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.util.WikiTagNode;
import info.bliki.wiki.template.ITemplateFunction;
import java.util.HashMap;

public class TemplateParser
extends AbstractParser {
    public TemplateParser(String stringSource) {
        super(stringSource);
    }

    public static void parse(String rawWikitext, IWikiModel wikiModel, StringBuilder writer) {
        TemplateParser.parseRecursive(rawWikitext, wikiModel, writer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void parseRecursive(String rawWikitext, IWikiModel wikiModel, StringBuilder writer) {
        try {
            int level = wikiModel.incrementRecursionLevel();
            if (level > 25) {
                writer.append("Error - recursion limit exceeded parsing templates.");
                return;
            }
            try {
                TemplateParser parser = new TemplateParser(rawWikitext);
                parser.setModel(wikiModel);
                parser.runParser(writer);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                writer.append(e.getClass().getSimpleName());
                return;
            }
            catch (Error e) {
                e.printStackTrace();
                writer.append(e.getClass().getSimpleName());
                return;
            }
        }
        finally {
            wikiModel.decrementRecursionLevel();
        }
    }

    protected void runParser(StringBuilder writer) {
        this.fWhiteStart = true;
        this.fWhiteStartPosition = this.fCurrentPosition;
        try {
            block8: while (true) {
                this.fCurrentCharacter = this.fSource[this.fCurrentPosition++];
                switch (this.fCurrentCharacter) {
                    case '{': {
                        if (!this.parseTemplate(writer)) break;
                        this.fWhiteStart = true;
                        this.fWhiteStartPosition = this.fCurrentPosition;
                        continue block8;
                    }
                    case '<': {
                        int htmlStartPosition = this.fCurrentPosition;
                        if (this.parseSpecialWikiTags(writer)) continue block8;
                        this.fCurrentPosition = htmlStartPosition;
                    }
                }
                if (this.fWhiteStart) continue;
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition - 1;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            try {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parseSpecialWikiTags(StringBuilder writer) {
        try {
            switch (this.fSource[this.fCurrentPosition]) {
                case '!': {
                    if (!this.parseHTMLCommentTags(writer)) return false;
                    return true;
                }
                default: {
                    String tagName;
                    WikiTagNode tagNode;
                    if (this.fSource[this.fCurrentPosition] == '/' || (tagNode = this.parseTag(this.fCurrentPosition)) == null || !((tagName = tagNode.getTagName()).equals("nowiki") ? this.readUntilIgnoreCase("</", "nowiki>") : (tagName.equals("source") ? this.readUntilIgnoreCase("</", "source>") : tagName.equals("math") && this.readUntilIgnoreCase("</", "math>")))) return false;
                    return true;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    protected void appendContent(StringBuilder writer, boolean whiteStart, int whiteStartPosition, int diff) {
        if (whiteStart) {
            try {
                int whiteEndPosition = this.fCurrentPosition - diff;
                int count = whiteEndPosition - whiteStartPosition;
                if (count > 0) {
                    writer.append(this.fSource, whiteStartPosition, count);
                }
            }
            finally {
                this.fWhiteStart = false;
            }
        }
    }

    private boolean parseTemplate(StringBuilder writer) {
        if (this.fSource[this.fCurrentPosition] == '{') {
            this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
            int startTemplatePosition = ++this.fCurrentPosition;
            if (this.fSource[this.fCurrentPosition] != '{') {
                int templateEndPosition = this.findTemplateEnd(this.fCurrentPosition);
                if (templateEndPosition > 0) {
                    int endPosition = this.fCurrentPosition = templateEndPosition;
                    String plainContent = null;
                    int endOffset = this.fCurrentPosition - 2;
                    String function = this.checkParserFunction(startTemplatePosition, endOffset);
                    if (function != null) {
                        ITemplateFunction templateFunction = this.fWikiModel.getTemplateFunction(function.toLowerCase());
                        if (templateFunction != null) {
                            plainContent = templateFunction.parseFunction(this.fSource, this.fCurrentPosition, endOffset, this.fWikiModel);
                            this.fCurrentPosition = endPosition;
                            if (plainContent != null) {
                                TemplateParser.parseRecursive(plainContent, this.fWikiModel, writer);
                                return true;
                            }
                        }
                    } else {
                        Object[] objs = this.createParameterMap(this.fSource, startTemplatePosition, this.fCurrentPosition - startTemplatePosition - 2);
                        HashMap map = (HashMap)objs[0];
                        String templateName = ((String)objs[1]).trim();
                        if (templateName.length() > 0 && templateName.charAt(0) == ':') {
                            plainContent = this.fWikiModel.getRawWikiContent("", templateName.substring(1), map);
                        } else {
                            this.fWikiModel.addTemplate(templateName);
                            plainContent = this.fWikiModel.getRawWikiContent(this.fWikiModel.getTemplateNamespace(), templateName, map);
                        }
                        this.fCurrentPosition = endPosition;
                        if (plainContent != null) {
                            WikipediaScanner scanner = new WikipediaScanner(plainContent);
                            StringBuilder plainBuffer = scanner.replaceTemplateParameters(plainContent, map);
                            if (plainBuffer == null) {
                                TemplateParser.parseRecursive(plainContent, this.fWikiModel, writer);
                                return true;
                            }
                            TemplateParser.parseRecursive(plainBuffer.toString().trim(), this.fWikiModel, writer);
                            return true;
                        }
                        writer.append("{{" + templateName + "}}");
                    }
                    return true;
                }
            } else {
                int templateEndPosition = this.findTemplateParameterEnd(this.fCurrentPosition);
                if (templateEndPosition > 0) {
                    String plainContent = new String(this.fSource, startTemplatePosition - 2, templateEndPosition - startTemplatePosition + 2);
                    if (plainContent != null) {
                        this.fCurrentPosition = templateEndPosition;
                        WikipediaScanner scanner = new WikipediaScanner(plainContent);
                        StringBuilder plainBuffer = scanner.replaceTemplateParameters(plainContent, null);
                        if (plainBuffer == null) {
                            writer.append(plainContent);
                            return true;
                        }
                        TemplateParser.parseRecursive(plainBuffer.toString().trim(), this.fWikiModel, writer);
                        return true;
                    }
                } else {
                    --this.fCurrentPosition;
                }
            }
        }
        return false;
    }

    private Object[] createParameterMap(char[] src, int startOffset, int len) {
        char ch;
        HashMap<String, String> map;
        Object[] objs = new Object[2];
        objs[0] = map = new HashMap<String, String>();
        boolean foundPipe = false;
        int currOffset = startOffset;
        int endOffset = startOffset + len;
        while (currOffset < endOffset) {
            if ((ch = src[currOffset++]) != '|') continue;
            foundPipe = true;
            objs[1] = new String(src, startOffset, currOffset - startOffset - 1);
            break;
        }
        if (!foundPipe) {
            objs[1] = new String(src, startOffset, len);
            return objs;
        }
        String parameter = null;
        boolean equalCharParsed = false;
        int parameterCounter = 0;
        int lastOffset = currOffset;
        try {
            String value;
            while (currOffset < endOffset) {
                int temp;
                if ((ch = src[currOffset++]) == '[' && src[currOffset] == '[') {
                    if ((temp = TemplateParser.findNestedEnd(src, '[', ']', ++currOffset)) < 0) continue;
                    currOffset = temp;
                    continue;
                }
                if (ch == '{' && src[currOffset] == '{') {
                    if ((temp = TemplateParser.findNestedEnd(src, '{', '}', ++currOffset)) < 0) continue;
                    currOffset = temp;
                    continue;
                }
                if (ch == '=') {
                    if (!equalCharParsed) {
                        parameter = new String(src, lastOffset, currOffset - lastOffset - 1).trim();
                        lastOffset = currOffset;
                    }
                    equalCharParsed = true;
                    continue;
                }
                if (ch != '|') continue;
                equalCharParsed = false;
                value = new String(src, lastOffset, currOffset - lastOffset - 1).trim();
                map.put(Integer.toString(++parameterCounter), value);
                if (parameter != null) {
                    map.put(parameter, value);
                    parameter = null;
                }
                lastOffset = currOffset;
            }
            if (currOffset > lastOffset) {
                value = new String(src, lastOffset, currOffset - lastOffset);
                map.put(Integer.toString(++parameterCounter), value);
                if (parameter != null) {
                    map.put(parameter, value);
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return objs;
    }

    private String checkParserFunction(int startOffset, int endOffset) {
        String function = null;
        int currOffset = startOffset;
        int functionStart = startOffset;
        block0: while (currOffset < endOffset) {
            char ch;
            if ((ch = this.fSource[currOffset++]) == '#') {
                functionStart = currOffset;
                while (currOffset < endOffset) {
                    if ((ch = this.fSource[currOffset++]) != ':') continue;
                    this.fCurrentPosition = currOffset;
                    function = new String(this.fSource, functionStart, currOffset - functionStart - 1);
                    break block0;
                }
                break;
            }
            if (!Character.isWhitespace(ch)) break;
        }
        return function;
    }

    protected boolean parseHTMLCommentTags(StringBuilder writer) {
        int temp = this.readWhitespaceUntilStartOfLine(2);
        String htmlCommentString = new String(this.fSource, this.fCurrentPosition - 1, 4);
        if (htmlCommentString.equals("<!--")) {
            if (temp >= 0) {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, this.fCurrentPosition - temp - 1);
            } else {
                this.appendContent(writer, this.fWhiteStart, this.fWhiteStartPosition, 1);
            }
            this.fCurrentPosition += 3;
            if (this.readUntil("-->")) {
                if (temp >= 0 && (temp = this.readWhitespaceUntilEndOfLine(0)) >= 0) {
                    ++this.fCurrentPosition;
                }
                this.fWhiteStart = true;
                this.fWhiteStartPosition = this.fCurrentPosition;
                return true;
            }
        }
        return false;
    }
}

