/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.tags.util.NodeAttribute;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.htmlcleaner.TagNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private Util() {
    }

    public static NodeAttribute addAttributes(TagNode node, String attributesString) {
        List<NodeAttribute> attributes;
        if (attributesString != null && (attributes = Util.getNodeAttributes(attributesString)) != null) {
            NodeAttribute attr = null;
            int i = 0;
            while (i < attributes.size()) {
                attr = attributes.get(i);
                node.addAttribute(attr.getName(), attr.getValue());
                ++i;
            }
            return attr;
        }
        return null;
    }

    public static List<NodeAttribute> getNodeAttributes(String attributesString) {
        String trimmed;
        List<NodeAttribute> attributes = null;
        if (attributesString != null && (trimmed = attributesString.trim()).length() != 0) {
            WikipediaScanner scanner = new WikipediaScanner(trimmed);
            attributes = scanner.parseAttributes(0, trimmed.length());
        }
        return attributes;
    }

    public static Map<String, String> getAttributes(String attributesString) {
        String trimmed;
        TreeMap<String, String> map = null;
        if (attributesString != null && (trimmed = attributesString.trim()).length() != 0) {
            map = new TreeMap<String, String>();
            WikipediaScanner scanner = new WikipediaScanner(trimmed);
            List<NodeAttribute> attributes = scanner.parseAttributes(0, trimmed.length());
            int i = 0;
            while (i < attributes.size()) {
                NodeAttribute attr = attributes.get(i);
                map.put(attr.getName(), attr.getValue());
                ++i;
            }
        }
        return map;
    }
}

