/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.Messages;
import info.bliki.wiki.filter.Encoder;
import info.bliki.wiki.filter.HTMLConverter;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.LaTeXConverter;
import info.bliki.wiki.filter.MagicWord;
import info.bliki.wiki.filter.PDFConverter;
import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.filter.WikipediaParser;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.IConfiguration;
import info.bliki.wiki.model.IEventListener;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.model.Reference;
import info.bliki.wiki.model.SemanticAttribute;
import info.bliki.wiki.model.SemanticRelation;
import info.bliki.wiki.tags.ATag;
import info.bliki.wiki.tags.TableOfContentTag;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import info.bliki.wiki.tags.util.TagStack;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWikiModel
implements IWikiModel {
    protected ArrayList<String> fCategoryNamespaces;
    protected ArrayList<String> fTemplateNamespaces;
    protected ArrayList<String> fImageNamespaces;
    protected ArrayList<Reference> fReferences;
    protected Map<String, Integer> fReferenceNames;
    protected int fRecursionLevel;
    protected boolean fReplaceColon;
    protected TagStack fTagStack;
    private boolean fInitialized = false;
    private int fNumber;
    private IConfiguration fConfiguration;
    private IEventListener fWikiListener = null;
    private ResourceBundle fResourceBundle;
    protected String fRedirectLink = null;
    protected TableOfContentTag fTableOfContentTag = null;

    public AbstractWikiModel() {
        this(Configuration.DEFAULT_CONFIGURATION);
    }

    public AbstractWikiModel(Configuration configuration) {
        this(configuration, Locale.ENGLISH);
    }

    public AbstractWikiModel(Configuration configuration, Locale locale) {
        this(configuration, Messages.getResourceBundle(locale));
    }

    public AbstractWikiModel(Configuration configuration, ResourceBundle resourceBundle) {
        this.fConfiguration = configuration;
        this.fResourceBundle = resourceBundle;
        this.initialize();
    }

    @Override
    public void addCategory(String categoryName, String sortKey) {
    }

    @Override
    public SourceCodeFormatter addCodeFormatter(String key, SourceCodeFormatter value) {
        return this.fConfiguration.addCodeFormatter(key, value);
    }

    @Override
    public String addInterwikiLink(String key, String value) {
        return this.fConfiguration.addInterwikiLink(key, value);
    }

    @Override
    public void addLink(String topicName) {
    }

    @Override
    public boolean addSemanticAttribute(String attribute, String attributeValue) {
        return false;
    }

    @Override
    public boolean addSemanticRelation(String relation, String relationValue) {
        return false;
    }

    @Override
    public void addTemplate(String template) {
    }

    @Override
    public ITemplateFunction addTemplateFunction(String key, ITemplateFunction value) {
        return this.fConfiguration.addTemplateFunction(key, value);
    }

    @Override
    public TagToken addTokenTag(String key, TagToken value) {
        return this.fConfiguration.addTokenTag(key, value);
    }

    @Override
    public String[] addToReferences(String reference, String nameAttribute) {
        Integer index;
        String[] result = new String[2];
        result[1] = null;
        if (this.fReferences == null) {
            this.fReferences = new ArrayList();
            this.fReferenceNames = new HashMap<String, Integer>();
        }
        if (nameAttribute != null && (index = this.fReferenceNames.get(nameAttribute)) != null) {
            result[0] = index.toString();
            Reference ref = this.fReferences.get(index - 1);
            int count = ref.incCounter();
            result[1] = count >= "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".length() ? String.valueOf(nameAttribute) + '_' + 'Z' : String.valueOf(nameAttribute) + '_' + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRTSUVWXYZ".charAt(count);
            return result;
        }
        if (nameAttribute != null) {
            this.fReferences.add(new Reference(reference, nameAttribute));
            index = this.fReferences.size();
            this.fReferenceNames.put(nameAttribute, index);
            result[1] = String.valueOf(nameAttribute) + "_a";
        } else {
            this.fReferences.add(new Reference(reference));
        }
        result[0] = Integer.toString(this.fReferences.size());
        return result;
    }

    @Override
    public void append(BaseToken contentNode) {
        this.fTagStack.append(contentNode);
    }

    @Override
    public void appendExternalImageLink(String imageSrc, String imageAltText) {
        TagNode spanTagNode = new TagNode("span");
        this.append(spanTagNode);
        spanTagNode.addAttribute("class", "image");
        TagNode imgTagNode = new TagNode("img");
        spanTagNode.addChild(imgTagNode);
        imgTagNode.addAttribute("src", imageSrc);
        imgTagNode.addAttribute("alt", imageAltText);
        imgTagNode.addAttribute("rel", "nofollow");
    }

    @Override
    public void appendExternalLink(String link, String linkName, boolean withoutSquareBrackets) {
        String ext;
        int indx = (link = Utils.escapeXml(link, true, false, false)).lastIndexOf(".");
        if (indx > 0 && indx < link.length() - 3 && ((ext = link.substring(indx + 1)).equalsIgnoreCase("gif") || ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("bmp"))) {
            this.appendExternalImageLink(link, linkName);
            return;
        }
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", link);
        aTagNode.addAttribute("class", "externallink");
        aTagNode.addAttribute("title", link);
        aTagNode.addAttribute("rel", "nofollow");
        aTagNode.addChild(new ContentToken(linkName));
    }

    @Override
    public void appendInternalImageLink(String hrefImageLink, String srcImageLink, ImageFormat imageFormat) {
        int pxSize = imageFormat.getSize();
        String caption = imageFormat.getCaption();
        TagNode divTagNode = new TagNode("div");
        divTagNode.addAttribute("id", "image");
        divTagNode.addAttribute("href", hrefImageLink);
        divTagNode.addAttribute("src", srcImageLink);
        divTagNode.addObjectAttribute("wikiobject", imageFormat);
        if (pxSize != -1) {
            divTagNode.addAttribute("style", "width:" + pxSize + "px");
        }
        this.pushNode(divTagNode);
        if (caption != null && caption.length() > 0) {
            TagNode captionTagNode = new TagNode("div");
            String clazzValue = "caption";
            String type = imageFormat.getType();
            if (type != null) {
                clazzValue = String.valueOf(type) + clazzValue;
            }
            captionTagNode.addAttribute("class", clazzValue);
            this.pushNode(captionTagNode);
            WikipediaParser.parseRecursive(caption, this);
            this.popNode();
        }
        this.popNode();
    }

    @Override
    public void appendInternalLink(String link, String hashSection, String linkText) {
        ATag aTagNode = new ATag();
        this.append(aTagNode);
        aTagNode.addAttribute("id", "w");
        String href = link;
        if (hashSection != null) {
            href = String.valueOf(href) + '#' + hashSection;
        }
        aTagNode.addAttribute("href", href);
        aTagNode.addObjectAttribute("wikilink", link);
        ContentToken text = new ContentToken(linkText);
        aTagNode.addChild(text);
    }

    @Override
    public void appendInterWikiLink(String namespace, String title, String linkText) {
        String hrefLink = this.getInterwikiMap().get(namespace.toLowerCase());
        if (hrefLink == null) {
            hrefLink = "#";
        }
        String encodedtopic = Encoder.encodeTitleUrl(title);
        if (this.replaceColon()) {
            encodedtopic = encodedtopic.replaceAll(":", "/");
        }
        hrefLink = hrefLink.replace("${title}", encodedtopic);
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", hrefLink);
        aTagNode.addChild(new ContentToken(linkText));
    }

    @Override
    public void appendISBNLink(String isbnPureText) {
        StringBuffer isbnUrl = new StringBuffer(isbnPureText.length() + 100);
        isbnUrl.append("http://www.amazon.com/exec/obidos/ASIN/");
        int index = 0;
        while (index < isbnPureText.length()) {
            if (isbnPureText.charAt(index) >= '0' && isbnPureText.charAt(index) <= '9') {
                isbnUrl.append(isbnPureText.charAt(index));
            }
            ++index;
        }
        String isbnString = isbnUrl.toString();
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", isbnString);
        aTagNode.addAttribute("class", "external text");
        aTagNode.addAttribute("title", isbnString);
        aTagNode.addAttribute("rel", "nofollow");
        aTagNode.addChild(new ContentToken(isbnPureText));
    }

    @Override
    public void appendMailtoLink(String link, String linkName, boolean withoutSquareBrackets) {
        String ext;
        int indx = (link = Utils.escapeXml(link, true, false, false)).lastIndexOf(".");
        if (indx > 0 && indx < link.length() - 3 && ((ext = link.substring(indx + 1)).equalsIgnoreCase("gif") || ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("bmp"))) {
            this.appendExternalImageLink(link, linkName);
            return;
        }
        TagNode aTagNode = new TagNode("a");
        this.append(aTagNode);
        aTagNode.addAttribute("href", link);
        aTagNode.addAttribute("class", "external free");
        aTagNode.addAttribute("title", link);
        aTagNode.addAttribute("rel", "nofollow");
        aTagNode.addChild(new ContentToken(linkName));
    }

    @Override
    public boolean appendRedirectLink(String redirectLink) {
        this.fRedirectLink = redirectLink;
        return true;
    }

    @Override
    public void appendStack(TagStack stack) {
        if (stack != null) {
            this.fTagStack.append(stack);
        }
    }

    @Override
    public void buildEditLinkUrl(int section) {
    }

    @Override
    public int decrementRecursionLevel() {
        return --this.fRecursionLevel;
    }

    @Override
    public String get2ndCategoryNamespace() {
        return this.getCategoryNamespace();
    }

    @Override
    public String get2ndImageNamespace() {
        return this.getImageNamespace();
    }

    @Override
    public String get2ndTemplateNamespace() {
        return this.getTemplateNamespace();
    }

    @Override
    public String getCategoryNamespace() {
        return "Category";
    }

    @Override
    public Map<String, SourceCodeFormatter> getCodeFormatterMap() {
        return this.fConfiguration.getCodeFormatterMap();
    }

    @Override
    public String getImageNamespace() {
        return "Image";
    }

    @Override
    public Map<String, String> getInterwikiMap() {
        return this.fConfiguration.getInterwikiMap();
    }

    @Override
    public int getNextNumber() {
        return this.fNumber++;
    }

    @Override
    public TagToken getNode(int offset) {
        return (TagToken)this.fTagStack.get(offset);
    }

    @Override
    public String getRawWikiContent(String namespace, String templateName, Map<String, String> templateParameters) {
        if (this.isTemplateNamespace(namespace) && MagicWord.isMagicWord(templateName)) {
            return MagicWord.processMagicWord(templateName);
        }
        return null;
    }

    @Override
    public int getRecursionLevel() {
        return this.fRecursionLevel;
    }

    @Override
    public String getRedirectLink() {
        return this.fRedirectLink;
    }

    @Override
    public List<Reference> getReferences() {
        return this.fReferences;
    }

    @Override
    public List<SemanticAttribute> getSemanticAttributes() {
        return null;
    }

    @Override
    public List<SemanticRelation> getSemanticRelations() {
        return null;
    }

    @Override
    public TableOfContentTag getTableOfContentTag(boolean isTOCIdentifier) {
        if (this.fTableOfContentTag == null) {
            TableOfContentTag tableOfContentTag = new TableOfContentTag("div");
            tableOfContentTag.addAttribute("id", "tableofcontent");
            tableOfContentTag.setShowToC(false);
            tableOfContentTag.setTOCIdentifier(isTOCIdentifier);
            this.fTableOfContentTag = tableOfContentTag;
        } else if (isTOCIdentifier) {
            try {
                TableOfContentTag tableOfContentTag = (TableOfContentTag)this.fTableOfContentTag.clone();
                this.fTableOfContentTag.setShowToC(false);
                tableOfContentTag.setShowToC(true);
                tableOfContentTag.setTOCIdentifier(isTOCIdentifier);
                this.fTableOfContentTag = tableOfContentTag;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else {
            return this.fTableOfContentTag;
        }
        this.append(this.fTableOfContentTag);
        return this.fTableOfContentTag;
    }

    @Override
    public ITemplateFunction getTemplateFunction(String name) {
        return this.getTemplateMap().get(name);
    }

    @Override
    public Map<String, ITemplateFunction> getTemplateMap() {
        return this.fConfiguration.getTemplateMap();
    }

    @Override
    public String getTemplateNamespace() {
        return "Template";
    }

    @Override
    public Map<String, TagToken> getTokenMap() {
        return this.fConfiguration.getTokenMap();
    }

    @Override
    public IEventListener getWikiListener() {
        return this.fWikiListener;
    }

    @Override
    public int incrementRecursionLevel() {
        return ++this.fRecursionLevel;
    }

    private void initialize() {
        this.fNumber = 0;
        if (!this.fInitialized) {
            this.fWikiListener = null;
            this.fCategoryNamespaces = new ArrayList();
            this.fTemplateNamespaces = new ArrayList();
            this.fImageNamespaces = new ArrayList();
            this.fTagStack = new TagStack();
            this.fReferences = null;
            this.fReferenceNames = null;
            this.fRecursionLevel = 0;
            this.fReplaceColon = false;
            this.fCategoryNamespaces.add("Category");
            this.fTemplateNamespaces.add("Template");
            this.fImageNamespaces.add("Image");
            this.fInitialized = true;
        }
    }

    @Override
    public boolean isCategoryNamespace(String namespace) {
        int i = 0;
        while (i < this.fCategoryNamespaces.size()) {
            if (namespace.equalsIgnoreCase(this.fCategoryNamespaces.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isImageNamespace(String namespace) {
        int i = 0;
        while (i < this.fImageNamespaces.size()) {
            if (namespace.equalsIgnoreCase(this.fImageNamespaces.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isInterWiki(String namespace) {
        return this.getInterwikiMap().containsKey(namespace.toLowerCase());
    }

    @Override
    public boolean isNamespace(String namespace) {
        return this.isImageNamespace(namespace) || this.isTemplateNamespace(namespace) || this.isCategoryNamespace(namespace);
    }

    @Override
    public boolean isSemanticWebActive() {
        return false;
    }

    @Override
    public boolean isTemplateNamespace(String namespace) {
        int i = 0;
        while (i < this.fTemplateNamespaces.size()) {
            if (namespace.equalsIgnoreCase(this.fTemplateNamespaces.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isTemplateTopic() {
        return false;
    }

    @Override
    public boolean parseBBCodes() {
        return false;
    }

    @Override
    public void parseEvents(IEventListener listener, String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return;
        }
        this.fWikiListener = listener;
        WikipediaParser.parse(rawWikiText, this, false);
        this.fInitialized = false;
    }

    @Override
    public String parseTemplates(String rawWikiText) {
        if (rawWikiText == null) {
            return "";
        }
        this.initialize();
        StringBuilder buf = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
        TemplateParser.parse(rawWikiText, this, buf);
        return buf.toString();
    }

    @Override
    public TagToken peekNode() {
        return this.fTagStack.peek();
    }

    @Override
    public TagToken popNode() {
        return this.fTagStack.pop();
    }

    @Override
    public boolean pushNode(TagToken node) {
        return this.fTagStack.push(node);
    }

    @Override
    public String render(ITextConverter converter, String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return "";
        }
        WikipediaParser.parse(rawWikiText, this, true);
        StringBuilder buf = new StringBuilder(rawWikiText.length() + rawWikiText.length() / 10);
        List<BaseToken> list = this.fTagStack.getNodeList();
        try {
            converter.nodesToText(list, buf, this);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this.fInitialized = false;
        return buf.toString();
    }

    @Override
    public String render(String rawWikiText) {
        return this.render(new HTMLConverter(), rawWikiText);
    }

    public String renderLaTeX(String rawWikiText) {
        return this.render(new LaTeXConverter(), rawWikiText);
    }

    @Override
    public String renderPDF(String rawWikiText) {
        return this.render(new PDFConverter(), rawWikiText);
    }

    @Override
    public boolean replaceColon() {
        return true;
    }

    @Override
    public void setSemanticWebActive(boolean semanticWeb) {
    }

    @Override
    public void setUp() {
        this.fRecursionLevel = 0;
    }

    @Override
    public boolean showSyntax(String tagName) {
        return true;
    }

    @Override
    public int stackSize() {
        return this.fTagStack.size();
    }

    @Override
    public TagStack swapStack(TagStack stack) {
        TagStack temp = this.fTagStack;
        this.fTagStack = stack;
        return temp;
    }

    @Override
    public void tearDown() {
    }

    public List<BaseToken> toNodeList(String rawWikiText) {
        this.initialize();
        if (rawWikiText == null) {
            return new ArrayList<BaseToken>();
        }
        WikipediaParser.parse(rawWikiText, this, true);
        this.fInitialized = false;
        return this.fTagStack.getNodeList();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.fResourceBundle;
    }
}

