/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.util.INoBodyParsingTag;
import java.io.IOException;

public class NowikiTag
extends HTMLTag
implements INoBodyParsingTag {
    protected NowikiTag(String name) {
        super(name);
    }

    public NowikiTag() {
        super("nowiki");
    }

    public static void copyNowikiNewLine(String text, StringBuffer writer) {
        int currentIndex;
        int len = text.length();
        int lastIndex = currentIndex = 0;
        while (currentIndex < len) {
            switch (text.charAt(currentIndex++)) {
                case '\r': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                        break;
                    }
                    ++lastIndex;
                    break;
                }
                case '\n': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("<br/>");
                    break;
                }
                case '<': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#60;");
                    break;
                }
                case '>': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#62;");
                    break;
                }
                case '&': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#38;");
                    break;
                }
                case '\'': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#39;");
                    break;
                }
                case '\"': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#34;");
                }
            }
        }
        if (lastIndex < currentIndex) {
            writer.append(text, lastIndex, currentIndex);
        }
    }

    public static void copyPre(String text, Appendable writer, boolean replaceAmpersand) throws IOException {
        int currentIndex;
        int len = text.length();
        int lastIndex = currentIndex = 0;
        while (currentIndex < len) {
            switch (text.charAt(currentIndex++)) {
                case '<': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#60;");
                    break;
                }
                case '>': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#62;");
                    break;
                }
                case '&': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    if (replaceAmpersand) {
                        writer.append("&#38;");
                        break;
                    }
                    writer.append("&");
                    break;
                }
                case '\'': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#39;");
                    break;
                }
                case '\"': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&#34;");
                }
            }
        }
        if (lastIndex < currentIndex) {
            writer.append(text, lastIndex, currentIndex);
        }
    }

    public static void copyMathLTGT(String text, Appendable writer) throws IOException {
        int currentIndex;
        int len = text.length();
        int lastIndex = currentIndex = 0;
        while (currentIndex < len) {
            switch (text.charAt(currentIndex++)) {
                case '<': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&lt;");
                    break;
                }
                case '>': {
                    if (lastIndex < currentIndex - 1) {
                        writer.append(text, lastIndex, currentIndex - 1);
                        lastIndex = currentIndex;
                    } else {
                        ++lastIndex;
                    }
                    writer.append("&gt;");
                }
            }
        }
        if (lastIndex < currentIndex) {
            writer.append(text, lastIndex, currentIndex);
        }
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            NowikiTag.copyPre(content, buf, true);
        }
    }

    public void renderLaTeX(ITextConverter converter, Appendable _out, IWikiModel model) throws IOException {
        String content = this.getBodyString();
        if (content != null && content.length() > 0) {
            _out.append(content);
        }
    }

    public boolean isReduceTokenStack() {
        return false;
    }
}

