/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.SourceCodeFormatter;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCPPBasedCodeFilter
implements SourceCodeFormatter {
    public static final String FONT_KEYWORD = "<font color=\"#7F0055\">";
    public static final String FONT_COMMENT = "<font color=\"#3F7F5F\">";
    public static final String FONT_STRINGS = "<font color=\"#2A00FF\">";
    public static final String FONT_JAVADOC = "<font color=\"#3F5FBF\">";
    public static final String FONT_END = "</font>";

    public static void appendChar(StringBuilder result, char currentChar) {
        switch (currentChar) {
            case '\"': {
                result.append("&#34;");
                break;
            }
            case '<': {
                result.append("&#60;");
                break;
            }
            case '>': {
                result.append("&#62;");
                break;
            }
            case '&': {
                result.append("&#38;");
                break;
            }
            case '\'': {
                result.append("&#39;");
                break;
            }
            default: {
                result.append(currentChar);
            }
        }
    }

    public static void createHashMap(HashMap<String, String> map, String str) {
        map.put(str, "<b><font color=\"#7F0055\">" + str + FONT_END + "</b>");
    }

    protected int appendIdentifier(String input, int identStart, int currentPosition, HashMap<String, String> keywords, HashSet<String> objectWords, StringBuilder result) {
        String keywordValue;
        String originalIdent;
        String keywordIdent = originalIdent = input.substring(identStart, --currentPosition);
        if (!this.isKeywordLowerCase()) {
            keywordIdent = keywordIdent.toLowerCase();
        }
        if ((keywordValue = keywords.get(keywordIdent)) != null) {
            result.append(keywordValue);
        } else {
            result.append(originalIdent);
        }
        return currentPosition;
    }

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashSet<String> objectsSet = this.getObjectSet();
        StringBuilder result = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result.append(FONT_STRINGS);
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\"' && source[currentPosition - 2] != '\\') break;
                    }
                    result.append(FONT_END);
                    continue;
                }
                if (currentChar == '\'') {
                    result.append(FONT_STRINGS);
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\'' && source[currentPosition - 2] != '\\') break;
                    }
                    result.append(FONT_END);
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '/') {
                    result.append(FONT_COMMENT);
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    AbstractCPPBasedCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\n') break;
                    }
                    result.append(FONT_END);
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '*') {
                    if (currentPosition < input.length() - 1 && source[currentPosition + 1] == '*') {
                        result.append(FONT_JAVADOC);
                    } else {
                        result.append(FONT_COMMENT);
                    }
                    AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                    AbstractCPPBasedCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '/' && source[currentPosition - 2] == '*') break;
                    }
                    result.append(FONT_END);
                    continue;
                }
                if (currentChar == '<' && this.isPHPTag() && currentPosition + 3 < input.length() && source[currentPosition] == '?' && source[currentPosition + 1] == 'p' && source[currentPosition + 2] == 'h' && source[currentPosition + 3] == 'p') {
                    currentPosition += 4;
                    result.append("<font color=\"#7F0055\">&#60;?php</font>");
                    continue;
                }
                if (currentChar == '?' && this.isPHPTag() && currentPosition < input.length() && source[currentPosition] == '>') {
                    ++currentPosition;
                    result.append("<font color=\"#7F0055\">?&#62;</font>");
                    continue;
                }
                AbstractCPPBasedCodeFilter.appendChar(result, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result);
            }
            return result.toString();
        }
    }

    public abstract HashMap<String, String> getKeywordSet();

    public abstract HashSet<String> getObjectSet();

    public boolean isKeywordLowerCase() {
        return true;
    }

    public boolean isPHPTag() {
        return false;
    }
}

