/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags.code;

import info.bliki.wiki.tags.code.AbstractCPPBasedCodeFilter;
import info.bliki.wiki.tags.code.SourceCodeFormatter;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptCodeFilter
extends AbstractCPPBasedCodeFilter
implements SourceCodeFormatter {
    private static HashMap<String, String> KEYWORD_SET = new HashMap();
    private static final String[] KEYWORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with"};
    private static HashSet<String> OBJECT_SET = new HashSet();

    static {
        int i = 0;
        while (i < KEYWORDS.length) {
            JavaScriptCodeFilter.createHashMap(KEYWORD_SET, KEYWORDS[i]);
            ++i;
        }
    }

    @Override
    public String filter(String input) {
        char[] source = input.toCharArray();
        int currentPosition = 0;
        int identStart = 0;
        char currentChar = ' ';
        HashMap<String, String> keywordsSet = this.getKeywordSet();
        HashSet<String> objectsSet = this.getObjectSet();
        StringBuilder result = new StringBuilder(input.length() + input.length() / 4);
        boolean identFound = false;
        try {
            while (true) {
                if ((currentChar = source[currentPosition++]) >= 'A' && currentChar <= 'Z' || currentChar == '_' || currentChar >= 'a' && currentChar <= 'z') {
                    identStart = currentPosition - 1;
                    identFound = true;
                    while (currentChar >= 'a' && currentChar <= 'z' || currentChar >= 'A' && currentChar <= 'Z' || currentChar == '_') {
                        currentChar = source[currentPosition++];
                    }
                    currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, objectsSet, result);
                    identFound = false;
                    continue;
                }
                if (currentChar == '\"') {
                    result.append("<font color=\"#2A00FF\">");
                    JavaScriptCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\"' && source[currentPosition - 2] != '\\') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '\'') {
                    result.append("<font color=\"#2A00FF\">");
                    JavaScriptCodeFilter.appendChar(result, currentChar);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\'' && source[currentPosition - 2] != '\\') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '/') {
                    result.append("<font color=\"#3F7F5F\">");
                    JavaScriptCodeFilter.appendChar(result, currentChar);
                    JavaScriptCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '\n') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '/' && currentPosition < input.length() && source[currentPosition] == '*') {
                    if (currentPosition < input.length() - 1 && source[currentPosition + 1] == '*') {
                        result.append("<font color=\"#3F5FBF\">");
                    } else {
                        result.append("<font color=\"#3F7F5F\">");
                    }
                    JavaScriptCodeFilter.appendChar(result, currentChar);
                    JavaScriptCodeFilter.appendChar(result, source[currentPosition++]);
                    while (currentPosition < input.length()) {
                        currentChar = source[currentPosition++];
                        JavaScriptCodeFilter.appendChar(result, currentChar);
                        if (currentChar == '/' && source[currentPosition - 2] == '*') break;
                    }
                    result.append("</font>");
                    continue;
                }
                if (currentChar == '<' && this.isPHPTag() && currentPosition + 3 < input.length() && source[currentPosition] == '?' && source[currentPosition + 1] == 'p' && source[currentPosition + 2] == 'h' && source[currentPosition + 3] == 'p') {
                    currentPosition += 4;
                    result.append("<font color=\"#7F0055\">&#60;?php</font>");
                    continue;
                }
                if (currentChar == '?' && this.isPHPTag() && currentPosition < input.length() && source[currentPosition] == '>') {
                    ++currentPosition;
                    result.append("<font color=\"#7F0055\">?&#62;</font>");
                    continue;
                }
                JavaScriptCodeFilter.appendChar(result, currentChar);
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (identFound) {
                currentPosition = this.appendIdentifier(input, identStart, currentPosition, keywordsSet, null, result);
            }
            return result.toString();
        }
    }

    @Override
    public HashMap<String, String> getKeywordSet() {
        return KEYWORD_SET;
    }

    @Override
    public HashSet<String> getObjectSet() {
        return OBJECT_SET;
    }
}

