/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.TagToken;

public class TagInfo {
    static final int HEAD_AND_BODY = 0;
    static final int HEAD = 1;
    static final int BODY = 2;
    static String CONTENT_ALL = "ALL";
    static String CONTENT_NONE = "NONE";
    static String CONTENT_TEXT = "TEXT";
    private String name;
    private String contentType;
    private Set mustCloseTags = new HashSet();
    private Set higherTags = new HashSet();
    private Set childTags = new HashSet();
    private Set permittedTags = new HashSet();
    private Set copyTags = new HashSet();
    private int belongsTo = 2;
    private String requiredParent = null;
    private String fatalTag = null;
    private boolean deprecated = false;
    private boolean unique = false;
    private boolean ignorePermitted = false;

    public TagInfo(String name, String contentType, int belongsTo, boolean depricated, boolean unique, boolean ignorePermitted, String dependancies) {
        this.name = name;
        this.contentType = contentType;
        this.belongsTo = belongsTo;
        this.deprecated = depricated;
        this.unique = unique;
        this.ignorePermitted = ignorePermitted;
        if (dependancies != null) {
            StringTokenizer tokenizer = new StringTokenizer(dependancies, ",.;| ");
            while (tokenizer.hasMoreTokens()) {
                String currTag = tokenizer.nextToken().toLowerCase();
                this.addDependancy(currTag);
            }
        }
    }

    public void addDependancy(String dependantTagName) {
        if (dependantTagName.startsWith("!")) {
            String tagName;
            this.fatalTag = tagName = dependantTagName.substring(1);
            this.higherTags.add(tagName);
        } else if (dependantTagName.startsWith("+")) {
            String tagName = dependantTagName.substring(1);
            this.requiredParent = dependantTagName.substring(1);
            this.higherTags.add(tagName);
        } else if (dependantTagName.startsWith("-")) {
            this.permittedTags.add(dependantTagName.substring(1));
        } else if (dependantTagName.startsWith("#")) {
            this.childTags.add(dependantTagName.substring(1));
        } else if (dependantTagName.startsWith("^")) {
            this.higherTags.add(dependantTagName.substring(1));
        } else if (dependantTagName.startsWith("&")) {
            String tagName = dependantTagName.substring(1);
            this.copyTags.add(tagName);
            this.mustCloseTags.add(tagName);
        } else if (!"".equals(dependantTagName.trim())) {
            this.mustCloseTags.add(dependantTagName);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Set getMustCloseTags() {
        return this.mustCloseTags;
    }

    public void setMustCloseTags(Set mustCloseTags) {
        this.mustCloseTags = mustCloseTags;
    }

    public Set getHigherTags() {
        return this.higherTags;
    }

    public void setHigherTags(Set higherTags) {
        this.higherTags = higherTags;
    }

    public Set getChildTags() {
        return this.childTags;
    }

    public void setChildTags(Set childTags) {
        this.childTags = childTags;
    }

    public Set getPermittedTags() {
        return this.permittedTags;
    }

    public void setPermittedTags(Set permittedTags) {
        this.permittedTags = permittedTags;
    }

    public Set getCopyTags() {
        return this.copyTags;
    }

    public void setCopyTags(Set copyTags) {
        this.copyTags = copyTags;
    }

    public String getRequiredParent() {
        return this.requiredParent;
    }

    public void setRequiredParent(String requiredParent) {
        this.requiredParent = requiredParent;
    }

    public int getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(int belongsTo) {
        this.belongsTo = belongsTo;
    }

    public String getFatalTag() {
        return this.fatalTag;
    }

    public void setFatalTag(String fatalTag) {
        this.fatalTag = fatalTag;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isIgnorePermitted() {
        return this.ignorePermitted;
    }

    public void setIgnorePermitted(boolean ignorePermitted) {
        this.ignorePermitted = ignorePermitted;
    }

    boolean allowsBody() {
        return !CONTENT_NONE.equals(this.contentType);
    }

    boolean isHigher(String tagName) {
        return this.higherTags.contains(tagName);
    }

    boolean isCopy(String tagName) {
        return this.copyTags.contains(tagName);
    }

    boolean hasCopyTags() {
        return !this.copyTags.isEmpty();
    }

    boolean hasPermittedTags() {
        return !this.permittedTags.isEmpty();
    }

    boolean isHeadTag() {
        return this.belongsTo == 1;
    }

    boolean isHeadAndBodyTag() {
        return this.belongsTo == 1 || this.belongsTo == 0;
    }

    boolean isMustCloseTag(TagInfo tagInfo) {
        if (tagInfo != null) {
            return this.mustCloseTags.contains(tagInfo.getName()) || tagInfo.contentType.equals(CONTENT_TEXT);
        }
        return false;
    }

    boolean allowsItem(BaseToken token) {
        TagToken tagToken;
        String tagName;
        if (this.contentType != CONTENT_NONE && token instanceof TagToken && "script".equals(tagName = (tagToken = (TagToken)token).getName())) {
            return true;
        }
        if (this.contentType == CONTENT_ALL) {
            if (!this.childTags.isEmpty()) {
                return token instanceof TagToken ? this.childTags.contains(((TagToken)token).getName()) : false;
            }
            if (!this.permittedTags.isEmpty()) {
                return token instanceof TagToken ? !this.permittedTags.contains(((TagToken)token).getName()) : true;
            }
            return true;
        }
        if (this.contentType == CONTENT_TEXT) {
            return !(token instanceof TagToken);
        }
        return false;
    }

    boolean allowsAnything() {
        return this.contentType.equals(CONTENT_ALL) && this.childTags.size() == 0;
    }
}

