/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.util.Locale;
import java.util.StringTokenizer;

class AcceptLanguage {
    private String m_language;
    private float m_quality = 1.0f;

    public AcceptLanguage(String lang, float quality) {
        this.m_language = lang.replace('-', '_');
        this.m_quality = quality;
    }

    public final String getLanguage() {
        return this.m_language;
    }

    public final float getQuality() {
        return this.m_quality;
    }

    public final Locale createLocale() {
        return AcceptLanguage.createLocale(this.getLanguage());
    }

    public static final Locale createLocale(String locName) {
        Locale locale = null;
        StringTokenizer t = new StringTokenizer(locName, "_");
        int tokens = t.countTokens();
        if (tokens == 1) {
            locale = new Locale(locName);
        } else if (tokens == 2) {
            locale = new Locale(t.nextToken(), t.nextToken());
        } else if (tokens == 3) {
            locale = new Locale(t.nextToken(), t.nextToken(), t.nextToken());
        }
        return locale;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[");
        str.append(this.getLanguage());
        str.append(",");
        str.append(this.getQuality());
        str.append("]");
        return str.toString();
    }
}

