/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.config.ClientConfigElement;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class AuthenticationFilter
extends AbstractLifecycleBean
implements DependencyInjectedFilter {
    private String loginPage;
    private ConfigService configService;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    protected void onBootstrap(ApplicationEvent event) {
        ClientConfigElement clientConfig;
        if (this.loginPage == null && (clientConfig = (ClientConfigElement)this.configService.getGlobalConfig().getConfigElement("client")) != null) {
            this.loginPage = clientConfig.getLoginPage();
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    public void doFilter(ServletContext context, ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpRes = (HttpServletResponse)res;
        if (!httpReq.getRequestURI().endsWith(this.loginPage)) {
            AuthenticationStatus status = AuthenticationHelper.authenticate(context, httpReq, httpRes, false);
            if (status == AuthenticationStatus.Success || status == AuthenticationStatus.Guest) {
                chain.doFilter(req, res);
            } else {
                BaseServlet.redirectToLoginPage(httpReq, httpRes, context);
            }
        } else {
            chain.doFilter(req, res);
        }
    }
}

