/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.BaseServlet;
import org.apache.commons.logging.Log;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.surf.util.URLEncoder;

public abstract class BaseDownloadContentServlet
extends BaseServlet {
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final long serialVersionUID = -4558907921887235967L;
    private static final String POWER_POINT_DOCUMENT_MIMETYPE = "application/vnd.ms-powerpoint";
    private static final String POWER_POINT_2007_DOCUMENT_MIMETYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    private static final String MULTIPART_BYTERANGES_BOUNDRY = "<ALF4558907921887235966L>";
    private static final String MULTIPART_BYTERANGES_HEADER = "multipart/byteranges; boundary=<ALF4558907921887235966L>";
    private static final String MULTIPART_BYTERANGES_BOUNDRY_SEP = "--<ALF4558907921887235966L>";
    private static final String MULTIPART_BYTERANGES_BOUNDRY_END = "--<ALF4558907921887235966L>--";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_CONTENT_RANGE = "Content-Range";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_ACCEPT_RANGES = "Accept-Ranges";
    private static final String HEADER_RANGE = "Range";
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    private static final int CHUNKSIZE = 65536;
    protected static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    protected static final String MSG_ERROR_CONTENT_MISSING = "error_content_missing";
    protected static final String MSG_ERROR_NOT_FOUND = "error_not_found";
    protected static final String URL_DIRECT = "d";
    protected static final String URL_DIRECT_LONG = "direct";
    protected static final String URL_ATTACH = "a";
    protected static final String URL_ATTACH_LONG = "attach";
    protected static final String ARG_PROPERTY = "property";
    protected static final String ARG_PATH = "path";

    protected abstract Log getLogger();

    protected void processDownloadRequest(HttpServletRequest req, HttpServletResponse res, boolean allowLogIn, boolean transmitContent) throws ServletException, IOException {
        block40: {
            String filename;
            NodeRef nodeRef;
            Log logger = this.getLogger();
            String uri = req.getRequestURI();
            if (logger.isDebugEnabled()) {
                String queryString = req.getQueryString();
                logger.debug((Object)("Processing URL: " + uri + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
            }
            uri = uri.substring(req.getContextPath().length());
            StringTokenizer t = new StringTokenizer(uri, "/");
            int tokenCount = t.countTokens();
            t.nextToken();
            String attachToken = t.nextToken();
            boolean attachment = URL_ATTACH.equals(attachToken) || URL_ATTACH_LONG.equals(attachToken);
            ServiceRegistry serviceRegistry = BaseDownloadContentServlet.getServiceRegistry(this.getServletContext());
            String path = req.getParameter(ARG_PATH);
            if (path != null && path.length() != 0) {
                try {
                    BaseServlet.PathRefInfo pathInfo = BaseDownloadContentServlet.resolveNamePath(this.getServletContext(), path);
                    nodeRef = pathInfo.NodeRef;
                    filename = pathInfo.Filename;
                }
                catch (IllegalArgumentException e) {
                    Application.handleSystemError(this.getServletContext(), req, res, MSG_ERROR_NOT_FOUND, 404, logger);
                    return;
                }
            } else {
                if (tokenCount < 6) {
                    throw new IllegalArgumentException("Download URL did not contain all required args: " + uri);
                }
                StoreRef storeRef = new StoreRef(URLDecoder.decode((String)t.nextToken()), URLDecoder.decode((String)t.nextToken()));
                String id = URLDecoder.decode((String)t.nextToken());
                nodeRef = new NodeRef(storeRef, id);
                if (tokenCount > 6) {
                    ArrayList<String> paths = new ArrayList<String>(tokenCount - 5);
                    while (t.hasMoreTokens()) {
                        paths.add(URLDecoder.decode((String)t.nextToken()));
                    }
                    filename = (String)paths.get(paths.size() - 1);
                    try {
                        NodeRef parentRef = serviceRegistry.getNodeService().getPrimaryParent(nodeRef).getParentRef();
                        FileInfo fileInfo = serviceRegistry.getFileFolderService().resolveNamePath(parentRef, paths);
                        nodeRef = fileInfo.getNodeRef();
                    }
                    catch (FileNotFoundException e) {
                        Application.handleSystemError(this.getServletContext(), req, res, MSG_ERROR_NOT_FOUND, 404, logger);
                        return;
                    }
                } else {
                    filename = t.nextToken();
                }
            }
            QName propertyQName = ContentModel.PROP_CONTENT;
            String property = req.getParameter(ARG_PROPERTY);
            if (property != null && property.length() != 0) {
                propertyQName = QName.createQName((String)property);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found NodeRef: " + nodeRef));
                logger.debug((Object)("Will use filename: " + filename));
                logger.debug((Object)("For property: " + propertyQName));
                logger.debug((Object)("With attachment mode: " + attachment));
            }
            NodeService nodeService = serviceRegistry.getNodeService();
            ContentService contentService = serviceRegistry.getContentService();
            if (!nodeService.exists(nodeRef)) {
                Application.handleSystemError(this.getServletContext(), req, res, MSG_ERROR_NOT_FOUND, 404, logger);
                return;
            }
            try {
                if (!this.checkAccess(req, res, nodeRef, "ReadContent", allowLogIn)) {
                    return;
                }
                Date modified = (Date)nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
                if (modified != null) {
                    long modDate;
                    long modifiedSince = req.getDateHeader(HEADER_IF_MODIFIED_SINCE);
                    if (modifiedSince > 0L && (modDate = modified.getTime() / 1000L * 1000L) <= modifiedSince) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Returning 304 Not Modified.");
                        }
                        res.setStatus(304);
                        return;
                    }
                    res.setDateHeader(HEADER_LAST_MODIFIED, modified.getTime());
                    res.setHeader(HEADER_CACHE_CONTROL, "must-revalidate, max-age=0");
                    res.setHeader(HEADER_ETAG, "\"" + Long.toString(modified.getTime()) + "\"");
                }
                if (attachment) {
                    res.setHeader(HEADER_CONTENT_DISPOSITION, "attachment");
                }
                ContentReader reader = contentService.getReader(nodeRef, propertyQName);
                String mimetype = (reader = FileContentReader.getSafeContentReader((ContentReader)reader, (String)Application.getMessage(req.getSession(), MSG_ERROR_CONTENT_MISSING), (Object[])new Object[]{nodeRef, reader})).getMimetype();
                if (mimetype == null || mimetype.length() == 0) {
                    MimetypeService mimetypeMap = serviceRegistry.getMimetypeService();
                    mimetype = MIMETYPE_OCTET_STREAM;
                    int extIndex = filename.lastIndexOf(46);
                    if (extIndex != -1) {
                        String ext = filename.substring(extIndex + 1);
                        mimetype = mimetypeMap.getMimetype(ext);
                    }
                }
                if (!attachment && (mimetype.equals(POWER_POINT_2007_DOCUMENT_MIMETYPE) || mimetype.equals(POWER_POINT_DOCUMENT_MIMETYPE))) {
                    res.setHeader(HEADER_CONTENT_DISPOSITION, "attachment");
                }
                res.setHeader(HEADER_ACCEPT_RANGES, "bytes");
                if (transmitContent) {
                    try {
                        boolean processedRange = false;
                        String range = req.getHeader(HEADER_CONTENT_RANGE);
                        if (range == null) {
                            range = req.getHeader(HEADER_RANGE);
                        }
                        if (range != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Found content range header: " + range));
                            }
                            if (range.length() > 6) {
                                processedRange = this.processRange(res, reader, range.substring(6), nodeRef, propertyQName, mimetype, req.getHeader(HEADER_USER_AGENT));
                            }
                        }
                        if (!processedRange) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Sending complete file content...");
                            }
                            res.setContentType(mimetype);
                            res.setCharacterEncoding(reader.getEncoding());
                            long size = reader.getSize();
                            res.setHeader(HEADER_CONTENT_RANGE, "bytes 0-" + Long.toString(size - 1L) + "/" + Long.toString(size));
                            res.setHeader(HEADER_CONTENT_LENGTH, Long.toString(size));
                            reader.getContent((OutputStream)res.getOutputStream());
                        }
                        break block40;
                    }
                    catch (SocketException e1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Client aborted stream read:\n\tnode: " + nodeRef + "\n\tcontent: " + reader));
                        }
                        break block40;
                    }
                    catch (ContentIOException e2) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Failed stream read:\n\tnode: " + nodeRef + " due to: " + e2.getMessage()));
                        }
                        break block40;
                    }
                    catch (Throwable err) {
                        if (err.getCause() instanceof SocketException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Client aborted stream read:\n\tnode: " + nodeRef + "\n\tcontent: " + reader));
                            }
                            break block40;
                        }
                        throw err;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HEAD request processed - no content sent.");
                }
                res.getOutputStream().close();
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Error during download content servlet processing: " + err.getMessage(), err);
            }
        }
    }

    private boolean processRange(HttpServletResponse res, ContentReader reader, String range, NodeRef ref, QName property, String mimetype, String userAgent) throws IOException {
        if (range.indexOf(44) == -1) {
            return this.processSingleRange(res, reader, range, mimetype);
        }
        return this.processMultiRange(res, range, ref, property, mimetype, userAgent);
    }

    private boolean processSingleRange(HttpServletResponse res, ContentReader reader, String range, String mimetype) throws IOException {
        boolean processedRange = false;
        Range r = null;
        try {
            r = Range.constructRange(range, mimetype, reader.getSize());
        }
        catch (IllegalArgumentException err) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Failed to parse range header - returning 416 status code: " + err.getMessage()));
            }
            res.setStatus(416);
            res.setHeader(HEADER_CONTENT_RANGE, "\"*\"");
            res.getOutputStream().close();
            return true;
        }
        res.setStatus(206);
        res.setContentType(mimetype);
        String contentRange = "bytes " + Long.toString(r.start) + "-" + Long.toString(r.end) + "/" + Long.toString(reader.getSize());
        res.setHeader(HEADER_CONTENT_RANGE, contentRange);
        res.setHeader(HEADER_CONTENT_LENGTH, Long.toString(r.end - r.start + 1L));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Processing: Content-Range: " + contentRange));
        }
        InputStream is = null;
        try {
            ServletOutputStream os = res.getOutputStream();
            is = reader.getContentInputStream();
            this.streamRangeBytes(r, is, os, 0L);
            os.close();
            processedRange = true;
        }
        catch (IOException err) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Unable to process single range due to IO Exception: " + err.getMessage()));
            }
            throw err;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return processedRange;
    }

    /*
     * Exception decompiling
     */
    private boolean processMultiRange(HttpServletResponse res, String range, NodeRef ref, QName property, String mimetype, String userAgent) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void streamRangeBytes(Range r, InputStream is, ServletOutputStream os, long offset) throws IOException {
        long span;
        Log logger = this.getLogger();
        boolean trace = logger.isTraceEnabled();
        if (r.start != 0L) {
            for (long skipped = offset; skipped < r.start; skipped += is.skip(r.start - skipped)) {
            }
        }
        long bytesLeft = span = r.end - r.start + 1L;
        int read = 0;
        byte[] buf = new byte[(int)bytesLeft < 65536 ? (int)bytesLeft : 65536];
        while ((read = is.read(buf)) > 0 && bytesLeft != 0L) {
            os.write(buf, 0, read);
            if ((bytesLeft -= (long)read) != 0L) {
                int resize;
                int n = resize = (int)bytesLeft < 65536 ? (int)bytesLeft : 65536;
                if (resize != buf.length) {
                    buf = new byte[resize];
                }
            }
            if (!trace) continue;
            logger.trace((Object)("...wrote " + read + " bytes, with " + bytesLeft + " to go..."));
        }
    }

    protected static final String generateUrl(String pattern, NodeRef ref, String name) {
        return MessageFormat.format(pattern, ref.getStoreRef().getProtocol(), ref.getStoreRef().getIdentifier(), ref.getId(), URLEncoder.encode((String)name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Range
    implements Comparable<Range> {
        private long start;
        private long end;
        private long entityLength;
        private String contentType;
        private String contentRange;

        Range(String contentType, long start, long end, long entityLength) {
            this.contentType = "Content-Type: " + contentType;
            this.start = start;
            this.end = end;
            this.entityLength = entityLength;
        }

        static Range constructRange(String range, String contentType, long entityLength) {
            int separator;
            if (range == null) {
                throw new IllegalArgumentException("Range argument is mandatory");
            }
            if (range.indexOf(47) != -1) {
                range = range.substring(0, range.indexOf(47));
            }
            if ((separator = range.indexOf(45)) == -1) {
                throw new IllegalArgumentException("Invalid range: " + range);
            }
            try {
                long start = 0L;
                if (separator != 0) {
                    start = Long.parseLong(range.substring(0, separator));
                }
                long end = entityLength - 1L;
                if (separator != range.length() - 1) {
                    end = Long.parseLong(range.substring(separator + 1));
                }
                return new Range(contentType, start, end, entityLength);
            }
            catch (NumberFormatException err) {
                throw new IllegalArgumentException("Unable to parse range value: " + range);
            }
        }

        void outputHeader(ServletOutputStream os) throws IOException {
            os.println(BaseDownloadContentServlet.MULTIPART_BYTERANGES_BOUNDRY_SEP);
            os.println(this.contentType);
            os.println(this.getContentRange());
            os.println();
        }

        int getLength() {
            return BaseDownloadContentServlet.MULTIPART_BYTERANGES_BOUNDRY_SEP.length() + 2 + this.contentType.length() + 2 + this.getContentRange().length() + 4 + (int)(this.end - this.start + 1L) + 2;
        }

        private String getContentRange() {
            if (this.contentRange == null) {
                this.contentRange = "Content-Range: bytes " + Long.toString(this.start) + "-" + Long.toString(this.end) + "/" + Long.toString(this.entityLength);
            }
            return this.contentRange;
        }

        public String toString() {
            return this.start + "-" + this.end;
        }

        @Override
        public int compareTo(Range o) {
            return this.start > o.start ? 1 : -1;
        }

        static /* synthetic */ long access$102(Range x0, long x1) {
            x0.end = x1;
            return x0.end;
        }

        static /* synthetic */ String access$200(Range x0) {
            return x0.getContentRange();
        }
    }
}

