/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.jsf.FacesContextUtils;

public abstract class BaseServlet
extends HttpServlet {
    public static final String FACES_SERVLET = "/faces";
    private static final String ARG_TICKET = "ticket";
    private static final String ARG_GUEST = "guest";
    private static final String MSG_ERROR_PERMISSIONS = "error_permissions";
    private static Set<String> validRedirectJSPs = new HashSet<String>();
    private static Log logger;

    public static ServiceRegistry getServiceRegistry(ServletContext sc) {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        return (ServiceRegistry)wc.getBean("ServiceRegistry");
    }

    public AuthenticationStatus servletAuthenticate(HttpServletRequest req, HttpServletResponse res) throws IOException {
        return this.servletAuthenticate(req, res, true);
    }

    public AuthenticationStatus servletAuthenticate(HttpServletRequest req, HttpServletResponse res, boolean redirectToLoginPage) throws IOException {
        AuthenticationStatus status;
        String ticket = req.getParameter(ARG_TICKET);
        if (ticket != null && ticket.length() != 0) {
            status = AuthenticationHelper.authenticate(this.getServletContext(), req, res, ticket);
        } else {
            boolean forceGuest = false;
            String guest = req.getParameter(ARG_GUEST);
            if (guest != null) {
                forceGuest = Boolean.parseBoolean(guest);
            }
            status = AuthenticationHelper.authenticate(this.getServletContext(), req, res, forceGuest);
        }
        if (status == AuthenticationStatus.Failure && redirectToLoginPage) {
            BaseServlet.redirectToLoginPage(req, res, this.getServletContext());
        }
        return status;
    }

    public boolean checkAccess(HttpServletRequest req, HttpServletResponse res, NodeRef nodeRef, String permission, boolean allowLogIn) throws IOException, ServletException {
        ServletContext sc = this.getServletContext();
        ServiceRegistry serviceRegistry = BaseServlet.getServiceRegistry(sc);
        PermissionService permissionService = serviceRegistry.getPermissionService();
        if (permissionService.hasPermission(nodeRef, permission) == AccessStatus.DENIED) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("User does not have " + permission + " permission for NodeRef: " + nodeRef.toString()));
            }
            if (allowLogIn && serviceRegistry.getAuthorityService().hasGuestAuthority()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Redirecting to login page...");
                }
                BaseServlet.redirectToLoginPage(req, res, sc);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Forwarding to error page...");
                }
                Application.handleSystemError(sc, req, res, MSG_ERROR_PERMISSIONS, 403, logger);
            }
            return false;
        }
        return true;
    }

    public static void redirectToLoginPage(HttpServletRequest req, HttpServletResponse res, ServletContext sc) throws IOException {
        StringBuilder redirectURL;
        block8: {
            String uri;
            block7: {
                redirectURL = new StringBuilder(1024).append(req.getContextPath()).append(FACES_SERVLET).append(Application.getLoginPage(sc));
                uri = req.getRequestURI();
                if (uri.indexOf(req.getContextPath() + FACES_SERVLET) == -1) break block7;
                int jspIndex = uri.indexOf(FACES_SERVLET) + FACES_SERVLET.length();
                if (uri.length() <= jspIndex || !BaseServlet.validRedirectJSP(uri.substring(jspIndex))) break block8;
            }
            if (redirectURL.indexOf("?") == -1) {
                redirectURL.append('?');
            } else {
                redirectURL.append('&');
            }
            redirectURL.append("_alfRedirect");
            redirectURL.append('=');
            String url = uri;
            String queryString = req.getQueryString();
            if (queryString != null) {
                queryString = queryString.replaceAll("(?<=^|&)ticket(=[^&=]*)?&", "");
                if ((queryString = queryString.replaceAll("(^|&)ticket(=[^&=]*)?(?=&|$)", "")).length() != 0) {
                    url = url + "?" + queryString;
                }
            }
            redirectURL.append(URLEncoder.encode(url, "UTF-8"));
        }
        res.sendRedirect(redirectURL.toString());
    }

    public static void setNoCacheHeaders(HttpServletResponse res) {
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Pragma", "no-cache");
    }

    public static boolean validRedirectJSP(String jsp) {
        return validRedirectJSPs.contains(jsp);
    }

    public static NodeRef resolveWebDAVPath(FacesContext context, String[] args) {
        WebApplicationContext wc = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context);
        return BaseServlet.resolveWebDAVPath(wc, args, true);
    }

    public static NodeRef resolveWebDAVPath(FacesContext context, String[] args, boolean decode) {
        WebApplicationContext wc = FacesContextUtils.getRequiredWebApplicationContext((FacesContext)context);
        return BaseServlet.resolveWebDAVPath(wc, args, decode);
    }

    public static NodeRef resolveWebDAVPath(ServletContext context, String[] args) {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        return BaseServlet.resolveWebDAVPath(wc, args, true);
    }

    public static NodeRef resolveWebDAVPath(ServletContext context, String[] args, boolean decode) {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        return BaseServlet.resolveWebDAVPath(wc, args, decode);
    }

    private static NodeRef resolveWebDAVPath(final WebApplicationContext wc, final String[] args, final boolean decode) {
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef nodeRef = null;
                ArrayList<String> paths = new ArrayList<String>(args.length - 1);
                FileInfo file = null;
                try {
                    for (int x = 1; x < args.length; ++x) {
                        paths.add(decode ? URLDecoder.decode((String)args[x]) : args[x]);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attempting to resolve webdav path: " + paths));
                    }
                    nodeRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId());
                    TenantService tenantService = (TenantService)wc.getBean("tenantService");
                    if (tenantService != null && tenantService.isEnabled()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"MT is enabled.");
                        }
                        NodeService nodeService = (NodeService)wc.getBean("NodeService");
                        SearchService searchService = (SearchService)wc.getBean("SearchService");
                        NamespaceService namespaceService = (NamespaceService)wc.getBean("NamespaceService");
                        String rootPath = wc.getServletContext().getInitParameter("rootPath");
                        nodeRef = tenantService.getRootNode(nodeService, searchService, namespaceService, rootPath, nodeRef);
                    }
                    if (paths.size() != 0) {
                        FileFolderService ffs = (FileFolderService)wc.getBean("FileFolderService");
                        file = ffs.resolveNamePath(nodeRef, paths);
                        nodeRef = file.getNodeRef();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Resolved webdav path to NodeRef: " + nodeRef));
                    }
                }
                catch (FileNotFoundException fne) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)"Failed to resolve webdav path", (Throwable)fne);
                    }
                    nodeRef = null;
                }
                return nodeRef;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public static final PathRefInfo resolveNamePath(ServletContext sc, String path) {
        StringTokenizer t = new StringTokenizer(path, "/");
        int tokenCount = t.countTokens();
        String[] elements = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            elements[i] = t.nextToken();
        }
        NodeRef nodeRef = BaseServlet.resolveWebDAVPath(sc, elements, false);
        if (nodeRef == null) {
            throw new IllegalArgumentException("Unable to resolve item Path: " + path);
        }
        return new PathRefInfo(nodeRef, elements[tokenCount - 1]);
    }

    static {
        validRedirectJSPs.add("/jsp/browse/browse.jsp");
        validRedirectJSPs.add("/jsp/admin/admin-console.jsp");
        validRedirectJSPs.add("/jsp/admin/avm-console.jsp");
        validRedirectJSPs.add("/jsp/admin/node-browser.jsp");
        validRedirectJSPs.add("/jsp/admin/store-browser.jsp");
        validRedirectJSPs.add("/jsp/users/user-console.jsp");
        validRedirectJSPs.add("/jsp/categories/categories.jsp");
        validRedirectJSPs.add("/jsp/dialog/about.jsp");
        validRedirectJSPs.add("/jsp/search/advanced-search.jsp");
        validRedirectJSPs.add("/jsp/admin/system-info.jsp");
        validRedirectJSPs.add("/jsp/forums/forums.jsp");
        validRedirectJSPs.add("/jsp/users/users.jsp");
        validRedirectJSPs.add("/jsp/trashcan/trash-list.jsp");
        logger = LogFactory.getLog(BaseServlet.class);
    }

    public static class PathRefInfo {
        public NodeRef NodeRef;
        public String Filename;

        PathRefInfo(NodeRef ref, String filename) {
            this.NodeRef = ref;
            this.Filename = filename;
        }
    }
}

