/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.management.subsystems.AbstractChainedSubsystemTest;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.DefaultChildApplicationContextManager;
import org.alfresco.repo.webdav.auth.RemoteUserMapper;
import org.alfresco.util.ApplicationContextHelper;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class DefaultRemoteUserMapperTest
extends AbstractChainedSubsystemTest {
    ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    DefaultChildApplicationContextManager childApplicationContextManager;
    ChildApplicationContextFactory childApplicationContextFactory;

    protected void setUp() throws Exception {
        this.childApplicationContextManager = (DefaultChildApplicationContextManager)this.ctx.getBean("Authentication");
        this.childApplicationContextManager.stop();
        this.childApplicationContextManager.setProperty("chain", "external1:external");
        this.childApplicationContextFactory = this.getChildApplicationContextFactory(this.childApplicationContextManager, "external1");
    }

    protected void tearDown() throws Exception {
        this.childApplicationContextManager.destroy();
        this.childApplicationContextManager = null;
        this.childApplicationContextFactory = null;
    }

    public void testUnproxiedHeader() throws Exception {
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "");
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"AdMiN");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn(null);
        DefaultRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn((Object)"ADMIN");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
    }

    public void testProxiedHeader() throws Exception {
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty("external.authentication.proxyUserName", "bob");
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn((Object)"bob");
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"AdMiN");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        this.childApplicationContextFactory.stop();
        this.childApplicationContextFactory.setProperty("external.authentication.userIdPattern", "abc-(.*)-999");
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"abc-AdMiN-999");
        DefaultRemoteUserMapperTest.assertEquals((String)"admin", (String)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getHeader("X-Alfresco-Remote-User")).thenReturn((Object)"abc-AdMiN-998");
        DefaultRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
        Mockito.when((Object)mockRequest.getRemoteUser()).thenReturn(null);
        DefaultRemoteUserMapperTest.assertNull((Object)((RemoteUserMapper)this.childApplicationContextFactory.getApplicationContext().getBean("remoteUserMapper")).getRemoteUser(mockRequest));
    }
}

