/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.servlet.BaseDownloadContentServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuestDownloadContentServlet
extends BaseDownloadContentServlet {
    private static final long serialVersionUID = -5258137503339817457L;
    private static Log logger = LogFactory.getLog(GuestDownloadContentServlet.class);
    private static final String DOWNLOAD_URL = "/gd/a/{0}/{1}/{2}/{3}";
    private static final String BROWSER_URL = "/gd/d/{0}/{1}/{2}/{3}";

    protected Log getLogger() {
        return logger;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            String queryString = req.getQueryString();
            logger.debug((Object)("Setting up guest access to URL: " + req.getRequestURI() + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        DownloadContentWork dcw = new DownloadContentWork(req, res);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)dcw, (String)AuthenticationUtil.getGuestUserName());
    }

    public static final String generateDownloadURL(NodeRef ref, String name) {
        return GuestDownloadContentServlet.generateUrl(DOWNLOAD_URL, ref, name);
    }

    public static final String generateBrowserURL(NodeRef ref, String name) {
        return GuestDownloadContentServlet.generateUrl(BROWSER_URL, ref, name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DownloadContentWork
    implements AuthenticationUtil.RunAsWork<Object> {
        private HttpServletRequest req = null;
        private HttpServletResponse res = null;

        public DownloadContentWork(HttpServletRequest req, HttpServletResponse res) {
            this.req = req;
            this.res = res;
        }

        public Object doWork() throws Exception {
            GuestDownloadContentServlet.this.processDownloadRequest(this.req, this.res, false, true);
            return null;
        }
    }
}

