/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowDeployment;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class JBPMDeployProcessServlet
extends HttpServlet {
    private static final long serialVersionUID = 8002539291245090187L;
    private static final String BEAN_GLOBAL_PROPERTIES = "global-properties";
    private static final String PROP_ENABLED = "system.workflow.deployservlet.enabled";

    public void init() throws ServletException {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        Properties globalProperties = (Properties)wc.getBean(BEAN_GLOBAL_PROPERTIES);
        String enabled = globalProperties.getProperty(PROP_ENABLED);
        if (enabled == null || !Boolean.parseBoolean(enabled)) {
            throw new UnavailableException("system.workflow.deployservlet.enabled=false");
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("text/html");
            InputStream deploymentArchive = this.getDeploymentArchive(request);
            WorkflowDefinition workflowDef = this.deployArchive(deploymentArchive);
            response.getWriter().println("Deployed archive " + workflowDef.title + " successfully");
        }
        catch (IOException e) {
            response.getWriter().println("IOException");
        }
        catch (FileUploadException e) {
            response.getWriter().println("FileUploadException");
        }
    }

    private InputStream getDeploymentArchive(HttpServletRequest request) throws FileUploadException, IOException {
        if (!FileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new FileUploadException("Not a multipart request");
        }
        GPDUpload fileUpload = new GPDUpload();
        List list = fileUpload.parseRequest(request);
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            throw new FileUploadException("No process file in the request");
        }
        FileItem fileItem = (FileItem)iterator.next();
        if (fileItem.getContentType().indexOf("application/x-zip-compressed") == -1) {
            throw new FileUploadException("Not a process archive");
        }
        return fileItem.getInputStream();
    }

    private WorkflowDefinition deployArchive(InputStream deploymentArchive) {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        WorkflowService workflowService = (WorkflowService)wc.getBean(ServiceRegistry.WORKFLOW_SERVICE.getLocalName());
        WorkflowDeployment deployment = workflowService.deployDefinition("jbpm", deploymentArchive, "application/zip");
        return deployment.definition;
    }

    private class GPDUpload
    extends DiskFileUpload {
        private GPDUpload() {
        }

        protected byte[] getBoundary(String contentType) {
            return super.getBoundary(contentType.replace(",", ";"));
        }
    }
}

