/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.ajax;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.app.servlet.ajax.BaseAjaxCommand;
import org.alfresco.web.bean.repository.Repository;

public class GetCommand
extends BaseAjaxCommand {
    public void execute(FacesContext facesContext, String expression, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String bindingExpr = this.makeBindingExpression(expression);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving value from value binding: " + bindingExpr));
        }
        UserTransaction tx = null;
        try {
            ValueBinding binding = facesContext.getApplication().createValueBinding(bindingExpr);
            if (binding != null) {
                tx = Repository.getUserTransaction(facesContext, true);
                tx.begin();
                Object value = binding.getValue(facesContext);
                if (value != null) {
                    response.getWriter().write(value.toString());
                }
                tx.commit();
            }
        }
        catch (Throwable err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AlfrescoRuntimeException("Failed to retrieve value: " + err.getMessage(), err);
        }
    }
}

