/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkPropertiesDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -167326851073011187L;
    private Node editableNode = null;

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.editableNode = null;
    }

    public Map<String, Object> getProperties() {
        return this.getEditableNode().getProperties();
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    public Node getEditableNode() {
        if (this.editableNode == null) {
            if (this.parameters.containsKey("nodeRef")) {
                this.editableNode = new Node(new NodeRef((String)this.parameters.get("nodeRef")));
            } else {
                throw new IllegalArgumentException("Dialog has not been initialised with noderef or setup action event called.");
            }
        }
        return this.editableNode;
    }

    public void setupFileLinkForAction(ActionEvent event) {
        this.editableNode = new Node(this.browseBean.getDocument().getNodeRef());
    }

    public void setupFolderLinkForAction(ActionEvent event) {
        this.editableNode = new Node(this.browseBean.getActionSpace().getNodeRef());
    }

    public String getDestinationPath() {
        NodeRef destRef = (NodeRef)this.getEditableNode().getProperties().get(ContentModel.PROP_LINK_DESTINATION);
        return Repository.getNamePath(this.getNodeService(), this.getNodeService().getPath(destRef), null, "/", null);
    }

    public String getFileLinkBookmarkUrl() {
        NodeRef destRef = (NodeRef)this.browseBean.getDocument().getProperties().get(ContentModel.PROP_LINK_DESTINATION);
        return Utils.generateURL(FacesContext.getCurrentInstance(), new Node(destRef), Utils.URLMode.SHOW_DETAILS);
    }

    public String getSpaceLinkDestinationUrl() {
        NodeRef destRef = (NodeRef)this.browseBean.getActionSpace().getProperties().get(ContentModel.PROP_LINK_DESTINATION);
        return Utils.generateURL(FacesContext.getCurrentInstance(), new Node(destRef), Utils.URLMode.SHOW_DETAILS);
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        try {
            NodeRef nodeRef = this.getEditableNode().getNodeRef();
            Map<String, Object> props = this.getEditableNode().getProperties();
            String name = (String)props.get(ContentModel.PROP_NAME);
            if (name != null) {
                this.getFileFolderService().rename(nodeRef, name);
            }
            Map properties = this.getNodeService().getProperties(nodeRef);
            String title = (String)props.get(ContentModel.PROP_TITLE);
            String description = (String)props.get(ContentModel.PROP_DESCRIPTION);
            if (title != null || description != null) {
                this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
            }
            for (String propName : props.keySet()) {
                PropertyDefinition propDef;
                QName qname = QName.createQName((String)propName);
                Serializable propValue = (Serializable)props.get(propName);
                if (propValue != null && propValue instanceof String && propValue.toString().length() == 0 && (propDef = this.getDictionaryService().getProperty(qname)) != null && (propDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG))) {
                    propValue = null;
                }
                properties.put(qname, propValue);
            }
            this.getNodeService().setProperties(nodeRef, properties);
            if (this.browseBean.getDocument() != null) {
                this.browseBean.getDocument().reset();
            }
        }
        catch (InvalidNodeRefException err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_noderef"), this.browseBean.getDocument().getId()));
            outcome = "dialog:close:browse";
        }
        catch (Throwable e) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(context, "error_generic"), e.getMessage()), e);
            outcome = null;
            ReportedException.throwIfNecessary(e);
        }
        return outcome;
    }
}

