/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.ExpiringValueCache;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.data.QuickSort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateSupportBean
implements Serializable {
    private static final long serialVersionUID = 6698338879903536081L;
    private static final String MSG_SELECT_TEMPLATE = "select_a_template";
    private static final String MSG_SELECT_SCRIPT = "select_a_script";
    public static final String NO_SELECTION = "none";
    private transient NodeService nodeService;
    private transient SearchService searchService;
    private ExpiringValueCache<List<SelectItem>> contentTemplates = new ExpiringValueCache(30000L);
    private ExpiringValueCache<List<SelectItem>> emailTemplates = new ExpiringValueCache(30000L);
    private ExpiringValueCache<List<SelectItem>> rssTemplates = new ExpiringValueCache(30000L);
    private ExpiringValueCache<List<SelectItem>> scriptFiles = new ExpiringValueCache(30000L);

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    private SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public List<SelectItem> getContentTemplates() {
        List<SelectItem> templates = (List<SelectItem>)this.contentTemplates.get();
        if (templates == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getContentTemplatesFolderName(fc) + "//*";
            templates = this.selectDictionaryNodes(fc, xpath, MSG_SELECT_TEMPLATE, "text/plain");
            this.contentTemplates.put(templates);
        }
        return templates;
    }

    public List<SelectItem> getEmailTemplates() {
        List<SelectItem> templates = (List<SelectItem>)this.emailTemplates.get();
        if (templates == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getEmailTemplatesFolderName(fc) + "//*";
            templates = this.selectDictionaryNodes(fc, xpath, MSG_SELECT_TEMPLATE, "text/plain");
            this.emailTemplates.put(templates);
        }
        return templates;
    }

    public List<SelectItem> getNotifyEmailTemplates() {
        List<SelectItem> templates = null;
        FacesContext fc = FacesContext.getCurrentInstance();
        String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getEmailTemplatesFolderName(fc) + "/" + Application.getNotifyEmailTemplatesFolderName(fc) + "//*";
        templates = this.selectDictionaryNodes(fc, xpath, MSG_SELECT_TEMPLATE, "text/plain");
        return templates;
    }

    public List<SelectItem> getRSSTemplates() {
        List<SelectItem> templates = (List<SelectItem>)this.rssTemplates.get();
        if (templates == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getRSSTemplatesFolderName(fc) + "//*";
            templates = this.selectDictionaryNodes(fc, xpath, MSG_SELECT_TEMPLATE, "text/plain");
            this.rssTemplates.put(templates);
        }
        return templates;
    }

    public List<SelectItem> getScriptFiles() {
        List<SelectItem> scripts = (List<SelectItem>)this.scriptFiles.get();
        if (scripts == null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            String xpath = Application.getRootPath(fc) + "/" + Application.getGlossaryFolderName(fc) + "/" + Application.getScriptsFolderName(fc) + "//*";
            scripts = this.selectDictionaryNodes(fc, xpath, MSG_SELECT_SCRIPT, "application/x-javascript");
            this.scriptFiles.put(scripts);
        }
        return scripts;
    }

    private List<SelectItem> selectDictionaryNodes(FacesContext fc, String xpath, String noSelectionLabel) {
        return this.selectDictionaryNodes(fc, xpath, noSelectionLabel, null);
    }

    private List<SelectItem> selectDictionaryNodes(FacesContext fc, String xpath, String noSelectionLabel, String mimetype) {
        ArrayList<Object> wrappers = null;
        try {
            NodeRef rootNodeRef = this.getNodeService().getRootNode(Repository.getStoreRef());
            NamespaceService resolver = Repository.getServiceRegistry(fc).getNamespaceService();
            List results = this.getSearchService().selectNodes(rootNodeRef, xpath, null, (NamespacePrefixResolver)resolver, false);
            wrappers = new ArrayList(results.size() + 1);
            if (results.size() != 0) {
                DictionaryService dd = Repository.getServiceRegistry(fc).getDictionaryService();
                for (NodeRef ref : results) {
                    if (!this.getNodeService().exists(ref)) continue;
                    Node childNode = new Node(ref);
                    ContentData content = (ContentData)childNode.getProperties().get(ContentModel.PROP_CONTENT);
                    if (!dd.isSubClass(childNode.getType(), ContentModel.TYPE_CONTENT) || mimetype != null && !mimetype.equals(content.getMimetype())) continue;
                    wrappers.add(new SelectItem((Object)childNode.getId(), childNode.getName()));
                }
                QuickSort sorter = new QuickSort(wrappers, "label", true, "case-insensitive");
                sorter.sort();
            }
        }
        catch (AccessDeniedException accessErr) {
            // empty catch block
        }
        if (wrappers == null) {
            wrappers = new ArrayList<SelectItem>(1);
        }
        wrappers.add(0, new SelectItem((Object)NO_SELECTION, Application.getMessage(FacesContext.getCurrentInstance(), noSelectionLabel)));
        return wrappers;
    }
}

