/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.SelectItem;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.IHandler;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.BaseWizardBean;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIGenericPicker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActionWizard
extends BaseWizardBean {
    protected static final String PROP_ACTION_NAME = "actionName";
    protected static final String PROP_ACTION_SUMMARY = "actionSummary";
    protected static final String PROP_ACTION_EMAIL_RECIPIENTS = "actionEmailRecipients";
    protected static final String NO_PARAMS_MARKER = "noParamsMarker";
    protected static final String ERROR_ACTION_CANNOT_BE_EXECUTE_REPEATEDLY = "action_cannot_be_execute_repeatedly";
    private transient ActionService actionService;
    private transient MimetypeService mimetypeService;
    private transient PersonService personService;
    private transient AuthorityService authorityService;
    protected List<SelectItem> actions;
    protected List<SelectItem> transformers;
    protected List<SelectItem> imageTransformers;
    protected List<SelectItem> commonAspects;
    protected List<SelectItem> removableAspects;
    protected List<SelectItem> addableAspects;
    protected List<SelectItem> testableAspects;
    protected List<SelectItem> users;
    protected List<SelectItem> encodings;
    protected List<SelectItem> objectTypes;
    protected transient DataModel allActionsDataModel;
    protected transient DataModel currentEmailRecipientsDataModel;
    protected boolean editingAction;
    protected String action;
    protected String usingTemplate = null;
    protected String returnViewId = null;
    protected Map<String, Serializable> currentActionProperties;
    protected List<Map<String, Serializable>> allActionsProperties;
    protected Map<String, IHandler> actionHandlers;
    private static final Log logger = LogFactory.getLog(BaseActionWizard.class);

    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.action = null;
        this.users = null;
        this.actions = null;
        this.currentEmailRecipientsDataModel = null;
        this.usingTemplate = null;
        this.allActionsProperties = new ArrayList<Map<String, Serializable>>();
        this.currentActionProperties = new HashMap<String, Serializable>(3);
        this.editingAction = false;
        this.initialiseActionHandlers();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getUsingTemplate() {
        return this.usingTemplate;
    }

    public void setUsingTemplate(String usingTemplate) {
        this.usingTemplate = usingTemplate;
    }

    public DataModel getAllActionsDataModel() {
        if (this.allActionsDataModel == null) {
            this.allActionsDataModel = new ListDataModel();
        }
        this.allActionsDataModel.setWrappedData(this.allActionsProperties);
        return this.allActionsDataModel;
    }

    public DataModel getEmailRecipientsDataModel() {
        if (this.currentEmailRecipientsDataModel == null) {
            this.currentEmailRecipientsDataModel = new ListDataModel();
        }
        this.currentEmailRecipientsDataModel.setWrappedData(this.getEmailRecipients(this.currentActionProperties));
        return this.currentEmailRecipientsDataModel;
    }

    public Map<String, Serializable> getActionProperties() {
        return this.currentActionProperties;
    }

    public List<SelectItem> getActions() {
        if (this.actions == null) {
            List ruleActions = this.getActionService().getActionDefinitions();
            this.actions = new ArrayList<SelectItem>();
            for (ActionDefinition ruleActionDef : ruleActions) {
                String title = ruleActionDef.getTitle();
                if (title == null || title.length() == 0) {
                    title = ruleActionDef.getName();
                }
                this.actions.add(new SelectItem((Object)ruleActionDef.getName(), title));
            }
            QuickSort sorter = new QuickSort(this.actions, "label", true, "case-insensitive");
            sorter.sort();
            this.actions.add(0, new SelectItem((Object)"null", Application.getMessage(FacesContext.getCurrentInstance(), "select_an_action")));
        }
        return this.actions;
    }

    public List<SelectItem> getRemovableAspects() {
        if (this.removableAspects == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.removableAspects = new ArrayList<SelectItem>();
            this.removableAspects.addAll(this.getCommonAspects());
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement aspectsCfg = wizardCfg.getConfigElement("aspects-remove");
                if (aspectsCfg != null) {
                    List<SelectItem> aspects = this.readAspectsConfig(FacesContext.getCurrentInstance(), aspectsCfg);
                    this.removableAspects.addAll(aspects);
                } else {
                    logger.warn((Object)"Could not find 'aspects-remove' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
            QuickSort sorter = new QuickSort(this.removableAspects, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.removableAspects;
    }

    public List<SelectItem> getAddableAspects() {
        if (this.addableAspects == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.addableAspects = new ArrayList<SelectItem>();
            this.addableAspects.addAll(this.getCommonAspects());
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement aspectsCfg = wizardCfg.getConfigElement("aspects-add");
                if (aspectsCfg != null) {
                    List<SelectItem> aspects = this.readAspectsConfig(FacesContext.getCurrentInstance(), aspectsCfg);
                    this.addableAspects.addAll(aspects);
                } else {
                    logger.warn((Object)"Could not find 'aspects-add' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
            QuickSort sorter = new QuickSort(this.addableAspects, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.addableAspects;
    }

    public List<SelectItem> getTestableAspects() {
        if (this.testableAspects == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.testableAspects = new ArrayList<SelectItem>();
            this.testableAspects.addAll(this.getCommonAspects());
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement aspectsCfg = wizardCfg.getConfigElement("aspects-test");
                if (aspectsCfg != null) {
                    List<SelectItem> aspects = this.readAspectsConfig(FacesContext.getCurrentInstance(), aspectsCfg);
                    this.testableAspects.addAll(aspects);
                } else {
                    logger.warn((Object)"Could not find 'aspects-test' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
            QuickSort sorter = new QuickSort(this.testableAspects, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.testableAspects;
    }

    public List<SelectItem> getObjectTypes() {
        if (this.objectTypes == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.objectTypes = new ArrayList<SelectItem>(5);
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement typesCfg = wizardCfg.getConfigElement("specialise-types");
                if (typesCfg != null) {
                    for (ConfigElement child : typesCfg.getChildren()) {
                        QName idQName = Repository.resolveToQName(child.getAttribute("name"));
                        TypeDefinition typeDef = this.getDictionaryService().getType(idQName);
                        if (typeDef == null || typeDef.getName().equals((Object)ContentModel.TYPE_CONTENT) || typeDef.getName().equals((Object)ContentModel.TYPE_FOLDER) || !this.getDictionaryService().isSubClass(typeDef.getName(), ContentModel.TYPE_CONTENT) && !this.getDictionaryService().isSubClass(typeDef.getName(), ContentModel.TYPE_FOLDER)) continue;
                        String label = Utils.getDisplayLabel(context, child);
                        if (label == null) {
                            label = typeDef.getTitle();
                        }
                        if (label == null) {
                            label = idQName.getLocalName();
                        }
                        this.objectTypes.add(new SelectItem((Object)idQName.toString(), label));
                    }
                    QuickSort sorter = new QuickSort(this.objectTypes, "label", true, "case-insensitive");
                    sorter.sort();
                    this.objectTypes.add(0, new SelectItem((Object)"null", Application.getMessage(FacesContext.getCurrentInstance(), "select_a_type")));
                } else {
                    logger.warn((Object)"Could not find 'specialise-types' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
        }
        return this.objectTypes;
    }

    public List<SelectItem> getUsers() {
        if (this.users == null) {
            List<Node> userNodes = Repository.getUsers(FacesContext.getCurrentInstance(), this.getNodeService(), this.getSearchService());
            this.users = new ArrayList<SelectItem>();
            for (Node user : userNodes) {
                String email = (String)user.getProperties().get("email");
                if (email == null || email.length() <= 0) continue;
                this.users.add(new SelectItem((Object)email, (String)user.getProperties().get("fullName")));
            }
            QuickSort sorter = new QuickSort(this.users, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.users;
    }

    public List<SelectItem> getTransformers() {
        if (this.transformers == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement transformersCfg = wizardCfg.getConfigElement("transformers");
                if (transformersCfg != null) {
                    FacesContext context = FacesContext.getCurrentInstance();
                    Map mimeTypes = this.getMimetypeService().getDisplaysByMimetype();
                    this.transformers = new ArrayList<SelectItem>();
                    for (ConfigElement child : transformersCfg.getChildren()) {
                        String id = child.getAttribute("name");
                        String label = Utils.getDisplayLabel(context, child);
                        if (label == null) {
                            label = (String)mimeTypes.get(id);
                        }
                        if (label == null) {
                            label = id;
                        }
                        this.transformers.add(new SelectItem((Object)id, label));
                    }
                    QuickSort sorter = new QuickSort(this.transformers, "label", true, "case-insensitive");
                    sorter.sort();
                } else {
                    logger.warn((Object)"Could not find 'transformers' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
        }
        return this.transformers;
    }

    public List<SelectItem> getImageTransformers() {
        if (this.imageTransformers == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement transformersCfg = wizardCfg.getConfigElement("image-transformers");
                if (transformersCfg != null) {
                    FacesContext context = FacesContext.getCurrentInstance();
                    Map mimeTypes = this.getMimetypeService().getDisplaysByMimetype();
                    this.imageTransformers = new ArrayList<SelectItem>();
                    for (ConfigElement child : transformersCfg.getChildren()) {
                        String id = child.getAttribute("name");
                        String label = Utils.getDisplayLabel(context, child);
                        if (label == null) {
                            label = (String)mimeTypes.get(id);
                        }
                        if (label == null) {
                            label = id;
                        }
                        this.imageTransformers.add(new SelectItem((Object)id, label));
                    }
                    QuickSort sorter = new QuickSort(this.imageTransformers, "label", true, "case-insensitive");
                    sorter.sort();
                } else {
                    logger.warn((Object)"Could not find 'image-transformers' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
        }
        return this.imageTransformers;
    }

    public List<RecipientWrapper> getEmailRecipients(Map<String, Serializable> actionProperties) {
        ArrayList currentEmailRecipients = (ArrayList)actionProperties.get(PROP_ACTION_EMAIL_RECIPIENTS);
        if (currentEmailRecipients == null) {
            currentEmailRecipients = new ArrayList(4);
            actionProperties.put(PROP_ACTION_EMAIL_RECIPIENTS, currentEmailRecipients);
        }
        return currentEmailRecipients;
    }

    public void promptForActionValues() {
        this.editingAction = false;
        FacesContext context = FacesContext.getCurrentInstance();
        this.returnViewId = context.getViewRoot().getViewId();
        String viewId = null;
        HashMap<String, Serializable> actionProps = new HashMap<String, Serializable>(3);
        actionProps.put(PROP_ACTION_NAME, (Serializable)((Object)this.action));
        this.currentActionProperties = actionProps;
        this.currentEmailRecipientsDataModel = null;
        IHandler handler = this.actionHandlers.get(this.action);
        if (handler != null && !handler.isAllowMultiple() && this.isActionPresent(this.action)) {
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), ERROR_ACTION_CANNOT_BE_EXECUTE_REPEATEDLY));
            return;
        }
        if (handler != null) {
            handler.setupUIDefaults(actionProps);
            viewId = handler.getJSPPath();
        } else {
            ActionDefinition actionDef = this.getActionService().getActionDefinition(this.action);
            actionProps.put(PROP_ACTION_SUMMARY, (Serializable)((Object)actionDef.getTitle()));
            actionProps.put(NO_PARAMS_MARKER, (Serializable)((Object)"no-params"));
            this.allActionsProperties.add(actionProps);
            viewId = this.returnViewId;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added '" + this.action + "' action to list"));
        }
        this.goToPage(context, viewId);
    }

    public void editAction() {
        int index = this.allActionsDataModel.getRowIndex();
        this.currentActionProperties = this.allActionsProperties.get(index);
        this.action = (String)((Object)this.currentActionProperties.get(PROP_ACTION_NAME));
        this.currentEmailRecipientsDataModel = null;
        this.editingAction = true;
        FacesContext context = FacesContext.getCurrentInstance();
        this.returnViewId = context.getViewRoot().getViewId();
        this.goToPage(context, this.actionHandlers.get(this.action).getJSPPath());
    }

    public void addAction() {
        FacesContext context = FacesContext.getCurrentInstance();
        String summary = this.actionHandlers.get(this.action).generateSummary(context, this, this.currentActionProperties);
        if (summary != null) {
            this.currentActionProperties.put(PROP_ACTION_SUMMARY, (Serializable)((Object)summary));
        }
        if (!this.editingAction) {
            this.allActionsProperties.add(this.currentActionProperties);
        }
        this.action = null;
        this.goToPage(context, this.returnViewId);
    }

    public void removeAction() {
        int index = this.allActionsDataModel.getRowIndex();
        this.allActionsProperties.remove(index);
        this.action = null;
        FacesContext context = FacesContext.getCurrentInstance();
        this.goToPage(context, context.getViewRoot().getViewId());
    }

    public void cancelAddAction() {
        if (!this.editingAction) {
            this.currentActionProperties.clear();
        }
        this.action = null;
        this.goToPage(FacesContext.getCurrentInstance(), this.returnViewId);
    }

    public void addRecipient(ActionEvent event) {
        UIGenericPicker picker = (UIGenericPicker)event.getComponent();
        String[] results = picker.getSelectedResults();
        if (results != null && results.length != 0) {
            List<RecipientWrapper> currentEmailRecipients = this.getEmailRecipients(this.currentActionProperties);
            for (String authority : results) {
                RecipientWrapper wrapper;
                boolean alreadyAdded = false;
                for (int i = 0; i < currentEmailRecipients.size(); ++i) {
                    wrapper = currentEmailRecipients.get(i);
                    if (!wrapper.getAuthority().equals(authority)) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                String name = this.displayLabelForAuthority(authority);
                wrapper = new RecipientWrapper(name, authority);
                currentEmailRecipients.add(wrapper);
            }
        }
    }

    public void removeRecipient(ActionEvent event) {
        List<RecipientWrapper> currentEmailRecipients = this.getEmailRecipients(this.currentActionProperties);
        int index = this.currentEmailRecipientsDataModel.getRowIndex();
        currentEmailRecipients.remove(index);
    }

    public void insertTemplate(ActionEvent event) {
        String template = (String)((Object)this.currentActionProperties.get("template"));
        if (template != null && !template.equals("none")) {
            try {
                NodeRef templateRef = new NodeRef(Repository.getStoreRef(), template);
                ContentService cs = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getContentService();
                ContentReader reader = cs.getReader(templateRef, ContentModel.PROP_CONTENT);
                if (reader != null && reader.exists()) {
                    this.currentActionProperties.put("message", (Serializable)((Object)reader.getContentString()));
                    this.usingTemplate = template;
                }
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            }
        }
    }

    public void discardTemplate(ActionEvent event) {
        this.currentActionProperties.put("message", (Serializable)((Object)""));
        this.usingTemplate = null;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    protected ActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getActionService();
        }
        return this.actionService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected MimetypeService getMimetypeService() {
        if (this.mimetypeService == null) {
            this.mimetypeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMimetypeService();
        }
        return this.mimetypeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPersonService();
        }
        return this.personService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    protected AuthorityService getAuthorityService() {
        if (this.authorityService == null) {
            this.authorityService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthorityService();
        }
        return this.authorityService;
    }

    public String displayLabelForAuthority(String authority) {
        String label = authority;
        if (this.getPersonService().personExists(authority)) {
            NodeRef ref = this.getPersonService().getPerson(authority);
            Node node = new Node(ref);
            label = (String)node.getProperties().get(ContentModel.PROP_FIRSTNAME) + ' ' + (String)node.getProperties().get(ContentModel.PROP_LASTNAME);
        }
        return label;
    }

    protected void goToPage(FacesContext context, String viewId) {
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        UIViewRoot viewRoot = viewHandler.createView(context, viewId);
        viewRoot.setViewId(viewId);
        context.setViewRoot(viewRoot);
        context.renderResponse();
    }

    protected void initialiseActionHandlers() {
        if (this.actionHandlers == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement actionHandlerCfg = wizardCfg.getConfigElement("action-handlers");
                if (actionHandlerCfg != null) {
                    this.actionHandlers = new HashMap<String, IHandler>(20);
                    for (ConfigElement child : actionHandlerCfg.getChildren()) {
                        String actionName = child.getAttribute("name");
                        String handlerClass = child.getAttribute("class");
                        if (actionName == null || actionName.length() <= 0 || handlerClass == null || handlerClass.length() <= 0) continue;
                        try {
                            Class<?> klass = Class.forName(handlerClass);
                            IHandler handler = (IHandler)klass.newInstance();
                            this.actionHandlers.put(actionName, handler);
                        }
                        catch (Exception e) {
                            throw new AlfrescoRuntimeException("Failed to setup action handler for '" + actionName + "'", (Throwable)e);
                        }
                    }
                } else {
                    logger.warn((Object)"Could not find 'action-handlers' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
        }
    }

    protected List<SelectItem> getCommonAspects() {
        if (this.commonAspects == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigService svc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config wizardCfg = svc.getConfig((Object)"Action Wizards");
            if (wizardCfg != null) {
                ConfigElement aspectsCfg = wizardCfg.getConfigElement("aspects");
                if (aspectsCfg != null) {
                    this.commonAspects = this.readAspectsConfig(FacesContext.getCurrentInstance(), aspectsCfg);
                } else {
                    logger.warn((Object)"Could not find 'aspects' configuration element");
                }
            } else {
                logger.warn((Object)"Could not find 'Action Wizards' configuration section");
            }
        }
        return this.commonAspects;
    }

    protected List<SelectItem> readAspectsConfig(FacesContext context, ConfigElement aspectsCfg) {
        ArrayList<SelectItem> aspects = new ArrayList<SelectItem>();
        for (ConfigElement child : aspectsCfg.getChildren()) {
            QName idQName = Repository.resolveToQName(child.getAttribute("name"));
            if (idQName != null) {
                String label = Utils.getDisplayLabel(context, child);
                if (label == null) {
                    AspectDefinition aspectDef = this.getDictionaryService().getAspect(idQName);
                    label = aspectDef != null ? aspectDef.getTitle() : idQName.getLocalName();
                }
                aspects.add(new SelectItem((Object)idQName.toString(), label));
                continue;
            }
            logger.warn((Object)("Failed to resolve aspect '" + child.getAttribute("name") + "'"));
        }
        return aspects;
    }

    public boolean isFinishButtonDisabled() {
        List currentEmailRecipients = (List)((Object)this.currentActionProperties.get(PROP_ACTION_EMAIL_RECIPIENTS));
        if (currentEmailRecipients != null) {
            return currentEmailRecipients.isEmpty();
        }
        return true;
    }

    protected boolean isActionPresent(String actionName) {
        for (Map<String, Serializable> prop : this.allActionsProperties) {
            Serializable name = prop.get(PROP_ACTION_NAME);
            if (name == null || !name.equals(actionName)) continue;
            return true;
        }
        return false;
    }

    public static class RecipientWrapper
    implements Serializable {
        private static final long serialVersionUID = -3331836277440957711L;
        private String name;
        private String authority;

        public RecipientWrapper(String name, String authority) {
            this.name = name;
            this.authority = authority;
        }

        public String getName() {
            return this.name;
        }

        public String getAuthority() {
            return this.authority;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RecipientWrapper) {
                return this.authority.equals(((RecipientWrapper)obj).getAuthority());
            }
            return false;
        }

        public int hashCode() {
            return this.authority.hashCode();
        }
    }
}

