/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.actions.handlers;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.actions.handlers.BaseActionHandler;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wizard.IWizardBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveHandler
extends BaseActionHandler {
    private static final long serialVersionUID = 2778547560606246126L;

    @Override
    public String getJSPPath() {
        return this.getJSPPath("move");
    }

    @Override
    public void prepareForSave(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        NodeRef destNodeRef = (NodeRef)actionProps.get("destinationLocation");
        repoProps.put("destination-folder", (Serializable)destNodeRef);
        repoProps.put("assoc-type", (Serializable)ContentModel.ASSOC_CONTAINS);
        repoProps.put("assoc-name", (Serializable)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"move"));
    }

    @Override
    public void prepareForEdit(Map<String, Serializable> actionProps, Map<String, Serializable> repoProps) {
        NodeRef destNodeRef = (NodeRef)repoProps.get("destination-folder");
        actionProps.put("destinationLocation", (Serializable)destNodeRef);
    }

    @Override
    public String generateSummary(FacesContext context, IWizardBean wizard, Map<String, Serializable> actionProps) {
        NodeRef space = (NodeRef)actionProps.get("destinationLocation");
        String spaceName = Repository.getNameForNode(Repository.getServiceRegistry(context).getNodeService(), space);
        return MessageFormat.format(Application.getMessage(context, "action_move"), spaceName);
    }

    @Override
    public boolean isAllowMultiple() {
        return false;
    }
}

