/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.Serializable;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.app.servlet.ajax.InvokeCommand;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.json.JSONWriter;

public class PickerBean
implements Serializable {
    private static final long serialVersionUID = 8950457520023294902L;
    private static final String MSG_CATEGORIES = "categories";
    private static final String MSG_TAGS = "tags";
    private static final String ID_URL = "url";
    private static final String ID_ICON = "icon";
    private static final String ID_CHILDREN = "children";
    private static final String ID_SELECTABLE = "selectable";
    private static final String ID_ISROOT = "isroot";
    private static final String ID_NAME = "name";
    private static final String ID_ID = "id";
    private static final String ID_PARENT = "parent";
    private static final String PARAM_PARENT = "parent";
    private static final String PARAM_CHILD = "child";
    private static final String PARAM_MIMETYPES = "mimetypes";
    private static final String FOLDER_IMAGE_PREFIX = "/images/icons/";
    private static Log logger = LogFactory.getLog(PickerBean.class);
    private transient CategoryService categoryService;
    private transient NodeService nodeService;
    private transient NodeService internalNodeService;
    private transient FileFolderService fileFolderService;

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    private CategoryService getCategoryService() {
        if (this.categoryService == null) {
            this.categoryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCategoryService();
        }
        return this.categoryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setInternalNodeService(NodeService internalNodeService) {
        this.internalNodeService = internalNodeService;
    }

    private NodeService getInternalNodeService() {
        if (this.internalNodeService == null) {
            this.internalNodeService = (NodeService)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "nodeService");
        }
        return this.internalNodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    private FileFolderService getFileFolderService() {
        if (this.fileFolderService == null) {
            this.fileFolderService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getFileFolderService();
        }
        return this.fileFolderService;
    }

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void getCategoryNodes() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            Collection childRefs;
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            NodeRef parentRef = null;
            Map params = fc.getExternalContext().getRequestParameterMap();
            String strParentRef = (String)params.get("parent");
            if (strParentRef == null || strParentRef.length() == 0) {
                childRefs = this.getCategoryService().getRootCategories(Repository.getStoreRef(), ContentModel.ASPECT_GEN_CLASSIFIABLE);
            } else {
                parentRef = new NodeRef(strParentRef);
                childRefs = this.getCategoryService().getChildren(parentRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE);
            }
            JSONWriter out = new JSONWriter((Writer)fc.getResponseWriter());
            out.startObject();
            out.startValue("parent");
            out.startObject();
            if (parentRef == null) {
                out.writeNullValue(ID_ID);
                out.writeValue(ID_NAME, Application.getMessage(fc, MSG_CATEGORIES));
                out.writeValue(ID_ISROOT, true);
                out.writeValue(ID_SELECTABLE, false);
            } else {
                out.writeValue(ID_ID, strParentRef);
                out.writeValue(ID_NAME, Repository.getNameForNode(this.getInternalNodeService(), parentRef));
            }
            out.endObject();
            out.endValue();
            out.startValue(ID_CHILDREN);
            out.startArray();
            for (ChildAssociationRef ref : childRefs) {
                NodeRef nodeRef = ref.getChildRef();
                out.startObject();
                out.writeValue(ID_ID, nodeRef.toString());
                out.writeValue(ID_NAME, Repository.getNameForNode(this.getInternalNodeService(), nodeRef));
                out.endObject();
            }
            out.endArray();
            out.endValue();
            out.endObject();
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage("PickerBean exception in getCategoryRootNodes()", err);
            fc.getResponseWriter().write("ERROR: " + err.getMessage());
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void getTagNodes() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            Collection childRefs;
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            NodeRef parentRef = null;
            Map params = fc.getExternalContext().getRequestParameterMap();
            String strParentRef = (String)params.get("parent");
            if (strParentRef == null || strParentRef.length() == 0) {
                childRefs = this.getCategoryService().getRootCategories(Repository.getStoreRef(), ContentModel.ASPECT_TAGGABLE);
            } else {
                parentRef = new NodeRef(strParentRef);
                childRefs = this.getCategoryService().getChildren(parentRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE);
            }
            JSONWriter out = new JSONWriter((Writer)fc.getResponseWriter());
            out.startObject();
            out.startValue("parent");
            out.startObject();
            if (parentRef == null) {
                out.writeNullValue(ID_ID);
                out.writeValue(ID_NAME, Application.getMessage(fc, MSG_TAGS));
                out.writeValue(ID_ISROOT, true);
                out.writeValue(ID_SELECTABLE, false);
            } else {
                out.writeValue(ID_ID, strParentRef);
                out.writeValue(ID_NAME, Repository.getNameForNode(this.getInternalNodeService(), parentRef));
            }
            out.endObject();
            out.endValue();
            out.startValue(ID_CHILDREN);
            out.startArray();
            for (ChildAssociationRef ref : childRefs) {
                NodeRef nodeRef = ref.getChildRef();
                out.startObject();
                out.writeValue(ID_ID, nodeRef.toString());
                out.writeValue(ID_NAME, Repository.getNameForNode(this.getInternalNodeService(), nodeRef));
                out.endObject();
            }
            out.endArray();
            out.endValue();
            out.endObject();
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage("PickerBean exception in getTagNodes()", err);
            fc.getResponseWriter().write("ERROR: " + err.getMessage());
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void getFolderNodes() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            NodeRef companyHomeRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId(fc));
            NodeRef parentRef = null;
            Map params = fc.getExternalContext().getRequestParameterMap();
            String strChildRef = (String)params.get(PARAM_CHILD);
            if (strChildRef != null && strChildRef.length() != 0) {
                NodeRef childRef = new NodeRef(strChildRef);
                parentRef = this.getNodeService().getPrimaryParent(childRef).getParentRef();
            } else {
                String strParentRef = (String)params.get("parent");
                if (strParentRef == null || strParentRef.length() == 0) {
                    parentRef = companyHomeRef;
                    strParentRef = parentRef.toString();
                } else {
                    parentRef = new NodeRef(strParentRef);
                }
            }
            List folders = this.getFileFolderService().listFolders(parentRef);
            JSONWriter out = new JSONWriter((Writer)fc.getResponseWriter());
            out.startObject();
            out.startValue("parent");
            out.startObject();
            out.writeValue(ID_ID, parentRef.toString());
            out.writeValue(ID_NAME, Repository.getNameForNode(this.getInternalNodeService(), parentRef));
            if (parentRef.equals((Object)companyHomeRef)) {
                out.writeValue(ID_ISROOT, true);
            }
            out.endObject();
            out.endValue();
            out.startValue(ID_CHILDREN);
            out.startArray();
            for (FileInfo folder : folders) {
                out.startObject();
                out.writeValue(ID_ID, folder.getNodeRef().toString());
                out.writeValue(ID_NAME, (String)folder.getProperties().get(ContentModel.PROP_NAME));
                String icon = (String)folder.getProperties().get(ApplicationModel.PROP_ICON);
                out.writeValue(ID_ICON, FOLDER_IMAGE_PREFIX + (icon != null ? icon + "-16.gif" : "space_small.gif"));
                out.endObject();
            }
            out.endArray();
            out.endValue();
            out.endObject();
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage("PickerBean exception in getFolderNodes()", err);
            fc.getResponseWriter().write("ERROR: " + err.getMessage());
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }

    @InvokeCommand.ResponseMimetype(value="text/html")
    public void getFileFolderNodes() throws Exception {
        FacesContext fc = FacesContext.getCurrentInstance();
        UserTransaction tx = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            DictionaryService dd = Repository.getServiceRegistry(fc).getDictionaryService();
            ContentService cs = Repository.getServiceRegistry(fc).getContentService();
            NodeRef companyHomeRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId(fc));
            NodeRef parentRef = null;
            Map params = fc.getExternalContext().getRequestParameterMap();
            String strChildRef = (String)params.get(PARAM_CHILD);
            if (strChildRef != null && strChildRef.length() != 0) {
                NodeRef childRef = new NodeRef(strChildRef);
                parentRef = this.getNodeService().getPrimaryParent(childRef).getParentRef();
            } else {
                String strParentRef = (String)params.get("parent");
                if (strParentRef == null || strParentRef.length() == 0) {
                    parentRef = companyHomeRef;
                    strParentRef = parentRef.toString();
                } else {
                    parentRef = new NodeRef(strParentRef);
                }
            }
            HashSet<String> mimetypes = null;
            String mimetypeParam = (String)params.get(PARAM_MIMETYPES);
            if (mimetypeParam != null && mimetypeParam.length() != 0) {
                mimetypes = new HashSet<String>();
                StringTokenizer t = new StringTokenizer(mimetypeParam, ",");
                while (t.hasMoreTokens()) {
                    mimetypes.add(t.nextToken());
                }
            }
            List items = this.getFileFolderService().list(parentRef);
            JSONWriter out = new JSONWriter((Writer)fc.getResponseWriter());
            out.startObject();
            out.startValue("parent");
            out.startObject();
            out.writeValue(ID_ID, parentRef.toString());
            out.writeValue(ID_NAME, Repository.getNameForNode(this.getInternalNodeService(), parentRef));
            if (parentRef.equals((Object)companyHomeRef)) {
                out.writeValue(ID_ISROOT, true);
            }
            out.writeValue(ID_SELECTABLE, false);
            out.endObject();
            out.endValue();
            out.startValue(ID_CHILDREN);
            out.startArray();
            for (FileInfo item : items) {
                if (dd.isSubClass(this.getInternalNodeService().getType(item.getNodeRef()), ContentModel.TYPE_FOLDER)) {
                    out.startObject();
                    out.writeValue(ID_ID, item.getNodeRef().toString());
                    String name = (String)item.getProperties().get(ContentModel.PROP_NAME);
                    out.writeValue(ID_NAME, name);
                    String icon = (String)item.getProperties().get(ApplicationModel.PROP_ICON);
                    out.writeValue(ID_ICON, FOLDER_IMAGE_PREFIX + (icon != null ? icon + "-16.gif" : "space_small.gif"));
                    out.writeValue(ID_SELECTABLE, false);
                    out.endObject();
                    continue;
                }
                boolean validFile = true;
                if (mimetypes != null) {
                    validFile = false;
                    ContentReader reader = cs.getReader(item.getNodeRef(), ContentModel.PROP_CONTENT);
                    if (reader != null) {
                        String mimetype = reader.getMimetype();
                        boolean bl = validFile = mimetype != null && mimetypes.contains(mimetype);
                    }
                }
                if (!validFile) continue;
                out.startObject();
                out.writeValue(ID_ID, item.getNodeRef().toString());
                String name = (String)item.getProperties().get(ContentModel.PROP_NAME);
                out.writeValue(ID_NAME, name);
                String icon = FileTypeImageUtils.getFileTypeImage((FacesContext)fc, (String)name, (FileTypeImageSize)FileTypeImageSize.Small);
                out.writeValue(ID_ICON, icon);
                out.writeValue(ID_URL, DownloadContentServlet.generateBrowserURL(item.getNodeRef(), name));
                out.endObject();
            }
            out.endArray();
            out.endValue();
            out.endObject();
            tx.commit();
        }
        catch (Throwable err) {
            Utils.addErrorMessage("PickerBean exception in getFileFolderNodes()", err);
            fc.getResponseWriter().write("ERROR: " + err.getMessage());
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
    }
}

