/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.ajax;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.alfresco.repo.template.I18NMessageMethod;
import org.alfresco.repo.template.Workflow;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.web.app.servlet.BaseTemplateContentServlet;
import org.alfresco.web.bean.repository.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskInfoBean
implements Serializable {
    private static final long serialVersionUID = -6627537519541525897L;
    private transient WorkflowService workflowService;
    private TemplateImageResolver imageResolver = new TemplateImageResolver(){

        public String resolveImagePathForName(String filename, FileTypeImageSize size) {
            return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
        }
    };

    public void sendTaskInfo() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        String taskId = (String)context.getExternalContext().getRequestParameterMap().get("taskId");
        if (taskId == null || taskId.length() == 0) {
            throw new IllegalArgumentException("'taskId' parameter is missing");
        }
        WorkflowTask task = this.getWorkflowService().getTaskById(taskId);
        if (task != null) {
            Repository.getServiceRegistry(context).getTemplateService().processTemplate("/alfresco/templates/client/task_summary_panel.ftl", this.getModel(task), (Writer)out);
        } else {
            out.write("<span class='errorMessage'>Task could not be found.</span>");
        }
    }

    public void sendTaskResources() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        ResponseWriter out = context.getResponseWriter();
        String taskId = (String)context.getExternalContext().getRequestParameterMap().get("taskId");
        if (taskId == null || taskId.length() == 0) {
            throw new IllegalArgumentException("'taskId' parameter is missing");
        }
        WorkflowTask task = this.getWorkflowService().getTaskById(taskId);
        if (task != null) {
            Repository.getServiceRegistry(context).getTemplateService().processTemplate("/alfresco/templates/client/task_resource_panel.ftl", this.getModel(task), (Writer)out);
        } else {
            out.write("<span class='errorMessage'>Task could not be found.</span>");
        }
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    private WorkflowService getWorkflowService() {
        if (this.workflowService == null) {
            this.workflowService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getWorkflowService();
        }
        return this.workflowService;
    }

    private Map<String, Object> getModel(WorkflowTask task) {
        FacesContext context = FacesContext.getCurrentInstance();
        HashMap<String, Object> model = new HashMap<String, Object>(8, 1.0f);
        model.put("date", new Date());
        model.put("msg", new I18NMessageMethod());
        model.put("url", new BaseTemplateContentServlet.URLHelper(context));
        model.put("task", new Workflow.WorkflowTaskItem(Repository.getServiceRegistry(context), this.imageResolver, task));
        return model;
    }
}

