/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.categories;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.categories.CategoriesDialog;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.alfresco.web.ui.repo.component.IRepoBreadcrumbHandler;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditCategoryDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 3316665625854694278L;
    private static final String DEFAULT_OUTCOME = "finish";
    private static final String MSG_EDIT_CATEGORY = "edit_category";
    private static final String MSG_FINISH = "finish_button";
    private static final String MSG_CATEGORIES = "categories";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    protected transient CategoryService categoryService;
    private Node actionCategory = null;
    private Node category = null;
    String categoryRef = null;
    private List<IBreadcrumbHandler> location = null;
    private Collection<ChildAssociationRef> members = null;
    protected UIRichList categoriesRichList;
    private String name = null;
    private String description = null;

    @Override
    public void init(Map<String, String> parameters) {
        this.isFinished = false;
        this.categoryRef = parameters.get("categoryRef");
        ParameterCheck.mandatoryString((String)"categoryRef", (String)this.categoryRef);
        this.category = new Node(new NodeRef(this.categoryRef));
        this.setActionCategory(this.category);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UIRichList getCategoriesRichList() {
        return this.categoriesRichList;
    }

    public void setCategoriesRichList(UIRichList categoriesRichList) {
        this.categoriesRichList = categoriesRichList;
    }

    private CategoryService getCategoryService() {
        if (this.categoryService == null) {
            this.categoryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCategoryService();
        }
        return this.categoryService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public Node getCategory() {
        return this.category;
    }

    public void setCategory(Node category) {
        this.category = category;
    }

    public Collection<ChildAssociationRef> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<ChildAssociationRef> members) {
        this.members = members;
    }

    public void setActionCategory(Node node) {
        this.actionCategory = node;
        if (node != null) {
            this.setName(node.getName());
            this.setDescription((String)node.getProperties().get(ContentModel.PROP_DESCRIPTION));
            this.setMembers(this.getCategoryService().getChildren(node.getNodeRef(), CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY));
        } else {
            this.setName(null);
            this.setDescription(null);
            List emptyCollection = Collections.emptyList();
            this.setMembers(emptyCollection);
        }
    }

    public Node getActionCategory() {
        return this.actionCategory;
    }

    @Override
    public boolean getFinishButtonDisabled() {
        return false;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        this.finishEdit();
        return outcome;
    }

    @Override
    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, MSG_EDIT_CATEGORY) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getActionCategory().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    @Override
    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_FINISH);
    }

    public void setLocation(List<IBreadcrumbHandler> location) {
        this.location = location;
    }

    public List<IBreadcrumbHandler> getLocation() {
        if (this.location == null) {
            CategoriesDialog categoriesDialog;
            ArrayList<IBreadcrumbHandler> loc = new ArrayList<IBreadcrumbHandler>(8);
            CategoriesDialog categoriesDialog2 = categoriesDialog = new CategoriesDialog();
            categoriesDialog2.getClass();
            loc.add(categoriesDialog2.new CategoriesDialog.CategoryBreadcrumbHandler(null, Application.getMessage(FacesContext.getCurrentInstance(), MSG_CATEGORIES)));
            this.setLocation(loc);
        }
        return this.location;
    }

    public String finishEdit() {
        String outcome = DEFAULT_OUTCOME;
        try {
            NodeRef nodeRef = this.getActionCategory().getNodeRef();
            this.getNodeService().setProperty(nodeRef, ContentModel.PROP_NAME, (Serializable)((Object)this.getName()));
            ChildAssociationRef assocRef = this.getNodeService().getPrimaryParent(nodeRef);
            QName qname = QName.createQName((String)assocRef.getQName().getNamespaceURI(), (String)QName.createValidLocalName((String)this.name));
            this.getNodeService().moveNode(assocRef.getChildRef(), assocRef.getParentRef(), assocRef.getTypeQName(), qname);
            if (!this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_TITLED)) {
                HashMap<QName, String> titledProps = new HashMap<QName, String>(1, 1.0f);
                titledProps.put(ContentModel.PROP_DESCRIPTION, this.getDescription());
                this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_TITLED, titledProps);
            } else {
                this.getNodeService().setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)this.getDescription()));
            }
            List<IBreadcrumbHandler> location = this.getLocation();
            IBreadcrumbHandler handler = location.get(location.size() - 1);
            if (nodeRef.equals((Object)((IRepoBreadcrumbHandler)handler).getNodeRef())) {
                CategoriesDialog categoriesDialog;
                CategoriesDialog categoriesDialog2 = categoriesDialog = new CategoriesDialog();
                categoriesDialog2.getClass();
                CategoriesDialog.CategoryBreadcrumbHandler newHandler = categoriesDialog2.new CategoriesDialog.CategoryBreadcrumbHandler(nodeRef, Repository.getNameForNode(this.getNodeService(), nodeRef));
                location.set(location.size() - 1, newHandler);
            }
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            outcome = null;
            ReportedException.throwIfNecessary(err);
        }
        return outcome;
    }
}

