/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.clipboard;

import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.CrossRepositoryCopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.util.WCMUtil;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.clipboard.AbstractClipboardItem;
import org.alfresco.web.bean.clipboard.ClipboardStatus;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;

public class WorkspaceClipboardItem
extends AbstractClipboardItem {
    private static final long serialVersionUID = -1686557602737846009L;
    private static final String WORKSPACE_PASTE_VIEW_ID = "/jsp/browse/browse.jsp";
    private static final String AVM_PASTE_VIEW_ID = "/jsp/wcm/browse-sandbox.jsp";
    private static final String FORUMS_PASTE_VIEW_ID = "/jsp/forums/forums.jsp";
    private static final String FORUM_PASTE_VIEW_ID = "/jsp/forums/forum.jsp";
    private static final String MSG_LINK_TO = "link_to";
    private static final String LINK_NODE_EXTENSION = ".url";

    public WorkspaceClipboardItem(NodeRef ref, ClipboardStatus mode) {
        super(ref, mode);
    }

    public boolean supportsLink() {
        return true;
    }

    public boolean canCopyToViewId(String viewId) {
        if (AVM_PASTE_VIEW_ID.equals(viewId)) {
            AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "AVMBrowseBean");
            String destPath = avmBrowseBean.getCurrentPath();
            return !WCMUtil.isStagingStore((String)WCMUtil.getStoreName((String)destPath));
        }
        return WORKSPACE_PASTE_VIEW_ID.equals(viewId) || FORUMS_PASTE_VIEW_ID.equals(viewId) || FORUM_PASTE_VIEW_ID.equals(viewId);
    }

    public boolean canMoveToViewId(String viewId) {
        return WORKSPACE_PASTE_VIEW_ID.equals(viewId) || FORUMS_PASTE_VIEW_ID.equals(viewId) || FORUM_PASTE_VIEW_ID.equals(viewId);
    }

    public boolean paste(FacesContext fc, String viewId, int action) throws Throwable {
        if (WORKSPACE_PASTE_VIEW_ID.equals(viewId) || FORUMS_PASTE_VIEW_ID.equals(viewId) || FORUM_PASTE_VIEW_ID.equals(viewId)) {
            NavigationBean navigator = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
            NodeRef destRef = new NodeRef(Repository.getStoreRef(), navigator.getCurrentNodeId());
            DictionaryService dd = this.getServiceRegistry().getDictionaryService();
            NodeService nodeService = this.getServiceRegistry().getNodeService();
            FileFolderService fileFolderService = this.getServiceRegistry().getFileFolderService();
            CopyService copyService = this.getServiceRegistry().getCopyService();
            MultilingualContentService multilingualContentService = this.getServiceRegistry().getMultilingualContentService();
            ChildAssociationRef assocRef = nodeService.getPrimaryParent(this.getNodeRef());
            String name = this.getName();
            String translationPrefix = "";
            if (action == 4) {
                String linkTo = Application.getMessage(fc, MSG_LINK_TO);
                name = linkTo + ' ' + name;
            }
            boolean operationComplete = false;
            while (!operationComplete) {
                String copyOf;
                UserTransaction tx = null;
                try {
                    tx = Repository.getUserTransaction(fc);
                    tx.begin();
                    if (this.getMode() == ClipboardStatus.COPY) {
                        if (action == 4) {
                            ChildAssociationRef childRef;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Attempting to link node ID: " + this.getNodeRef() + " into node: " + destRef.toString()));
                            }
                            if (this.checkExists(name + LINK_NODE_EXTENSION, destRef)) continue;
                            HashMap<QName, String> props = new HashMap<QName, String>(2, 1.0f);
                            String newName = name + LINK_NODE_EXTENSION;
                            props.put(ContentModel.PROP_NAME, newName);
                            props.put(ContentModel.PROP_LINK_DESTINATION, (String)this.getNodeRef());
                            if (dd.isSubClass(this.getType(), ContentModel.TYPE_CONTENT)) {
                                childRef = nodeService.createNode(destRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)assocRef.getQName().getNamespaceURI(), (String)newName), ApplicationModel.TYPE_FILELINK, props);
                                HashMap<QName, String> titledProps = new HashMap<QName, String>(2, 1.0f);
                                titledProps.put(ContentModel.PROP_TITLE, name);
                                titledProps.put(ContentModel.PROP_DESCRIPTION, name);
                                nodeService.addAspect(childRef.getChildRef(), ContentModel.ASPECT_TITLED, titledProps);
                            } else {
                                childRef = nodeService.createNode(destRef, ContentModel.ASSOC_CONTAINS, assocRef.getQName(), ApplicationModel.TYPE_FOLDERLINK, props);
                                HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(4, 1.0f);
                                uiFacetsProps.put(ApplicationModel.PROP_ICON, "space-icon-link");
                                uiFacetsProps.put(ContentModel.PROP_TITLE, name);
                                uiFacetsProps.put(ContentModel.PROP_DESCRIPTION, name);
                                nodeService.addAspect(childRef.getChildRef(), ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
                            }
                            operationComplete = true;
                            continue;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Attempting to copy node: " + this.getNodeRef() + " into node ID: " + destRef.toString()));
                        }
                        if (destRef.equals((Object)assocRef.getParentRef()) && name.equals(this.getName())) {
                            copyOf = Application.getMessage(fc, "copy_of");
                            name = copyOf + ' ' + name;
                        }
                        if (dd.isSubClass(this.getType(), ContentModel.TYPE_CONTENT) || dd.isSubClass(this.getType(), ContentModel.TYPE_FOLDER)) {
                            fileFolderService.copy(this.getNodeRef(), destRef, name);
                        } else if (dd.isSubClass(this.getType(), ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
                            multilingualContentService.copyTranslationContainer(this.getNodeRef(), destRef, translationPrefix);
                        } else if (!this.checkExists(name, destRef)) {
                            copyService.copyAndRename(this.getNodeRef(), destRef, ContentModel.ASSOC_CONTAINS, assocRef.getQName(), true);
                        }
                        operationComplete = true;
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Attempting to move node: " + this.getNodeRef() + " into node ID: " + destRef.toString()));
                    }
                    if (dd.isSubClass(this.getType(), ContentModel.TYPE_CONTENT) || dd.isSubClass(this.getType(), ContentModel.TYPE_FOLDER)) {
                        fileFolderService.move(this.getNodeRef(), destRef, name);
                    } else if (dd.isSubClass(this.getType(), ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
                        multilingualContentService.moveTranslationContainer(this.getNodeRef(), destRef);
                    } else {
                        nodeService.moveNode(this.getNodeRef(), destRef, ContentModel.ASSOC_CONTAINS, assocRef.getQName());
                    }
                    operationComplete = true;
                }
                catch (FileExistsException fileExistsErr) {
                    if (this.getMode() == ClipboardStatus.COPY) continue;
                    throw fileExistsErr;
                }
                catch (Throwable e) {
                    throw e;
                }
                finally {
                    if (!operationComplete) {
                        try {
                            if (tx != null) {
                                tx.rollback();
                            }
                        }
                        catch (Exception tex) {}
                        copyOf = Application.getMessage(fc, "copy_of");
                        name = copyOf + ' ' + name;
                        translationPrefix = copyOf + ' ' + translationPrefix;
                        continue;
                    }
                    tx.commit();
                }
            }
            return operationComplete;
        }
        if (AVM_PASTE_VIEW_ID.equals(viewId)) {
            AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(fc, "AVMBrowseBean");
            String destPath = avmBrowseBean.getCurrentPath();
            NodeRef destRef = AVMNodeConverter.ToNodeRef((int)-1, (String)destPath);
            CrossRepositoryCopyService crossRepoCopyService = this.getServiceRegistry().getCrossRepositoryCopyService();
            String name = this.getName();
            boolean operationComplete = false;
            while (!operationComplete) {
                UserTransaction tx = null;
                try {
                    tx = Repository.getUserTransaction(fc);
                    tx.begin();
                    if (this.getMode() == ClipboardStatus.COPY) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Attempting to copy node: " + this.getNodeRef() + " into node ID: " + destRef.toString()));
                        }
                        crossRepoCopyService.copy(this.getNodeRef(), destRef, name);
                        if (destRef.getStoreRef().getProtocol().equals("avm")) {
                            AVMNodeDescriptor desc = this.getAvmService().lookup(-1, destPath + "/" + name);
                            this.recursiveFormCheck(desc);
                        }
                        operationComplete = true;
                        continue;
                    }
                    throw new Exception("Move operation not supported between stores.");
                }
                catch (FileExistsException fileExistsErr) {
                    if (this.getMode() == ClipboardStatus.COPY) continue;
                    throw fileExistsErr;
                }
                catch (Throwable e) {
                    throw e;
                }
                finally {
                    if (!operationComplete) {
                        try {
                            if (tx != null) {
                                tx.rollback();
                            }
                        }
                        catch (Exception tex) {}
                        String copyOf = Application.getMessage(fc, "copy_of");
                        name = copyOf + ' ' + name;
                        continue;
                    }
                    tx.commit();
                }
            }
            return operationComplete;
        }
        return false;
    }
}

