/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.coci;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMAppModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.coci.CCProperties;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.ui.common.ReportedException;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckinCheckoutDialog
extends BaseDialogBean {
    private static final long serialVersionUID = -4898900470274506760L;
    private static Log logger = LogFactory.getLog(CheckinCheckoutDialog.class);
    public static final String MSG_ERROR_CHECKIN = "error_checkin";
    public static final String MSG_ERROR_CANCELCHECKOUT = "error_cancel_checkout";
    public static final String MSG_ERROR_UPDATE = "error_update";
    public static final String MSG_ERROR_CHECKOUT = "error_checkout";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";
    public static final String FILE = "file";
    protected CCProperties property;

    public void setProperty(CCProperties property) {
        this.property = property;
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public BrowseBean getBrowseBean() {
        return this.browseBean;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getFinishButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), "check_in");
    }

    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(fc, "check_in") + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.property.getDocument().getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public boolean isVersionable() {
        return this.property.getDocument().hasAspect(ContentModel.ASPECT_VERSIONABLE);
    }

    public String getFileUploadSuccessMsg() {
        String msg = Application.getMessage(FacesContext.getCurrentInstance(), "file_upload_success");
        return MessageFormat.format(msg, Utils.encode((String)this.getFileName()));
    }

    public String getFileName() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            this.property.setFile(fileBean.getFile());
            this.property.setFileName(fileBean.getFileName());
        }
        return this.property.getFileName();
    }

    public void setFileName(String fileName) {
        this.property.setFileName(fileName);
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            fileBean.setFileName(this.property.getFileName());
        }
    }

    protected void clearUpload(String id) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        FileUploadBean fileBean = (FileUploadBean)ctx.getExternalContext().getSessionMap().get("alfresco.UploadBean");
        if (fileBean != null) {
            fileBean.setFile(null);
            fileBean.setFileName(null);
        }
    }

    public String removeUploadedFile() {
        this.clearUpload(FILE);
        this.property.setFileName(null);
        this.property.setFile(null);
        return null;
    }

    public void setupContentAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            this.setupContentDocument(id);
        } else {
            this.property.setDocument(null);
        }
        this.resetState();
    }

    public void setupWorkflowContentAction(ActionEvent event) {
        this.setupContentAction(event);
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.property.setWorkflowTaskId(params.get("taskId"));
        this.property.setWorkflowAction(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setup for workflow package action for task id: " + this.property.getWorkflowTaskId()));
        }
    }

    protected Node setupContentDocument(String id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setup for action, setting current document to: " + id));
        }
        Node node = null;
        try {
            NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
            node = new Node(ref);
            String url = DownloadContentServlet.generateDownloadURL(ref, node.getName());
            node.getProperties().put("url", url);
            node.getProperties().put("workingCopy", node.hasAspect(ContentModel.ASPECT_WORKING_COPY));
            node.getProperties().put("fileType32", FileTypeImageUtils.getFileTypeImage((String)node.getName(), (boolean)false));
            this.property.setDocument(node);
            UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            throw new AbortProcessingException("Invalid node reference");
        }
        return node;
    }

    public void editFile(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        try {
            if (id != null && id.length() != 0) {
                ContentReader reader;
                FacesContext fc;
                boolean editingInline = false;
                Node node = this.setupContentDocument(id);
                if (node.hasAspect(WCMAppModel.ASPECT_FORM_INSTANCE_DATA)) {
                    editingInline = true;
                    fc = FacesContext.getCurrentInstance();
                    this.navigator.setupDispatchContext(node);
                    fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "wizard:editContent");
                } else if (node.hasAspect(ApplicationModel.ASPECT_INLINEEDITABLE) && node.getProperties().get(ApplicationModel.PROP_EDITINLINE) != null && ((Boolean)node.getProperties().get(ApplicationModel.PROP_EDITINLINE)).booleanValue() && (reader = this.property.getContentService().getReader(node.getNodeRef(), ContentModel.PROP_CONTENT)) != null) {
                    editingInline = true;
                    String mimetype = reader.getMimetype();
                    if ("text/plain".equals(mimetype) || "text/xml".equals(mimetype) || "text/css".equals(mimetype) || "application/x-javascript".equals(mimetype)) {
                        this.property.setEditorOutput(reader.getContentString());
                        FacesContext fc2 = FacesContext.getCurrentInstance();
                        this.navigator.setupDispatchContext(node);
                        fc2.getApplication().getNavigationHandler().handleNavigation(fc2, null, "dialog:editTextInline");
                    } else {
                        this.property.setDocumentContent(reader.getContentString());
                        this.property.setEditorOutput(null);
                        FacesContext fc3 = FacesContext.getCurrentInstance();
                        this.navigator.setupDispatchContext(node);
                        fc3.getApplication().getNavigationHandler().handleNavigation(fc3, null, "dialog:editHtmlInline");
                    }
                }
                if (!editingInline) {
                    fc = FacesContext.getCurrentInstance();
                    this.navigator.setupDispatchContext(node);
                    fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:editFile");
                }
            }
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
        }
    }

    public String editInline(FacesContext context, String outcome) {
        Node node = this.property.getDocument();
        if (node != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to update content node Id: " + node.getId()));
                }
                ContentWriter writer = this.property.getContentService().getWriter(node.getNodeRef(), ContentModel.PROP_CONTENT, true);
                writer.putContent(this.property.getEditorOutput());
                this.resetState();
                this.property.setDocument(null);
                this.property.setDocumentContent(null);
                this.property.setEditorOutput(null);
            }
            catch (Throwable err) {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_UPDATE) + err.getMessage());
                outcome = null;
                ReportedException.throwIfNecessary(err);
            }
        } else {
            logger.warn((Object)"WARNING: editInlineOK called without a current Document!");
        }
        return outcome;
    }

    public String undoCheckout() {
        String outcome = null;
        Node node = this.property.getWorkingDocument();
        if (node != null) {
            try {
                this.property.getVersionOperationsService().cancelCheckout(node.getNodeRef());
                this.resetState();
                outcome = "dialog:close";
            }
            catch (Throwable err) {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_CANCELCHECKOUT) + err.getMessage(), err);
                ReportedException.throwIfNecessary(err);
            }
        } else {
            logger.warn((Object)"WARNING: undoCheckout called without a current WorkingDocument!");
        }
        return outcome;
    }

    public String checkinFileOK(final FacesContext context, String outcome) {
        final Node node = this.property.getDocument();
        if (node != null && (this.property.getCopyLocation().equals("current") || this.getFileName() != null && !this.getFileName().equals(""))) {
            try {
                RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
                RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        String contentUrl;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Trying to checkin content node Id: " + node.getId()));
                        }
                        if (CheckinCheckoutDialog.this.property.getCopyLocation().equals("current")) {
                            ContentData contentData = (ContentData)node.getProperties().get(ContentModel.PROP_CONTENT);
                            contentUrl = contentData == null ? null : contentData.getContentUrl();
                        } else {
                            ContentWriter writer = CheckinCheckoutDialog.this.property.getContentService().getWriter(node.getNodeRef(), ContentModel.PROP_CONTENT, true);
                            String mimeType = Repository.getMimeTypeForFileName(context, CheckinCheckoutDialog.this.property.getFileName());
                            writer.setMimetype(mimeType);
                            writer.putContent(CheckinCheckoutDialog.this.property.getFile());
                            contentUrl = writer.getContentUrl();
                        }
                        if (contentUrl == null || contentUrl.length() == 0) {
                            throw new IllegalStateException("Content URL is empty for specified working copy content node!");
                        }
                        HashMap<String, String> props = new HashMap<String, String>(1, 1.0f);
                        props.put("description", CheckinCheckoutDialog.this.property.getVersionNotes());
                        if (CheckinCheckoutDialog.this.property.getMinorChange()) {
                            props.put("versionType", (String)VersionType.MINOR);
                        } else {
                            props.put("versionType", (String)VersionType.MAJOR);
                        }
                        CheckinCheckoutDialog.this.property.getVersionOperationsService().checkin(node.getNodeRef(), props, contentUrl, CheckinCheckoutDialog.this.property.getKeepCheckedOut());
                        return null;
                    }
                };
                txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                outcome = "dialog:close";
                if (!this.property.isWorkflowAction()) {
                    outcome = outcome + ":" + "browse";
                }
                this.property.setDocument(null);
                this.resetState();
            }
            catch (Throwable err) {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_CHECKIN) + err.getMessage(), err);
                ReportedException.throwIfNecessary(err);
            }
        } else {
            logger.warn((Object)"WARNING: checkinFileOK called without a current Document!");
        }
        return outcome;
    }

    public String updateFileOK(final FacesContext context, String outcome) {
        final Node node = this.property.getDocument();
        if (node != null && this.getFileName() != null) {
            try {
                RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
                RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Trying to update content node Id: " + node.getId()));
                        }
                        ContentWriter writer = CheckinCheckoutDialog.this.property.getContentService().getWriter(node.getNodeRef(), ContentModel.PROP_CONTENT, true);
                        String mimeType = Repository.getMimeTypeForFileName(context, CheckinCheckoutDialog.this.property.getFileName());
                        writer.setMimetype(mimeType);
                        writer.putContent(CheckinCheckoutDialog.this.property.getFile());
                        return null;
                    }
                };
                txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
                this.property.setDocument(null);
                this.resetState();
                outcome = "dialog:close";
            }
            catch (Throwable err) {
                Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), MSG_ERROR_UPDATE) + err.getMessage(), err);
                ReportedException.throwIfNecessary(err);
            }
        } else {
            logger.warn((Object)"WARNING: updateFileOK called without a current Document!");
        }
        return outcome;
    }

    public String cancel() {
        String outcome = this.getDefaultCancelOutcome();
        FacesContext.getCurrentInstance().getExternalContext().getSessionMap().remove("externalDialogContainer");
        this.resetState();
        return outcome;
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    public void resetState() {
        if (this.property.getFile() != null) {
            this.property.getFile().delete();
        }
        this.property.setFile(null);
        this.property.setFileName(null);
        this.property.setKeepCheckedOut(false);
        this.property.setMinorChange(true);
        this.property.setCopyLocation("current");
        this.property.setVersionNotes("");
        this.property.setSelectedSpaceId(null);
        this.property.setWorkflowAction(false);
        this.property.setWorkflowTaskId(null);
        FacesContext ctx = FacesContext.getCurrentInstance();
        ctx.getExternalContext().getSessionMap().remove("alfresco.UploadBean");
    }
}

