/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.text.MessageFormat;
import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteContentDialog
extends BaseDialogBean {
    private static final long serialVersionUID = 4199496011879649213L;
    private transient MultilingualContentService multilingualContentService;
    private static final Log logger = LogFactory.getLog(DeleteContentDialog.class);

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        Node node = this.browseBean.getDocument();
        if (node != null) {
            if (ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)node.getType())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to delete multilingual container: " + node.getId() + " and its translations"));
                }
                this.getMultilingualContentService().deleteTranslationContainer(node.getNodeRef());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying to delete content node: " + node.getId()));
                }
                this.getNodeService().deleteNode(node.getNodeRef());
            }
        } else {
            logger.warn((Object)"WARNING: delete called without a current Document!");
        }
        return outcome;
    }

    protected String doPostCommitProcessing(FacesContext context, String outcome) {
        this.browseBean.setDocument(null);
        return "dialog:close:browse";
    }

    protected String getErrorMessageId() {
        return "error_delete_file";
    }

    public boolean getFinishButtonDisabled() {
        return false;
    }

    public String getConfirmMessage() {
        String strHasMultipleParents;
        String fileConfirmMsg = null;
        Node document = this.browseBean.getDocument();
        fileConfirmMsg = document.getType().equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER) ? Application.getMessage(FacesContext.getCurrentInstance(), "delete_ml_container_confirm") : (document.hasAspect(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION) ? Application.getMessage(FacesContext.getCurrentInstance(), "delete_empty_translation_confirm") : (document.hasAspect(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT) ? Application.getMessage(FacesContext.getCurrentInstance(), "delete_translation_confirm") : ((strHasMultipleParents = (String)this.parameters.get("hasMultipleParents")) != null && "true".equals(strHasMultipleParents) ? Application.getMessage(FacesContext.getCurrentInstance(), "delete_file_multiple_parents_confirm") : Application.getMessage(FacesContext.getCurrentInstance(), "delete_file_confirm"))));
        return MessageFormat.format(fileConfirmMsg, document.getName());
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    protected MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }
}

