/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.BaseDetailsBean;
import org.alfresco.web.bean.dialog.NavigationSupport;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.UIActionLink;

public class DocumentLinkDetailsDialog
extends BaseDetailsBean
implements NavigationSupport {
    private static final long serialVersionUID = 4716260640608281667L;
    private static final String MSG_DETAILS_OF = "details_of";
    private static final String MSG_LOCATION = "location";
    private static final String MSG_CLOSE = "close";
    private static final String MSG_LEFT_QUOTE = "left_qoute";
    private static final String MSG_RIGHT_QUOTE = "right_quote";

    public Node getDocument() {
        return this.getNode();
    }

    protected Node getLinkResolvedNode() {
        Node document = this.getDocument();
        if (ApplicationModel.TYPE_FILELINK.equals((Object)document.getType())) {
            NodeRef destRef = (NodeRef)document.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (this.getNodeService().exists(destRef)) {
                document = new Node(destRef);
            }
        }
        return document;
    }

    public Node getNode() {
        return this.browseBean.getDocument();
    }

    protected String getPropertiesPanelId() {
        return "document-props";
    }

    public Map getTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(2, 1.0f);
        model.put("document", this.getDocument().getNodeRef());
        model.put("space", this.navigator.getCurrentNode().getNodeRef());
        model.put("imageresolver", this.imageResolver);
        return model;
    }

    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    public String getCurrentItemId() {
        return this.getId();
    }

    public String getOutcome() {
        return "dialog:close:dialog:showDocDetails";
    }

    public void nextItem(ActionEvent event) {
        List<Node> nodes;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0 && (nodes = this.browseBean.getContent()).size() > 1) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (!id.equals(nodes.get(i).getId())) continue;
                Node next = i != nodes.size() - 1 ? nodes.get(i + 1) : nodes.get(0);
                this.browseBean.setupContentAction(next.getId(), false);
                break;
            }
        }
    }

    public void previousItem(ActionEvent event) {
        List<Node> nodes;
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0 && (nodes = this.browseBean.getContent()).size() > 1) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (!id.equals(nodes.get(i).getId())) continue;
                Node previous = i != 0 ? nodes.get(i - 1) : nodes.get(nodes.size() - 1);
                this.browseBean.setupContentAction(previous.getId(), false);
                break;
            }
        }
    }

    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    public String getContainerSubTitle() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_LOCATION) + ": " + this.getDocument().getNodePath().toDisplayPath(this.getNodeService(), this.getPermissionService());
    }

    public String getContainerTitle() {
        FacesContext fc = FacesContext.getCurrentInstance();
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_DETAILS_OF) + " " + Application.getMessage(fc, MSG_LEFT_QUOTE) + this.getName() + Application.getMessage(fc, MSG_RIGHT_QUOTE);
    }

    public String getBrowserUrl() {
        Node doc = this.getLinkResolvedNode();
        return Utils.generateURL(FacesContext.getCurrentInstance(), doc, Utils.URLMode.HTTP_INLINE);
    }

    public String getDownloadUrl() {
        Node doc = this.getLinkResolvedNode();
        return Utils.generateURL(FacesContext.getCurrentInstance(), doc, Utils.URLMode.HTTP_DOWNLOAD);
    }

    public boolean isLocked() {
        return this.getDocument().isLocked();
    }

    public String getUrl() {
        return (String)this.getDocument().getProperties().get("url");
    }
}

