/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean.content;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.config.PropertySheetConfigElement;
import org.alfresco.web.data.QuickSort;
import org.alfresco.web.ui.common.Utils;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentPropertiesDialog
implements Serializable {
    private static final long serialVersionUID = 3065164840163513872L;
    private static final String TEMP_PROP_MIMETYPE = "mimetype";
    private static final String TEMP_PROP_ENCODING = "encoding";
    private transient NodeService nodeService;
    private transient FileFolderService fileFolderService;
    private transient DictionaryService dictionaryService;
    protected BrowseBean browseBean;
    private List<SelectItem> contentTypes;
    private Node editableNode;
    private Boolean hasOtherProperties;

    public Node getEditableNode() {
        return this.editableNode;
    }

    public void setupDocumentForAction(ActionEvent event) {
        this.editableNode = new Node(this.browseBean.getDocument().getNodeRef());
        ContentData content = (ContentData)this.editableNode.getProperties().get(ContentModel.PROP_CONTENT);
        if (content != null) {
            this.editableNode.getProperties().put(TEMP_PROP_MIMETYPE, content.getMimetype());
            this.editableNode.getProperties().put(TEMP_PROP_ENCODING, content.getEncoding());
        }
        this.hasOtherProperties = null;
    }

    public String save() {
        String outcome = "cancel";
        UserTransaction tx = null;
        try {
            String author;
            String encoding;
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance());
            tx.begin();
            NodeRef nodeRef = this.browseBean.getDocument().getNodeRef();
            Map<String, Object> props = this.editableNode.getProperties();
            String name = (String)props.get(ContentModel.PROP_NAME);
            if (name != null) {
                this.getFileFolderService().rename(nodeRef, name);
            }
            Map properties = this.getNodeService().getProperties(nodeRef);
            String mimetype = (String)props.get(TEMP_PROP_MIMETYPE);
            if (mimetype != null) {
                props.remove(TEMP_PROP_MIMETYPE);
                ContentData contentData = (ContentData)props.get(ContentModel.PROP_CONTENT);
                if (contentData != null) {
                    contentData = ContentData.setMimetype((ContentData)contentData, (String)mimetype);
                    props.put(ContentModel.PROP_CONTENT.toString(), contentData);
                }
            }
            if ((encoding = (String)props.get(TEMP_PROP_ENCODING)) != null) {
                props.remove(TEMP_PROP_ENCODING);
                ContentData contentData = (ContentData)props.get(ContentModel.PROP_CONTENT);
                if (contentData != null) {
                    contentData = ContentData.setEncoding((ContentData)contentData, (String)encoding);
                    props.put(ContentModel.PROP_CONTENT.toString(), contentData);
                }
            }
            if ((author = (String)props.get(ContentModel.PROP_AUTHOR)) != null && author.length() != 0 && !this.getNodeService().hasAspect(nodeRef, ContentModel.ASPECT_AUTHOR)) {
                HashMap<QName, String> authorProps = new HashMap<QName, String>(1, 1.0f);
                authorProps.put(ContentModel.PROP_AUTHOR, author);
                this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_AUTHOR, authorProps);
            }
            String title = (String)props.get(ContentModel.PROP_TITLE);
            String description = (String)props.get(ContentModel.PROP_DESCRIPTION);
            if (title != null || description != null) {
                this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
            }
            for (String propName : props.keySet()) {
                PropertyDefinition propDef;
                QName qname = QName.createQName((String)propName);
                Serializable propValue = (Serializable)props.get(propName);
                if (propValue != null && propValue instanceof String && propValue.toString().length() == 0 && (propDef = this.getDictionaryService().getProperty(qname)) != null && (propDef.getDataType().getName().equals((Object)DataTypeDefinition.DOUBLE) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.FLOAT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.INT) || propDef.getDataType().getName().equals((Object)DataTypeDefinition.LONG))) {
                    propValue = null;
                }
                properties.put(qname, propValue);
            }
            this.getNodeService().setProperties(this.browseBean.getDocument().getNodeRef(), properties);
            Map<String, Map<String, AssociationRef>> addedAssocs = this.editableNode.getAddedAssociations();
            for (Map<String, AssociationRef> typedAssoc : addedAssocs.values()) {
                for (AssociationRef associationRef : typedAssoc.values()) {
                    this.getNodeService().createAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), associationRef.getTypeQName());
                }
            }
            Map<String, Map<String, AssociationRef>> removedAssocs = this.editableNode.getRemovedAssociations();
            for (Map<String, AssociationRef> typedAssoc : removedAssocs.values()) {
                for (AssociationRef associationRef : typedAssoc.values()) {
                    this.getNodeService().removeAssociation(associationRef.getSourceRef(), associationRef.getTargetRef(), associationRef.getTypeQName());
                }
            }
            Map<String, Map<String, ChildAssociationRef>> addedChildAssocs = this.editableNode.getAddedChildAssociations();
            for (Map map : addedChildAssocs.values()) {
                for (ChildAssociationRef assoc : map.values()) {
                    this.getNodeService().addChild(assoc.getParentRef(), assoc.getChildRef(), assoc.getTypeQName(), assoc.getTypeQName());
                }
            }
            Map<String, Map<String, ChildAssociationRef>> removedChildAssocs = this.editableNode.getRemovedChildAssociations();
            for (Map<String, ChildAssociationRef> map : removedChildAssocs.values()) {
                for (ChildAssociationRef assoc : map.values()) {
                    this.getNodeService().removeChild(assoc.getParentRef(), assoc.getChildRef());
                }
            }
            tx.commit();
            outcome = "finish";
            this.browseBean.getDocument().reset();
        }
        catch (FileExistsException e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            String statusMsg = MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_exists"), e.getName());
            Utils.addErrorMessage(statusMsg);
            outcome = null;
        }
        catch (InvalidNodeRefException err) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), this.browseBean.getDocument().getId()));
            outcome = "browse";
        }
        catch (Throwable e) {
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), e.getMessage()), e);
        }
        return outcome;
    }

    public Map<String, Object> getProperties() {
        return this.editableNode.getProperties();
    }

    public List<SelectItem> getContentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new ArrayList<SelectItem>(80);
            ServiceRegistry registry = Repository.getServiceRegistry(FacesContext.getCurrentInstance());
            MimetypeService mimetypeService = registry.getMimetypeService();
            Map mimeTypes = mimetypeService.getDisplaysByMimetype();
            for (String mimeType : mimeTypes.keySet()) {
                this.contentTypes.add(new SelectItem((Object)mimeType, (String)mimeTypes.get(mimeType)));
            }
            QuickSort sorter = new QuickSort(this.contentTypes, "label", true, "case-insensitive");
            sorter.sort();
        }
        return this.contentTypes;
    }

    public boolean getOtherPropertiesPresent() {
        if (this.hasOtherProperties == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigService configSvc = Application.getConfigService(FacesContext.getCurrentInstance());
            Config configProps = configSvc.getConfig((Object)this.editableNode);
            PropertySheetConfigElement propsToDisplay = (PropertySheetConfigElement)configProps.getConfigElement("property-sheet");
            this.hasOtherProperties = propsToDisplay != null && propsToDisplay.getEditableItemNamesToShow().size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasOtherProperties;
    }

    public NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    protected FileFolderService getFileFolderService() {
        if (this.fileFolderService == null) {
            this.fileFolderService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getFileFolderService();
        }
        return this.fileFolderService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public BrowseBean getBrowseBean() {
        return this.browseBean;
    }

    public void setBrowseBean(BrowseBean browseBean) {
        this.browseBean = browseBean;
    }
}

